/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;

public class OwNumberBlockPageSelectorComponent
extends OwPageSelectorComponent {
    private boolean m_useImages = true;

    public OwNumberBlockPageSelectorComponent(OwPageableView view_p) {
        super(view_p);
    }

    @Override
    public void render(Writer w_p) throws Exception {
        if (this.hasPaging() && this.shouldRenderComponent()) {
            int iPageSize = ((OwMainAppContext)this.m_view.getContext()).getPageSizeForLists();
            w_p.write("<div class=\"OwNumberBlockPageSelector\">\n");
            this.renderAccessibilityMark(w_p);
            if (this.m_view.canPagePrev()) {
                String text = this.m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingPrevBlockText", "Previous Pages");
                this.renderStep(w_p, false, text);
            }
            int iPageCount = this.m_view.getPageCount();
            int iCurrentPage = this.m_view.getCurrentPage();
            if (iPageCount > 1) {
                for (int iPage = 0; iPage < iPageCount; ++iPage) {
                    int iStartIndex = iPage * iPageSize + 1;
                    int iEndIndex = (iPage + 1) * iPageSize;
                    if (iEndIndex >= this.m_view.getCount()) {
                        iEndIndex = this.m_view.getCount();
                    }
                    this.renderPageLocation(w_p, iStartIndex, iEndIndex, iCurrentPage, iPage);
                }
            } else if (iPageCount == -1) {
                int iStartIndex = iCurrentPage * iPageSize + 1;
                int iEndIndex = iStartIndex + iPageSize;
                this.renderPageLocation(w_p, iStartIndex, iEndIndex, iCurrentPage, iCurrentPage);
            }
            if (this.m_view.canPageNext()) {
                String text = this.m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingNextBlockText", "Next Pages");
                this.renderStep(w_p, true, text);
            }
            w_p.write(" </div>");
        }
    }

    protected void renderPageLocation(Writer w, int startIdx, int endIdx, int currentPage, int renderedPage) throws IOException {
        StringBuilder strPageSet = new StringBuilder();
        strPageSet.append(startIdx);
        strPageSet.append("..");
        strPageSet.append(endIdx);
        if (currentPage == renderedPage) {
            w.write("<div  class=\"OwNumberBlockPageSelector_page_selected\">");
            w.write(strPageSet.toString());
            w.write("</div>\n");
        } else {
            w.write("<div class=\"OwNumberBlockPageSelector_page\"><a href=\"" + this.getPageAbsolutURL(renderedPage) + "\">\n");
            w.write(strPageSet.toString());
            w.write("</a></div>\n");
        }
    }

    protected void renderStep(Writer w_p, boolean stepNext, String toolTip) throws Exception {
        w_p.write("<div class=\"OwNumberBlockPageSelector_page\">");
        w_p.write("<a title=\"");
        w_p.write(toolTip);
        w_p.write("\" href=\"");
        w_p.write(stepNext ? this.getPageNextURL() : this.getPagePrevURL());
        w_p.write("\">\n");
        if (this.useImages()) {
            w_p.write("<img title=\"");
            w_p.write(toolTip);
            w_p.write("\" alt=\"");
            w_p.write(toolTip);
            w_p.write("\" src=\"");
            w_p.write(this.m_view.getContext().getDesignURL());
            if (stepNext) {
                w_p.write("/images/navigate_right_blue.png\" />");
            } else {
                w_p.write("/images/navigate_left_blue.png\" />");
            }
        } else if (stepNext) {
            w_p.write("&gt;");
        } else {
            w_p.write("&lt;");
        }
        w_p.write("</a></div>\n");
    }

    protected boolean useImages() {
        return this.m_useImages;
    }

    @Override
    public void init() throws Exception {
        if (this.m_configNode != null) {
            Node node = OwXMLDOMUtil.getChildNode(this.m_configNode, "UseImages");
            if (node != null) {
                String useImages = node.getFirstChild().getNodeValue().trim();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwNumberBlockPageSelectorComponent.init: Read from the configuration, UseImages = " + useImages));
                }
                this.m_useImages = Boolean.valueOf(useImages);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwNumberBlockPageSelectorComponent.init: No <UseImages> element found in the configuration, using default value = " + this.m_useImages));
            }
        } else {
            LOG.debug((Object)"OwNumberBlockPageSelectorComponent.init: No config node set! Using the default paging component...");
        }
    }
}

