/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassPreviewView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassProcessor;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassTreeView;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwObjectClassSelectionCfg;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwRootClassCfg;
import com.wewebu.ow.server.ecm.OwLocation;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecmimpl.OwSimpleLocation;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class OwObjectClassView
extends OwLayout
implements OwTreeView.OwTreeViewEventListner,
OwMultipanel {
    protected String m_TreeItemStyle;
    protected String m_TreeSelectedItemStyle;
    protected OwObjectClassViewListner m_listner;
    protected OwSubMenuView m_MenuView = new OwSubMenuView();
    protected OwObjectClassPreviewView m_ObjectClassPreview = new OwObjectClassPreviewView();
    public static final int TREE_REGION = 0;
    public static final int MENU_REGION = 1;
    public static final int PREVIEW_REGION = 2;
    protected int m_iNextButtonIndex = -1;
    protected OwObjectClassTreeViewViewWithStyle m_TreeView;
    protected OwResource m_resource;
    private OwObjectClassProcessor objectClassProcessor;
    private OwLocation location;
    private int m_iObjectType;
    private String m_strParentObjectClass;
    private OwObjectClassSelectionCfg classSelectionCfg;
    private boolean m_fValid = false;

    public void setSelectedItemStyle(String strStyle_p) {
        this.m_TreeSelectedItemStyle = strStyle_p;
    }

    public void setItemStyle(String strStyle_p) {
        this.m_TreeItemStyle = strStyle_p;
    }

    public void setObjectClassProcessor(OwObjectClassProcessor objectClassProcessor) {
        this.objectClassProcessor = objectClassProcessor;
        if (this.objectClassProcessor != null) {
            this.location = new OwSimpleLocation(this.m_resource);
        }
    }

    protected OwLocation getLocation() {
        return this.location;
    }

    public void setEventListner(OwObjectClassViewListner listner_p) {
        this.m_listner = listner_p;
    }

    @Override
    public String getFormName() {
        return null;
    }

    public OwObjectClassView(OwResource resource_p, int iObjectType_p, String strParentObjectClass_p) {
        this.m_resource = resource_p;
        this.m_iObjectType = iObjectType_p;
        this.m_strParentObjectClass = strParentObjectClass_p;
    }

    public OwObjectClassView(OwResource resource_p, int iObjectType_p, OwObjectClassSelectionCfg classSelectionCfg) {
        this.m_resource = resource_p;
        this.m_iObjectType = iObjectType_p;
        this.classSelectionCfg = classSelectionCfg;
    }

    public OwObjectClassView(OwResource resource_p, int iObjectType_p) {
        this.m_resource = resource_p;
        this.m_iObjectType = iObjectType_p;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_TreeView = new OwObjectClassTreeViewViewWithStyle(this.m_resource, this.m_iObjectType, this.classSelectionCfg);
        this.m_TreeView.setEventListner(this);
        this.addView(this.m_TreeView, 0, null);
        if (null != this.classSelectionCfg && !this.classSelectionCfg.getRootClasses().isEmpty()) {
            Set<OwRootClassCfg> rootClasses = this.classSelectionCfg.getRootClasses();
            HashSet<String> names = new HashSet<String>();
            for (OwRootClassCfg rootClassCfg : rootClasses) {
                names.add(rootClassCfg.getName());
            }
            Iterator namesIterator = names.iterator();
            this.m_TreeView.navigateClasses(namesIterator, null);
        } else if (this.m_strParentObjectClass != null) {
            OwObjectClass rootClass = ((OwMainAppContext)this.getContext()).getNetwork().getObjectClass(this.m_strParentObjectClass, this.m_resource);
            this.m_TreeView.navigate(rootClass, null);
        } else {
            OwMainAppContext mainContext = (OwMainAppContext)this.getContext();
            OwNetwork<?> network = mainContext.getNetwork();
            Map classNamesMap = network.getObjectClassNames(new int[]{this.m_iObjectType}, true, true, this.m_resource);
            Set names = classNamesMap.keySet();
            Iterator namesIterator = names.iterator();
            this.m_TreeView.navigateClasses(namesIterator, null);
        }
        this.addView(this.m_MenuView, 1, null);
        this.addView(this.m_ObjectClassPreview, 2, null);
    }

    public void navigateToClass(OwObjectClass objectClass_p) throws Exception {
        try {
            this.m_TreeView.navigateToClass(objectClass_p);
        }
        catch (Exception e) {
            OwObjectClassTreeViewViewWithStyle owObjectClassTreeViewViewWithStyle = this.m_TreeView;
            owObjectClassTreeViewViewWithStyle.getClass();
            this.onTreeViewOpenFolder(new OwTreeView.OwTreeViewNode(owObjectClassTreeViewViewWithStyle, this.m_TreeView, objectClass_p));
        }
    }

    @Override
    public void onTreeViewNavigateFolder(OwTreeView.OwTreeViewNode node_p) throws Exception {
    }

    @Override
    public void onTreeViewOpenFolder(OwTreeView.OwTreeViewNode node_p) throws Exception {
        Object object = node_p.getObject();
        String strPath = node_p.getPath();
        if (object instanceof OwObjectClass) {
            OwObjectClass clazz = (OwObjectClass)object;
            if (this.objectClassProcessor != null) {
                clazz = this.objectClassProcessor.process(clazz, this.getLocation(), this.getContext());
            }
            if (this.m_listner != null) {
                this.m_listner.onObjectClassViewSelectClass(clazz, strPath);
            }
            this.m_ObjectClassPreview.setObjectClass(clazz);
            if (this.m_iNextButtonIndex != -1) {
                this.m_MenuView.enable(this.m_iNextButtonIndex, true);
            }
            this.m_fValid = true;
        }
    }

    @Override
    public void setNextActivateView(OwView nextView_p) throws Exception {
        this.m_iNextButtonIndex = this.m_MenuView.addMenuItem(this, this.getContext().localize("app.OwObjectClassView.next", "Next"), null, "Next", nextView_p, null);
        this.m_MenuView.setDefaultMenuItem(this.m_iNextButtonIndex);
        this.m_MenuView.enable(this.m_iNextButtonIndex, false);
    }

    public void onNext(HttpServletRequest request_p, Object oReason_p) throws Exception {
        ((OwView)oReason_p).activate();
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        w_p.write("<div class='OwObjectClassView'>");
        w_p.write("<table border='0' cellspacing='0' cellpadding='0'>");
        w_p.write("<tr>");
        w_p.write("<th valign='top'>");
        this.renderRegion(w_p, 0);
        w_p.write("</th>");
        w_p.write("<th>&nbsp;&nbsp;&nbsp;</th>");
        w_p.write("<th valign='top'>");
        this.renderRegion(w_p, 2);
        w_p.write("</th>");
        w_p.write("</tr>");
        w_p.write("<tr><th colspan='3'>&nbsp;</th></tr>");
        w_p.write("<tr>");
        w_p.write("<th valign='top' colspan='3'>");
        this.renderRegion(w_p, 1);
        w_p.write("</th>");
        w_p.write("</tr>");
        w_p.write("</table>");
        w_p.write("</div>");
    }

    @Override
    public boolean isValidated() throws Exception {
        return this.m_fValid;
    }

    @Override
    public void setPrevActivateView(OwView prevView_p) throws Exception {
    }

    public static interface OwObjectClassViewListner {
        public void onObjectClassViewSelectClass(OwObjectClass var1, String var2) throws Exception;
    }

    public class OwObjectClassTreeViewViewWithStyle
    extends OwObjectClassTreeView {
        public OwObjectClassTreeViewViewWithStyle(OwResource resource_p, int iObjectType_p) {
            super(resource_p, iObjectType_p);
        }

        public OwObjectClassTreeViewViewWithStyle(OwResource resource_p, int iObjectType_p, OwObjectClassSelectionCfg classSelectionCfg) {
            super(resource_p, iObjectType_p, classSelectionCfg);
        }

        @Override
        protected String getSelectedTreeItemStyle() {
            if (null == OwObjectClassView.this.m_TreeSelectedItemStyle) {
                return super.getSelectedTreeItemStyle();
            }
            return OwObjectClassView.this.m_TreeSelectedItemStyle;
        }

        @Override
        protected String getTreeItemStyle() {
            if (null == OwObjectClassView.this.m_TreeItemStyle) {
                return super.getTreeItemStyle();
            }
            return OwObjectClassView.this.m_TreeItemStyle;
        }
    }
}

