/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLink;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OwObjectLinksDocument
extends OwDocument {
    private OwObjectLinkRelation[] relations;
    private Collection<String> fixedFilterClassNames;
    private OwObject object;
    private List<String> documentFunctionIds;
    private List<String> columNames;

    public OwObjectLinksDocument(OwObjectLinkRelation relation) {
        this(relation, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public OwObjectLinksDocument(OwObjectLinkRelation relation, Collection<String> filterClassNames, List<String> documentFunctionIds) {
        switch (relation) {
            case INBOUND: {
                this.relations = new OwObjectLinkRelation[]{OwObjectLinkRelation.INBOUND};
                break;
            }
            case OUTBOUND: {
                this.relations = new OwObjectLinkRelation[]{OwObjectLinkRelation.OUTBOUND};
                break;
            }
            case BOTH: {
                this.relations = new OwObjectLinkRelation[]{OwObjectLinkRelation.INBOUND, OwObjectLinkRelation.OUTBOUND};
                break;
            }
            default: {
                this.relations = new OwObjectLinkRelation[]{OwObjectLinkRelation.NONE};
            }
        }
        this.fixedFilterClassNames = filterClassNames;
        this.documentFunctionIds = documentFunctionIds;
    }

    protected boolean filterOut(OwObjectLink link) {
        return this.fixedFilterClassNames != null && !this.fixedFilterClassNames.isEmpty() && !this.fixedFilterClassNames.contains(link.getClassName());
    }

    public OwObject getObject() {
        return this.object;
    }

    protected OwObjectCollection getLinks() throws OwException {
        Collection propertyNames = null;
        OwSort sort = null;
        int maxSize = 0x3FFFFFFF;
        int versionSelection = 0;
        OwSearchNode filterCriteria = null;
        OwObjectCollection links = null;
        try {
            int[] linkTypes = new int[]{12291};
            if (this.object.hasChilds(linkTypes, versionSelection)) {
                links = this.object.getChilds(linkTypes, propertyNames, sort, maxSize, versionSelection, filterCriteria);
            }
            return links;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not retrieve object links.", (Throwable)e);
        }
    }

    public OwObjectLinkRelation[] getRelations() {
        return this.relations;
    }

    public void setObject(OwObject object) throws OwException {
        this.object = object;
        this.updateLinkViews();
    }

    protected void updateLinkViews() throws OwException {
        try {
            this.update(this, 0, null);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Error udating views.", (Throwable)e);
        }
    }

    public List<String> getLinkFunctionsIDs() {
        return this.documentFunctionIds;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columNames = columnNames;
    }

    public List<String> getColumnNames() {
        return this.columNames;
    }

    public OwObjectCollection[] getSplits() throws OwException {
        OwObjectCollection[] splits = new OwObjectCollection[this.getRelations().length];
        OwObjectCollection links = this.getLinks();
        if (links != null) {
            for (OwObjectLink link : links) {
                if (this.filterOut(link)) continue;
                for (int i = 0; i < splits.length; ++i) {
                    OwObjectLinkRelation relation = this.getRelations()[i];
                    if (OwObjectLinkRelation.NONE != relation && !relation.sameDirection(link, this.getObject())) continue;
                    if (splits[i] == null) {
                        splits[i] = new OwStandardObjectCollection();
                    }
                    splits[i].add(link);
                }
            }
        }
        return splits;
    }
}

