/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectLinksDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwSplitObjectListDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwSplitObjectListView;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwVirtualLinkPropertyClasses;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OwObjectLinksView
extends OwLayout {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectLinksView.class);
    public static final int LINKS_REGION = 1;
    public static final int LINKS_FILTER_REGION = 2;
    private boolean noLinks;

    public OwObjectLinksView(OwObjectLinksDocument document) {
        this.setDocument(document);
    }

    @Override
    public OwObjectLinksDocument getDocument() {
        return (OwObjectLinksDocument)super.getDocument();
    }

    protected Collection<OwFieldColumnInfo> createColumnInfo(Collection<String> propertyList_p) throws Exception {
        LinkedList<OwFieldColumnInfo> columnInfoList = new LinkedList<OwFieldColumnInfo>();
        for (String strPropertyName : propertyList_p) {
            OwFieldDefinition fielddef = null;
            try {
                fielddef = ((OwMainAppContext)this.getContext()).getNetwork().getFieldDefinition(strPropertyName, null);
                columnInfoList.add(new OwStandardFieldColumnInfo(fielddef));
            }
            catch (OwObjectNotFoundException e) {
                LOG.warn((Object)("Property could not be resolved for OwObjectHistoryView list: " + strPropertyName), (Throwable)e);
            }
        }
        return columnInfoList;
    }

    @Override
    protected void init() throws Exception {
        super.init();
    }

    public boolean isEmpty() {
        return this.noLinks;
    }

    protected void refresh(OwObjectCollection[] splitLinks) throws Exception {
        this.noLinks = true;
        for (OwObjectCollection links : splitLinks) {
            if (links == null || links.isEmpty()) continue;
            this.noLinks = false;
            break;
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        super.renderRegion(w_p, iRegion_p);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        OwObjectLinksDocument document = this.getDocument();
        this.refresh(document.getSplits());
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("dmsdialogs/OwObjectLinksView.jsp", w_p);
    }

    protected List<OwDocumentFunction> getDocumentFunctions() throws OwException {
        LinkedList<OwDocumentFunction> functions = new LinkedList<OwDocumentFunction>();
        OwObjectLinksDocument document = this.getDocument();
        List<String> functionIDs = document.getLinkFunctionsIDs();
        if (functionIDs != null) {
            for (String id : functionIDs) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                try {
                    OwDocumentFunction function = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                    functions.add(function);
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OwConfigurationException("Error creating link functions.", (Throwable)e);
                }
            }
        }
        return functions;
    }

    protected OwSplitObjectListView createSplitView() throws Exception {
        OwObjectLinksDocument document = this.getDocument();
        OwObjectLinkRelation[] relations = document.getRelations();
        String[] splitNames = new String[relations.length];
        Collection[] propertyColumnInfos = new Collection[relations.length];
        for (int i = 0; i < relations.length; ++i) {
            if (relations[i] != OwObjectLinkRelation.NONE) {
                splitNames[i] = relations[i].getDisplayName().getString(this.getContext().getLocale());
                propertyColumnInfos[i] = this.createRelationColumnInfo(relations[i]);
                continue;
            }
            splitNames[i] = "";
            propertyColumnInfos[i] = this.createColumnInfo(Arrays.asList(OwResource.m_ClassDescriptionPropertyClass.getClassName()));
        }
        return new OwSplitObjectListView(this.createSplitObjectListDocument(splitNames, propertyColumnInfos, this.getDocumentFunctions()));
    }

    protected OwSplitObjectListDocument createSplitObjectListDocument(String[] splitNames, Collection<OwFieldColumnInfo>[] propertyColumnInfos, List<OwDocumentFunction> documentFunctions) {
        return new OwSplitObjectListDocument(splitNames, propertyColumnInfos, documentFunctions);
    }

    protected Collection<OwFieldColumnInfo> createRelationColumnInfo(OwObjectLinkRelation relation) throws Exception {
        Collection<OwFieldColumnInfo> propertyColumnInfo = this.getDocument().getColumnNames() != null ? this.createColumnInfo(this.getDocument().getColumnNames()) : (OwObjectLinkRelation.INBOUND == relation ? this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName(), OwResource.m_ClassDescriptionPropertyClass.getClassName())) : (OwObjectLinkRelation.OUTBOUND == relation ? this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName(), OwResource.m_ClassDescriptionPropertyClass.getClassName())) : this.createColumnInfo(Arrays.asList(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName(), OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName(), OwResource.m_ClassDescriptionPropertyClass.getClassName()))));
        return propertyColumnInfo;
    }

    public String getFilterDisplayName() {
        return "";
    }
}

