/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.button.OwImageButton;
import com.wewebu.ow.server.ui.button.OwImageButtonView;
import com.wewebu.ow.server.ui.helper.OwInnerViewWrapper;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwObjectListViewControl
extends OwImageButtonView {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewControl.class);
    private static final String PERSISTENT_INDEX_ATTRIBUTE = "OwObjectListViewControl_Index";
    private static final String INDEX_KEY = "index";
    private OwInnerViewWrapper m_InnerViewWrapper = new OwInnerViewWrapper();
    private List<OwListViewEntry> m_objectlists = new ArrayList<OwListViewEntry>();
    private List m_documentFunctionPluginList = null;
    private int m_currentindex = -1;
    private OwObjectListViewControlEventListener m_eventlistner;

    public void setEventListener(OwObjectListViewControlEventListener eventlistner_p) {
        this.m_eventlistner = eventlistner_p;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setHtmlId("OwObjectListButtonControlView");
    }

    @Override
    public boolean isShowMaximized() {
        return this.getParent().isShowMaximized();
    }

    public OwBaseView getViewReference() {
        return this.m_InnerViewWrapper;
    }

    public OwObjectListView getObjectListView() {
        OwListViewEntry viewentry = this.m_objectlists.get(this.m_currentindex);
        return viewentry.getObjectListView();
    }

    public void setDocumentFunctionPluginList(List pluginList_p) {
        this.m_documentFunctionPluginList = pluginList_p;
        for (OwListViewEntry listViewEntry : this.m_objectlists) {
            listViewEntry.getObjectListView().setDocumentFunctionPluginList(pluginList_p);
        }
    }

    public List<OwListViewEntry> getObjectLists() {
        return this.m_objectlists;
    }

    public int getCurrentIndex() {
        return this.m_currentindex;
    }

    public String getObjectListViewControlEventURL(int iViewIndex_p) {
        return this.getEventURL("Select", "index=" + String.valueOf(iViewIndex_p));
    }

    @Override
    public void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectListViewControl.jsp", w_p);
    }

    public void renderButtons(Writer w_p) throws Exception {
        super.onRender(w_p);
    }

    public void onSelect(HttpServletRequest request_p) throws Exception {
        int iNewIndex = Integer.parseInt(request_p.getParameter(INDEX_KEY));
        this.activateListView(iNewIndex);
        this.getDocument().getPersistentAttributeBagWriteable().setAttribute(PERSISTENT_INDEX_ATTRIBUTE, String.valueOf(iNewIndex));
        this.getDocument().getPersistentAttributeBagWriteable().save();
    }

    public void activateListView() throws Exception {
        int iNewIndex = Integer.parseInt((String)this.getDocument().getPersistentAttributeBagWriteable().getSafeAttribute(PERSISTENT_INDEX_ATTRIBUTE, "0"));
        if (iNewIndex < this.m_objectlists.size()) {
            this.activateListView(iNewIndex);
        } else {
            this.activateListView(0);
        }
    }

    public void activateListView(int iNewIndex_p) throws Exception {
        OwObjectListView oldview = null;
        if (-1 != this.m_currentindex) {
            oldview = this.m_objectlists.get(this.m_currentindex).getObjectListView();
        }
        OwObjectListView newview = this.m_objectlists.get(iNewIndex_p).getObjectListView();
        this.m_InnerViewWrapper.setView(newview);
        if (null != this.m_eventlistner) {
            this.m_eventlistner.onActivateObjectListView(iNewIndex_p, this.m_currentindex, newview, oldview);
        }
        if (null != oldview) {
            newview.copy(oldview);
        }
        this.m_currentindex = iNewIndex_p;
    }

    public void setConfigNode(Node subNode_p) throws Exception {
        if (null == subNode_p) {
            String msg = "OwObjectListViewControl.setConfigNode: Please define a ResultListViews node in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        for (Node n = subNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals("view")) continue;
            String sClassName = OwXMLDOMUtil.getSafeStringAttributeValue(n, "classname", null);
            Class<?> ListViewClass = Class.forName(sClassName);
            OwObjectListView listview = (OwObjectListView)ListViewClass.newInstance();
            listview.setConfigNode(n);
            if (this.m_documentFunctionPluginList != null) {
                listview.setDocumentFunctionPluginList(this.m_documentFunctionPluginList);
            }
            this.addView(listview, null);
            this.m_objectlists.add(new OwListViewEntry(listview));
        }
        if (this.m_objectlists.size() == 0) {
            String msg = "OwObjectListViewControl.setConfigNode: Please define a ResultListViews node in the plugin descriptor and at least one view node.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
    }

    @Override
    public List<OwImageButton> getButtonList() {
        LinkedList<OwImageButton> lst = new LinkedList<OwImageButton>();
        List<OwListViewEntry> viewEntries = this.getObjectLists();
        for (int i = 0; i < viewEntries.size(); ++i) {
            OwListViewEntry viewentry = viewEntries.get(i);
            OwImageButton button = new OwImageButton();
            button.setDesignClass(i == this.getCurrentIndex() ? "OwObjectListViewControl_entry_selected" : "OwObjectListViewControl_entry");
            button.setTooltip(viewentry.getTitle());
            button.setEventString(this.getObjectListViewControlEventURL(i));
            try {
                button.setImageLink(this.getContext().getDesignURL() + viewentry.getIcon());
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Image could not be retrieved", (Throwable)e);
                }
                LOG.warn((Object)"Image could not be retrieved.");
            }
            lst.add(button);
        }
        return lst;
    }

    public static interface OwObjectListViewControlEventListener
    extends EventListener {
        public void onActivateObjectListView(int var1, int var2, OwObjectListView var3, OwObjectListView var4) throws Exception;
    }

    public static class OwListViewEntry {
        private OwObjectListView m_listview;

        public OwListViewEntry(OwObjectListView listview_p) {
            this.m_listview = listview_p;
        }

        public OwObjectListView getObjectListView() {
            return this.m_listview;
        }

        public String getIcon() throws Exception {
            return this.m_listview.getIcon();
        }

        public String getTitle() {
            return this.m_listview.getTitle();
        }
    }
}

