/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class OwObjectListViewFilterRow
extends OwObjectListViewRow {
    protected static final String FILTER_PROPERTY_KEY = "fprop";
    public static final String FILTER_OPERATOR_SELECT_ID = "filterop";
    protected OwObjectListView.OwFilterEntry m_currentfilter;

    public OwObjectListViewFilterRow(int iViewMask_p) {
        super(iViewMask_p);
    }

    public OwObjectListViewFilterRow() {
    }

    @Override
    protected void renderPropertyColumnHeader(Writer w_p, OwFieldColumnInfo colInfo_p) throws Exception {
        if (this.getFilter() != null) {
            try {
                boolean fAktive = this.getFilter().getFilterEntry(colInfo_p.getPropertyName()).isActive();
                w_p.write("<a href=\"");
                w_p.write(this.getEventURL("EditFilter", "fprop=" + colInfo_p.getPropertyName()));
                w_p.write("\" title=\"");
                String tooltipMessage = this.getContext().localize1("app.dmsdialogs.OwObjectListViewFilterRow.filtersettingstootlip", "Filter settings for %1", colInfo_p.getDisplayName(this.getContext().getLocale()));
                w_p.write(tooltipMessage);
                w_p.write("\">");
                w_p.write("<img  class=\"OwGeneralList_sortimg\" border='0' src=\"");
                w_p.write(this.getContext().getDesignURL());
                w_p.write("/images/OwObjectListView/");
                if (fAktive) {
                    w_p.write("filteractive.png\"");
                } else {
                    w_p.write("filter.png\"");
                }
                w_p.write(" alt=\"");
                w_p.write(tooltipMessage);
                w_p.write("\" title=\"");
                w_p.write(tooltipMessage);
                w_p.write("\" /></a>&nbsp;");
            }
            catch (OwObjectNotFoundException owObjectNotFoundException) {
                // empty catch block
            }
        }
        super.renderPropertyColumnHeader(w_p, colInfo_p);
    }

    @Override
    public void setFilter(OwObjectListView.OwFilter filter_p) {
        super.setFilter(filter_p);
        this.m_currentfilter = null;
        this.activateNextFilter();
    }

    public void onEditFilter(HttpServletRequest request_p) throws Exception {
        OwObjectListView.OwFilterEntry filter;
        this.m_currentfilter = filter = this.getFilter().getFilterEntry(request_p.getParameter(FILTER_PROPERTY_KEY));
    }

    public void onSetFilterValue(HttpServletRequest request_p) throws Exception {
        this.getFieldManager().update(request_p, null, null);
        this.m_currentfilter.setActive(true);
        this.getFilter().save(this.getDocument().getPersistentAttributeBagWriteable());
        this.getEventListner().onObjectListViewFilterChange(this.getFilterSearch(), this.getParentObject());
    }

    public void onChangeFilterOperator(HttpServletRequest request_p) throws Exception {
        int iOperator = Integer.parseInt(request_p.getParameter(FILTER_OPERATOR_SELECT_ID));
        this.m_currentfilter.setOperator(iOperator);
    }

    public void onEnableFilter(HttpServletRequest request_p) throws Exception {
        this.m_currentfilter.toggle();
        this.getFieldManager().update(request_p, null, null);
        this.getFilter().save(this.getDocument().getPersistentAttributeBagWriteable());
        this.getEventListner().onObjectListViewFilterChange(this.getFilterSearch(), this.getParentObject());
        this.activateNextFilter();
    }

    protected void activateNextFilter() {
        if (null == this.m_currentfilter || !this.m_currentfilter.isActive()) {
            this.m_currentfilter = null;
            for (OwObjectListView.OwFilterEntry filterentry : this.getFilter().values()) {
                if (!filterentry.isActive()) continue;
                this.m_currentfilter = filterentry;
                break;
            }
        }
    }

    @Override
    protected void renderMainRegion(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectListViewFilterRow.jsp", w_p);
    }

    public OwObjectListView.OwFilterEntry getCurrentFilter() {
        return this.m_currentfilter;
    }

    public String getEnableFilterURL() {
        return this.getFormEventURL("EnableFilter", null);
    }

    public String getSetFilterValueURL() {
        return this.getFormEventURL("SetFilterValue", null);
    }

    public String getChangeFilterOperatorURL() {
        return this.getFormEventURL("ChangeFilterOperator", null);
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("dmsdialogs.views.OwObjectListViewFilterRow.title", "Filterable List");
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewFilterRow.png";
    }
}

