/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwMultipleSelectionCall;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwScriptTable;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwObjectListViewThumbnails
extends OwPageableListView
implements OwFieldProvider {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewThumbnails.class);
    public static final int DEFAULT_THUMBS_PER_ROW = Integer.MAX_VALUE;
    protected OwMainAppContext m_MainContext;
    protected int m_iCurrentPage = 0;
    protected int MAX_THUMBNAIL_PER_ROW = Integer.MAX_VALUE;
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_DMSID = "{dmsid}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL = "{serverurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_BASEURL = "{baseurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START = "{prop";
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_ENCODE_CHAR = ':';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_NOENCODE_CHAR = '#';
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END = "}";
    protected OwSort m_Sort;
    protected boolean m_useContextMenu;
    protected OwMimeManager m_MimeManager;
    protected Collection<?> m_ColumnInfoList;
    protected OwFieldManager m_theFieldManager;
    protected OwClientRefreshContext m_RefreshContext;
    private Set<Integer> m_occuredObjectTypes;
    private static final String THUMBNAIL_TYPES_NODE_NAME = "ThumbnailTypes";
    public static final int THUMBNAIL_LIST = 1;
    public static final int CONTEXT_MENU = 2;
    public static final int PAGE_BUTTONS = 3;
    protected ArrayList<ThumbnailTypeConfig> m_ThumbnailTypes = new ArrayList();

    public OwObjectListViewThumbnails(int iViewMask_p) {
        super(iViewMask_p);
        this.m_MimeManager = new OwMimeManager();
    }

    public OwObjectListViewThumbnails() {
        this.m_MimeManager = new OwMimeManager();
    }

    public boolean getIsList() {
        return this.getCount() != 0 && this.getIsListValid();
    }

    public boolean getIsListValid() {
        return (this.getObjectList() != null || this.getObjectIterable() != null) && this.getColumnInfo() != null;
    }

    @Override
    public void setConfigNode(Node node_p) throws Exception {
        super.setConfigNode(node_p);
        Node thumbnailtypesNode = OwXMLDOMUtil.getChildNode(node_p, THUMBNAIL_TYPES_NODE_NAME);
        if (null == thumbnailtypesNode) {
            String msg = "OwObjectListViewThumbnails.setConfigNode: Please define a ThumbnailTypes node in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_ThumbnailTypes.clear();
        List thumbnailTypes = OwXMLDOMUtil.getSafeNodeList(thumbnailtypesNode);
        for (Node thumbnailTypeNode : thumbnailTypes) {
            String sDisplayname = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "displayname", null);
            String sWidth = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "width", null);
            String sHeight = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "height", null);
            boolean scale = false;
            String sUrl = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "url", null);
            if (sDisplayname == null || sUrl == null) continue;
            try {
                int iWidth = -1;
                int iHeight = -1;
                if (sWidth != null && sWidth.trim().length() > 0) {
                    iWidth = Integer.parseInt(sWidth);
                    scale = true;
                }
                if (sHeight != null && sHeight.trim().length() > 0) {
                    iHeight = Integer.parseInt(sHeight);
                    scale = true;
                }
                this.m_ThumbnailTypes.add(new ThumbnailTypeConfig(sDisplayname, iWidth, iHeight, scale, sUrl));
            }
            catch (Exception e) {
                LOG.debug((Object)"Invalid thumbnail configuration.", (Throwable)e);
            }
        }
        if (this.m_ThumbnailTypes.size() <= 0) {
            String msg = "OwObjectListViewThumbnails.setConfigNode: Please define at least one ThumbnailType in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
    }

    protected static String replaceProperties(OwMainAppContext context_p, String strIn_p, OwObjectReference obj_p) throws Exception {
        int iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START);
        if (-1 == iIndex) {
            return strIn_p;
        }
        OwObject obj = obj_p.getInstance();
        int iOldIndex = 0;
        StringBuilder strRet = new StringBuilder();
        while (-1 != iIndex) {
            strRet.append(strIn_p.substring(iOldIndex, iIndex));
            ++iIndex;
            int iEnd = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END, iIndex += VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START.length());
            String strPropName = strIn_p.substring(iIndex, iEnd);
            if (strIn_p.charAt(iIndex - 1) == ':') {
                try {
                    strRet.append(OwAppContext.encodeURL(obj.getProperty(strPropName).getValue().toString()));
                }
                catch (Exception e) {}
            } else {
                try {
                    strRet.append(obj.getProperty(strPropName).getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            iOldIndex = iIndex = iEnd + 1;
            iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START, iIndex);
        }
        if (iOldIndex <= strIn_p.length()) {
            strRet.append(strIn_p.substring(iOldIndex, strIn_p.length()));
        }
        return strRet.toString();
    }

    protected String getHtmlAlignment(int iAlignment_p) {
        return OwObjectListViewThumbnails.m_HtmlAlignments.m_list[iAlignment_p];
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        super.setObjectList(objectList_p, parentObject_p);
        this.m_MimeManager.setParent(parentObject_p);
        this.resetPersistedSelectionState();
    }

    @Override
    public void setObjectIterable(OwIterable<OwObject> iterable, OwObject parentObject_p) throws Exception {
        super.setObjectIterable(iterable, parentObject_p);
        this.m_MimeManager.setParent(parentObject_p);
        this.resetPersistedSelectionState();
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    @Override
    protected boolean isPagingEnabled() {
        return !this.getParent().isShowMaximized();
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        super.setRefreshContext(eventlister_p);
        this.m_MimeManager.setRefreshContext(eventlister_p);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        if (this.hasViewMask(1)) {
            boolean bl = this.m_useContextMenu = this.m_MainContext.getConfiguration().isDocmentFunctionRequirement(1) && (this.hasViewMask(4) || this.hasViewMask(16));
            if (!this.m_useContextMenu) {
                this.clearViewMask(4);
                this.clearViewMask(16);
            }
        } else {
            this.m_useContextMenu = false;
            this.clearViewMask(4);
            this.clearViewMask(16);
        }
        this.setSort(new OwSort(this.m_MainContext.getMaxSortCriteriaCount(), true));
        this.setFieldManager(this.m_MainContext.createFieldManager());
        this.getFieldManager().setExternalFormTarget(this.getFormTarget());
        this.getFieldManager().setFieldProvider(this);
        this.m_MimeManager.attach(this.m_MainContext, null);
        this.m_pageSelectorComponent = this.createPageSelector();
    }

    @Override
    public void detach() {
        this.m_MimeManager.detach();
        super.detach();
    }

    protected String getThumbnailRowId(int idx_p, int line_p) {
        String x = "" + line_p;
        while (x.length() < 4) {
            x = "0" + x;
        }
        return "mtn" + x + "_" + this.getListViewID() + "_" + idx_p;
    }

    protected Set<Integer> renderThumbnails(Writer w_p, Collection<OwObjectListView.OwPluginEntry> instancePluginsList_p) throws Exception {
        int iStartIndex = 0;
        int iPageSize = this.getPageSize();
        iStartIndex = this.getCurrentPage() * iPageSize;
        int iEndIndex = iStartIndex + iPageSize;
        if (!this.m_ThumbnailTypes.isEmpty()) {
            StringWriter writeBuffer = new StringWriter();
            ThumbnailTypeConfig defaultTT = this.m_ThumbnailTypes.get(0);
            String script = String.format("currentThumnailTypeConfig = {type : %d, width : %d, height : %d, scale : %b};", 0, defaultTT.getWidth(), defaultTT.getHeight(), defaultTT.isScale());
            writeBuffer.write("<script type=\"text/javascript\">\n" + script + "\n</script>");
            w_p.write(writeBuffer.getBuffer().toString());
        }
        HashSet<Integer> occuredObjectTypes = new HashSet<Integer>();
        String listViewId = String.valueOf(this.getListViewID());
        int i = iStartIndex;
        ArrayList<OwObject> cachedPage = new ArrayList<OwObject>();
        for (OwObject obj : this.getDisplayedPage()) {
            cachedPage.add(obj);
        }
        int pageItemsCount = cachedPage.size();
        for (OwObject obj : cachedPage) {
            try {
                StringWriter writeBuffer = new StringWriter();
                boolean objectIsSelected = this.isObjectSelectionPersisted(i);
                String thumbDivClass = "OwObjectListViewThumbnails_div";
                if (objectIsSelected) {
                    thumbDivClass = "OwObjectListViewThumbnails_divselected";
                }
                occuredObjectTypes.add(obj.getType());
                this.renderBlockBegin(iStartIndex, i, writeBuffer);
                writeBuffer.write("<div id=\"owtndiv_");
                writeBuffer.write(listViewId);
                writeBuffer.write("_" + i);
                writeBuffer.write("\" class=\"");
                writeBuffer.write(thumbDivClass);
                writeBuffer.write("\">\n");
                int linecounter = 1;
                writeBuffer.write("<table class=\"OwObjectListViewThumbnails_table\" name=\"OwObjectListViewThumbnails_table\">\n");
                writeBuffer.write("<tr id=\"");
                writeBuffer.write(this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\">\n");
                writeBuffer.write("<td class=\"OwObjectListViewThumbnails_headcell\">\n");
                writeBuffer.write("<table><tbody class=\"OwObjectListViewThumbnails_HeadTableBody\"><tr>");
                writeBuffer.write("<td align=\"center\" valign=\"middle\" style=\"display:none;\"  width=\"10%\">");
                writeBuffer.write("<input onclick=\"onClickThumbnailCheckBox('" + i);
                writeBuffer.write("','");
                writeBuffer.write(listViewId);
                writeBuffer.write("');\" type=\"checkbox\"");
                writeBuffer.write(" id=\"owtcid_");
                writeBuffer.write(listViewId);
                writeBuffer.write("_" + i);
                writeBuffer.write("\" name=\"owtcb_");
                writeBuffer.write(listViewId);
                writeBuffer.write("\" title=\"");
                writeBuffer.write(this.getContext().localize1("app.OwObjectListViewThumbnails.thumbnail.checkbox.title", "Thumbnail %1", "" + (i + 1)));
                writeBuffer.write("\" value=\"" + i + "\"");
                if (objectIsSelected) {
                    writeBuffer.write(" checked");
                }
                writeBuffer.write(">\n");
                writeBuffer.write("</td>\n");
                this.renderLockedColumn(writeBuffer, obj);
                writeBuffer.write("</tr></tbody></table>");
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr>\n");
                writeBuffer.write("<tr id=\"");
                writeBuffer.write(this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\" class=\"OwObjectListViewThumbnails_name_row\">\n");
                writeBuffer.write("<td class=\"OwObjectListViewThumbnails_cell\" align=\"center\" style=\"text-align:center\"");
                writeBuffer.write(">\n");
                writeBuffer.write("<p class=\"OwObjectListViewThumbnails_ellipsis_name\" style=\"width:1px\">");
                this.m_MimeManager.insertTextLink(writeBuffer, obj.getName(), obj);
                writeBuffer.write("</p>");
                writeBuffer.write("\n</td>\n</tr>\n");
                writeBuffer.write("<tr id=\"" + this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\" class=\"OwObjectListViewThumbnails_image_row\">\n");
                writeBuffer.write("<td class=\"OwObjectListViewThumbnails_cell\" style=\"vertical-align:top;\">\n");
                writeBuffer.write("<img class=\"OwObjectListViewThumbnails_image\" align=\"absmiddle\" alt=\"\" title=\"\"");
                boolean defaultdone = false;
                for (int ii = 0; ii < this.m_ThumbnailTypes.size(); ++ii) {
                    ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(ii);
                    StringBuilder sUrl = new StringBuilder(ttc.getUrl());
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_BASEURL, this.getContext().getBaseURL() + "/");
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL, this.getContext().getServerURL() + "/");
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_DMSID, OwAppContext.encodeURL(obj.getDMSID()));
                    String rsUrl = OwObjectListViewThumbnails.replaceProperties((OwMainAppContext)this.getContext(), sUrl.toString(), obj);
                    if (!defaultdone) {
                        writeBuffer.write(" src=\"");
                        writeBuffer.write(rsUrl);
                        writeBuffer.write("\"");
                        defaultdone = true;
                    }
                    if (ttc.getWidth() > 0) {
                        writeBuffer.write(" width");
                        writeBuffer.write(Integer.toString(ii));
                        writeBuffer.write("=");
                        writeBuffer.write("'");
                        writeBuffer.write(String.valueOf(ttc.getWidth()));
                        writeBuffer.write("'");
                    }
                    if (ttc.getHeight() > 0) {
                        writeBuffer.write(" height");
                        writeBuffer.write(Integer.toString(ii));
                        writeBuffer.write("=");
                        writeBuffer.write("'");
                        writeBuffer.write(String.valueOf(ttc.getHeight()));
                        writeBuffer.write("'");
                    }
                    writeBuffer.write(" type" + ii);
                    writeBuffer.write("src=\"");
                    writeBuffer.write(rsUrl);
                    writeBuffer.write("\"");
                }
                writeBuffer.write(" border=\"0\" onload=\"onThumbReady(");
                writeBuffer.write("" + pageItemsCount);
                writeBuffer.write(")\" onerror=\"onThumbReady(");
                writeBuffer.write("" + pageItemsCount);
                writeBuffer.write(")\" name=\"OwObjectListViewThumbnails_image\">\n");
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr>\n");
                writeBuffer.write("<tr id=\"");
                writeBuffer.write(this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\" class=\"OwObjectListViewThumbnails_plugin_row\">\n");
                writeBuffer.write("<td align=\"center\" style=\"text-align: center\" valign=\"middle\">\n");
                this.insertThumbnailBar(writeBuffer, obj, i, instancePluginsList_p);
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr>");
                writeBuffer.write("</table>\n");
                writeBuffer.write("</div>\n");
                this.renderBlockEnd(iStartIndex, iEndIndex, i, writeBuffer);
                w_p.write(writeBuffer.getBuffer().toString());
                ++i;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not render thumbnail!", (Throwable)e);
            }
        }
        if (i < iEndIndex - 1) {
            StringWriter writeBuffer = new StringWriter();
            this.renderBlockEnd(0, i + 1, i, writeBuffer);
            w_p.write(writeBuffer.getBuffer().toString());
        }
        String strToolTip = this.getContext().localize("app.OwObjectListView.toggleselectall", "Alles (de)selektieren");
        this.getContext().registerKeyEvent(65, 512, "javascript:keyboardSelectAll();", strToolTip);
        w_p.write("\n\n<script type=\"text/javascript\">activeListCheckBoxId=");
        w_p.write("\"owtcb_");
        w_p.write(listViewId);
        w_p.write("\";</script>\n\n");
        return occuredObjectTypes;
    }

    protected void renderBlockBegin(int startIndexPosition_p, int currentPosition_p, StringWriter w_p) {
        if ((currentPosition_p - startIndexPosition_p) % this.MAX_THUMBNAIL_PER_ROW == 0) {
            w_p.write("<div class=\"OwBlock\">");
        }
    }

    protected void renderBlockEnd(int startIndexPosition_p, int endIndexPosition_p, int currentPosition_p, StringWriter w_p) {
        if (currentPosition_p == endIndexPosition_p - 1 || (currentPosition_p - startIndexPosition_p) % this.MAX_THUMBNAIL_PER_ROW == this.MAX_THUMBNAIL_PER_ROW - 1) {
            w_p.write("</div><!-- end of .OwBlock -->");
        }
    }

    private void renderLockedColumn(StringWriter writeBuffer_p, OwObject obj_p) throws Exception {
        if (obj_p.getLock(1)) {
            String lockedTooltip = this.getContext().localize("image.locked", "Locked item");
            writeBuffer_p.write("<td width=\"10%\"><img src=\"" + this.getContext().getDesignURL() + "/images/plug/owbpm/locked.png\" alt=\"" + lockedTooltip + "\" title=\"" + lockedTooltip + "\"/></td>\n");
        }
    }

    @Override
    public boolean isRegion(int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 3: {
                return this.isPagingEnabled() && !this.hasViewMask(32);
            }
        }
        return super.isRegion(iRegion_p);
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                if (this.m_useContextMenu) {
                    this.renderContextMenu(w_p, this.m_occuredObjectTypes);
                }
                if (!this.hasViewMask(4)) break;
                OwScriptTable.writeSelectableListEnableScript(String.valueOf(this.getListViewID()), w_p, this.getContext());
                break;
            }
            case 1: {
                this.m_occuredObjectTypes = this.renderThumbnails(w_p, this.getPluginEntries());
                break;
            }
            case 3: {
                if (!this.hasPaging()) break;
                this.renderPageButtons(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public String getThumbnailTypeDisplayName(int i_p) {
        ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(i_p);
        return ((OwMainAppContext)this.getContext()).localizeLabel(ttc.getDisplayname());
    }

    public int getThumbnailTypeCount() {
        return this.m_ThumbnailTypes.size();
    }

    public String getThumbnailTypeUrl(int i_p) {
        ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(i_p);
        return "javascript:Thumbnails_setType(" + i_p + "," + ttc.getWidth() + "," + ttc.getHeight() + "," + ttc.isScale() + ");";
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.m_MimeManager.reset();
        this.getFieldManager().reset();
        this.addAjaxPersistenceService(w_p, "PersistSelection");
        this.serverSideDesignInclude("OwObjectListViewThumbnails.jsp", w_p);
        ((OwMainAppContext)this.getContext()).registerMouseAction("object.list.select.deselect.nonconsecutive", new OwString("OwObjectListView.nonconsecutive.select.description", "Select/Deselect result list entry"));
    }

    public void onAjaxPersistSelection(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.persistAjaxTriggeredSelection(request_p, response_p);
    }

    protected void renderPageButtons(Writer w_p) throws Exception {
        this.m_pageSelectorComponent.render(w_p);
    }

    protected void insertThumbnailBar(Writer w_p, OwObject obj_p, int iIndex_p, Collection<OwObjectListView.OwPluginEntry> instancePluginsList_p) throws Exception {
        String statusDivStart = "<div class=\"OwObjectListViewThumbnails_status\">";
        w_p.write("<div class=\"OwObjectListViewThumbnails_status\">");
        this.insertStatus(w_p, obj_p, iIndex_p);
        w_p.write("</div>");
        this.insertDocumentFunctionPlugins(w_p, obj_p, iIndex_p, instancePluginsList_p);
        w_p.write("<div class=\"OwObjectListViewThumbnails_status\">");
        w_p.write("&nbsp;");
        w_p.write("</div>");
    }

    protected void insertStatus(Writer w_p, OwObject obj_p, int iIndex_p) throws Exception {
        if (obj_p.hasVersionSeries() && obj_p.getVersion().isCheckedOut(1)) {
            w_p.write("<img src=\"" + this.getContext().getDesignURL() + "/images/checkedout.png\" alt=\"Checkedout\">");
        } else {
            w_p.write("&nbsp;");
        }
    }

    protected void insertDocumentFunctionPlugins(Writer w_p, OwObject obj_p, int iIndex_p, Collection<OwObjectListView.OwPluginEntry> instancePluginsList_p) throws Exception {
        w_p.write("<div class=\"OwObjectListViewThumbnails_dfplugins\">");
        for (OwObjectListView.OwPluginEntry plugInEntry : instancePluginsList_p) {
            if (!plugInEntry.m_Plugin.isEnabled(obj_p, this.getParentObject(), 1)) continue;
            w_p.write("<div class=\"OwObjectListViewThumbnails_dfcell\">");
            if (plugInEntry.m_Plugin.getNoEvent()) {
                w_p.write(plugInEntry.m_Plugin.getIconHTML(obj_p, null));
            } else {
                w_p.write("<a href=\"");
                w_p.write(this.getEventURL("PluginEvent", "oi"));
                w_p.write("=");
                w_p.write(String.valueOf(iIndex_p));
                w_p.write("&");
                w_p.write("pi");
                w_p.write("=");
                w_p.write(String.valueOf(plugInEntry.m_iIndex));
                w_p.write("\" title=\"");
                w_p.write(plugInEntry.m_Plugin.getTooltip());
                w_p.write("\" class=\"OwGeneralList_Plugin_a\">");
                w_p.write(plugInEntry.m_Plugin.getIconHTML(obj_p, null));
                w_p.write("</a>\n");
            }
            w_p.write("</div>");
        }
        w_p.write("</div>");
    }

    public void onSort(HttpServletRequest request_p) throws Exception {
        String strSortProperty = request_p.getParameter("prop");
        if (strSortProperty != null) {
            this.getSort().toggleCriteria(strSortProperty);
            if (this.getEventListner() != null) {
                this.getEventListner().onObjectListViewSort(this.getSort(), strSortProperty);
            }
            if (this.getObjectList() != null) {
                this.getObjectList().sort(this.getSort());
            }
        }
    }

    public void onContextMenuEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("pi");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    public void onColumnClickEvent(HttpServletRequest request_p) throws Exception {
        int iPlugIndex = Integer.parseInt(request_p.getParameter("pi"));
        OwDocumentFunction plugIn = this.getPluginEntries().get(iPlugIndex).getPlugin();
        OwObjectCollection processedObjects = this.getObjectList();
        if (processedObjects == null) {
            processedObjects = new OwStandardObjectCollection();
            for (OwObject obj : this.getDisplayedPage()) {
                processedObjects.add(obj);
            }
        }
        plugIn.onColumnClickEvent(processedObjects, this.getParentObject(), this.getRefreshContext());
    }

    public void onMultiSelectEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("owmcm");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    private void multiSelectEvent(HttpServletRequest request_p, String strPluginIndex_p) throws Exception {
        String[] checked = request_p.getParameterValues("owtcb_" + this.getListViewID());
        if (null != checked && strPluginIndex_p != null) {
            int iPlugIndex = Integer.parseInt(strPluginIndex_p);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            LinkedList<OwObject> objects = new LinkedList<OwObject>();
            for (int i = 0; i < checked.length; ++i) {
                OwObject obj = this.getObjectByIndex(Integer.parseInt(checked[i]));
                objects.add(obj);
            }
            if (objects.size() == 1) {
                plugIn.onClickEvent((OwObject)objects.get(0), this.getParentObject(), this.getRefreshContext());
            } else {
                if (!plugIn.getMultiselect()) {
                    throw new OwUserOperationException(new OwString1("app.OwObjectListViewRow.onlysingleselectfunction", "Function %1 can only be applied to one object.", plugIn.getDefaultLabel()));
                }
                OwMultipleSelectionCall multiCall = new OwMultipleSelectionCall(plugIn, objects, this.getParentObject(), this.getRefreshContext(), this.m_MainContext);
                multiCall.invokeFunction();
            }
        }
    }

    public void onPluginEvent(HttpServletRequest request_p) throws Exception {
        String strObjectIndex = request_p.getParameter("oi");
        String strPlugIndex = request_p.getParameter("pi");
        if (strObjectIndex != null && strPlugIndex != null) {
            int iPlugIndex = Integer.parseInt(strPlugIndex);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            int iObjectIndex = Integer.parseInt(strObjectIndex);
            OwObject obj = this.getObjectByIndex(iObjectIndex);
            plugIn.onClickEvent(obj, this.getParentObject(), this.getRefreshContext());
        }
    }

    public void onSelect(HttpServletRequest request_p) throws Exception {
        int selected = Integer.parseInt(request_p.getParameter("oi"));
        if (this.getEventListner() != null) {
            OwObject obj = this.getObjectByIndex(selected);
            this.getEventListner().onObjectListViewSelect(obj, this.getParentObject());
        }
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return true;
    }

    public Collection getRetrievalPropertyNames() throws Exception {
        if (null == this.getColumnInfo()) {
            throw new OwInvalidOperationException("OwObjectListViewThumbnails.getRetrievalPropertyNames: Specify setColumnInfo() in OwObjectList.");
        }
        HashSet<String> retList = new HashSet<String>();
        for (OwFieldColumnInfo owFieldColumnInfo : this.getColumnInfo()) {
            retList.add(owFieldColumnInfo.getPropertyName());
        }
        for (OwObjectListView.OwPluginEntry owPluginEntry : this.getPluginEntries()) {
            Collection props = owPluginEntry.m_Plugin.getRetrievalPropertyNames();
            if (null == props) continue;
            retList.addAll(props);
        }
        return retList;
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        throw new OwObjectNotFoundException("OwObjectListViewThumbnails.getField: Not implemented or Not supported.");
    }

    @Override
    public int getFieldProviderType() {
        return 129;
    }

    @Override
    public Object getFieldProviderSource() {
        return this.getDisplayedPage();
    }

    @Override
    public String getFieldProviderName() {
        try {
            return this.getParentObject().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = this.getField(sName_p);
        field.setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        throw new OwInvalidOperationException("OwObjectListViewThumbnails.getFields: Not implemented.");
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("dmsdialogs.views.OwObjectListViewThumbnails.title", "Thumbnail View");
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewThumbnail.png";
    }

    protected static class ThumbnailTypeConfig {
        private String m_displayname = "";
        private String m_url = "";
        private int m_width = 0;
        private int m_height = 0;
        private boolean m_scale;

        public ThumbnailTypeConfig(String displayname_p, int width_p, int height_p, boolean scale_p, String url_p) {
            this.m_displayname = displayname_p;
            this.m_width = width_p;
            this.m_height = height_p;
            this.m_url = url_p;
            this.m_scale = scale_p;
        }

        public String getDisplayname() {
            return this.m_displayname;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public String getUrl() {
            return this.m_url;
        }

        boolean isScale() {
            return this.m_scale;
        }
    }
}

