/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwInsertLabelHelper;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.OwGroupPropertiesConfiguration;
import com.wewebu.ow.server.dmsdialogs.views.OwBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwPasteMetadataHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardPasteMetadataHandler;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInaccessibleException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwViewUpdateException;
import com.wewebu.ow.server.field.OwEnum;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.wd.ui.conf.OwPropertyListConfiguration;
import org.alfresco.wd.ui.conf.OwPropertySubregion;
import org.alfresco.wd.ui.conf.OwSimplePropertySubregion;
import org.alfresco.wd.ui.conf.prop.OwPropertyGroup;
import org.apache.log4j.Logger;

public class OwObjectPropertyView
extends OwLayout
implements OwMultipanel,
OwFieldProvider {
    protected static final String BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME = "OwObjectPropertyViewBatchIndexProperties";
    public static final int ERRORS_REGION = 4;
    private static final String GROUP_HEADER_CLASS_NAME = "groupHeader";
    public static final String GROUP_EXPANDED_CLASS_NAME = "OwGroupBodyExpanded";
    public static final String GROUP_COLLAPSED_CLASS_NAME = "OwGroupBodyCollapsed";
    private static final Logger LOG = OwLogCore.getLogger(OwObjectPropertyView.class);
    public static final int MAIN_REGION = 1;
    public static final int MENU_REGION = 2;
    public static final int MODES_REGION = 3;
    private static final String MODES_SELECT_ID = "owmodes";
    private static final int NO_MODE = -1;
    protected static final String QUERY_KEY_PROPNAME = "prop";
    public static final int VIEW_MASK_DISABLE_INTERNAL_MENU = 2;
    public static final int VIEW_MASK_ENABLE_PASTE_METADATA = 1;
    public static final int VIEW_MASK_READONLY = 8;
    public static final int VIEW_MASK_RENDER_VERTICAL = 4;
    protected Collection m_batchIndexProperties;
    protected OwBatchPropertiesHandler m_batchPropertiesHandler;
    private boolean m_displayNoSaveMsg;
    protected boolean m_enablesaveall;
    protected boolean m_fAllPropertiesReadonly = true;
    protected boolean m_fReadOnly;
    protected boolean m_fSystem;
    private OwGroupPropertiesConfiguration m_groupPropertyConfiguration;
    private OwPropertyListConfiguration propertyListConfiguration;
    protected int m_iAppyBtnIndex;
    private int m_icurrentmode = -1;
    protected int m_iLockIndex;
    protected int m_iNextButtonIndex = -1;
    protected int m_iUnLockIndex;
    protected int m_iViewMask;
    protected OwSubMenuView m_MenuView;
    private int m_modetype = 1;
    protected OwObject m_ObjectRef;
    protected OwPasteMetadataHandler m_pasteMetadataHandler;
    protected OwPropertyCollection m_Properties;
    private Collection<String> m_propertyfilter;
    protected int m_ReadOnlyContext = 0;
    protected Map<String, Boolean> m_readOnlyProperties;
    protected boolean m_saveAllActive;
    protected OwFieldManager m_theFieldManager;
    private boolean m_updateNoChanges = false;
    private boolean m_informUserOnSuccess = true;

    public void setUpdateNoChanges(boolean updateNoChanges) {
        this.m_updateNoChanges = updateNoChanges;
    }

    public void setInformUserOnSuccess(boolean informUserOnSuccess) {
        this.m_informUserOnSuccess = informUserOnSuccess;
    }

    private boolean areAllPropertiesReadOnly() {
        Iterator it = null;
        try {
            it = this.getFilteredClonedProperties().values().iterator();
        }
        catch (Exception e1) {
            throw new OwInaccessibleException(this.getContext().localize("app.OwObjectPropertyView.err.getClonedProperties", "Unable to retrieve properties from reference object."), (Throwable)e1);
        }
        while (it.hasNext()) {
            OwProperty property = (OwProperty)it.next();
            try {
                OwPropertyClass propertyClass = property.getPropertyClass();
                if (this.m_fSystem != propertyClass.isSystemProperty() || this.isPropertyReadonly(property)) continue;
                this.m_fAllPropertiesReadonly = false;
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot read object properties " + e.getMessage()));
            }
        }
        return this.m_fAllPropertiesReadonly;
    }

    public void clearBatchIndex() throws OwInvalidOperationException {
        this.m_batchPropertiesHandler.clearBatchIndex();
    }

    protected OwBatchPropertiesHandler createBatchPropertiesHandler() {
        return new OwStandardBatchPropertiesHandler(this.getDocument());
    }

    protected OwPasteMetadataHandler createPasteMetadataHandler() {
        return new OwStandardPasteMetadataHandler((OwMainAppContext)this.getContext(), this.m_fSystem, this.hasViewMask(1));
    }

    @Override
    public void detach() {
        super.detach();
        this.m_theFieldManager.detach();
    }

    protected OwClipboard getClipboard() {
        return ((OwMainAppContext)this.getContext()).getClipboard();
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception {
        OwProperty prop = (OwProperty)this.getFilteredClonedProperties().get(strFieldClassName_p);
        if (prop == null) {
            throw new OwObjectNotFoundException("OwObjectPropertyView.getField: Property not found, strFieldClassName_p = " + strFieldClassName_p);
        }
        return prop;
    }

    public OwFieldManager getFieldManager() {
        return this.m_theFieldManager;
    }

    @Override
    public String getFieldProviderName() {
        return this.getObjectRef().getName();
    }

    @Override
    public Object getFieldProviderSource() {
        return this.getObjectRef();
    }

    @Override
    public int getFieldProviderType() {
        switch (this.getReadOnlyContext()) {
            case 1: {
                return 17;
            }
            case 2: {
                return 33;
            }
        }
        return 1;
    }

    @Override
    public Collection getFields() throws Exception {
        return this.getFilteredClonedProperties().values();
    }

    protected OwPropertyCollection getFilteredClonedProperties() throws Exception {
        if (this.getObjectRef() != null && this.m_Properties == null) {
            OwStandardPropertyCollection retFiltered;
            if (this.getPropertyListConfiguration() != null) {
                this.m_propertyfilter = new LinkedList<String>();
                this.m_readOnlyProperties = new HashMap<String, Boolean>();
                for (OwPropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> subregion : this.getPropertyListConfiguration().getSubregions()) {
                    for (org.alfresco.wd.ui.conf.prop.OwPropertyInfo pi : subregion.getPropertyInfos()) {
                        try {
                            this.getObjectRef().getObjectClass().getPropertyClass(pi.getPropertyName());
                            this.m_propertyfilter.add(pi.getPropertyName());
                            if (!pi.isReadOnly()) continue;
                            this.m_readOnlyProperties.put(pi.getPropertyName(), Boolean.TRUE);
                        }
                        catch (OwObjectNotFoundException onfEx) {}
                    }
                }
            }
            OwPropertyCollection ret = this.getObjectRef().getClonedProperties(this.m_propertyfilter);
            if (null != this.m_propertyfilter) {
                retFiltered = new OwStandardPropertyCollection();
                for (String sPropName : this.m_propertyfilter) {
                    OwProperty prop = (OwProperty)ret.get(sPropName);
                    if (prop == null || prop.isHidden(this.getReadOnlyContext())) continue;
                    retFiltered.put(sPropName, prop);
                }
                this.m_Properties = retFiltered;
            } else {
                retFiltered = new OwStandardPropertyCollection();
                for (OwProperty prop : ret.values()) {
                    if (prop == null || prop.isHidden(this.getReadOnlyContext())) continue;
                    retFiltered.put(prop.getPropertyClass().getClassName(), prop);
                }
                this.m_Properties = retFiltered;
            }
        }
        return this.m_Properties == null ? new OwStandardPropertyCollection() : this.m_Properties;
    }

    public OwMenuView getMenu() {
        return this.m_MenuView;
    }

    public OwObject getObjectRef() {
        return this.m_ObjectRef;
    }

    protected String getRowClassName(int iIndex_p, OwProperty prop_p) {
        return iIndex_p % 2 != 0 ? "OwObjectPropertyView_OddRow" : "OwObjectPropertyView_EvenRow";
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = (OwField)this.getFilteredClonedProperties().get(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    public int getSaveBtnIndex() {
        return this.m_iAppyBtnIndex;
    }

    public boolean getUpdateStatus() {
        return this.m_theFieldManager.getUpdateStatus();
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (this.m_iViewMask & iViewMask_p) > 0;
    }

    protected void informUserOnSuccess() {
        if (this.m_informUserOnSuccess) {
            ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("app.OwObjectPropertyView.saved", "Changes have been saved."));
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_theFieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        if (!this.hasViewMask(2)) {
            this.m_MenuView = new OwSubMenuView();
            this.addView(this.m_MenuView, 2, null);
        }
        if (this.getMenu() != null) {
            this.m_iAppyBtnIndex = this.getMenu().addFormMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.save", "Save"), "Apply", null);
            this.getMenu().setDefaultMenuItem(this.m_iAppyBtnIndex);
            this.getMenu().enable(this.m_iAppyBtnIndex, false);
        }
        this.m_batchPropertiesHandler = this.createBatchPropertiesHandler();
        this.m_pasteMetadataHandler = this.createPasteMetadataHandler();
        this.setDisplayNoSaveMsg(false);
    }

    protected boolean isGroupWithErrors(OwPropertyGroup<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> theGroup_p) throws Exception {
        List<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> props = theGroup_p.getProperties();
        boolean result = false;
        for (org.alfresco.wd.ui.conf.prop.OwPropertyInfo prop : props) {
            String errorString;
            OwField field = (OwField)this.getFilteredClonedProperties().get(prop.getPropertyName());
            if (field == null || (errorString = this.m_theFieldManager.getSafeFieldError(field)) == null || errorString.length() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isPropertyReadonly(OwProperty property_p) throws Exception {
        if (property_p.isReadOnly(this.getReadOnlyContext())) {
            return true;
        }
        return null != this.m_readOnlyProperties && this.m_readOnlyProperties.containsKey(property_p.getFieldDefinition().getClassName());
    }

    public boolean isReadOnly() {
        if (this.areAllPropertiesReadOnly()) {
            this.m_fReadOnly = true;
        }
        return this.m_fReadOnly;
    }

    @Override
    public boolean isRegion(int region_p) {
        switch (region_p) {
            case 4: {
                return true;
            }
            case 3: {
                try {
                    if (this.m_modetype == 0) {
                        return false;
                    }
                    return null != this.getObjectRef().getObjectClass().getModes(this.m_modetype);
                }
                catch (Exception e) {
                    return false;
                }
            }
            case 1: {
                return true;
            }
        }
        return super.isRegion(region_p);
    }

    protected boolean isSupportLock() {
        return true;
    }

    public boolean isSystemPropertyView() {
        return this.m_fSystem;
    }

    @Override
    public boolean isValidated() throws Exception {
        OwPropertyCollection props = this.getFilteredClonedProperties();
        if (null == props) {
            return false;
        }
        for (OwProperty prop : props.values()) {
            OwPropertyClass propClass = prop.getPropertyClass();
            if (propClass.isSystemProperty() || !propClass.isRequired() || prop.getValue() != null && prop.getValue().toString().length() != 0) continue;
            return false;
        }
        return true;
    }

    public Boolean mapProperties(Map map_p, String name_p) {
        if (map_p.get(name_p) == null) {
            return null;
        }
        if (map_p.get(name_p).toString().equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void onAjaxPropertyGroupCollapse(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        OwPropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> subRegion;
        String groupId = request_p.getParameter("owGroupId");
        String isGroupCollapsed = request_p.getParameter("isGroupCollapsed");
        if (groupId != null && isGroupCollapsed != null && this.getPropertyListConfiguration() != null && (subRegion = this.getPropertyListConfiguration().getGroupRegion(groupId)) != null) {
            subRegion.getPropertyGroup().setCollapsed(Boolean.parseBoolean(isGroupCollapsed));
        }
    }

    public boolean onApply(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.onApplyInternal(request_p, oReason_p)) {
            this.safeUpdate(this, 2);
            this.safeUpdate(this, 15);
            this.informUserOnSuccess();
            return true;
        }
        if (this.m_displayNoSaveMsg) {
            String message = this.getContext().localize("owdocprops.OwEditPropertiesDialog.NotSaved", "Nothing was changed therefore the document was not saved.");
            ((OwMainAppContext)this.getContext()).postMessage(message);
            this.safeUpdate(this, 18);
        }
        return false;
    }

    protected boolean onApplyInternal(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwPropertyCollection changedProperties = this.update(request_p);
        if (null == changedProperties) {
            return this.m_updateNoChanges;
        }
        return this.save(changedProperties);
    }

    public void onBatchIndex() throws Exception {
        this.m_batchPropertiesHandler.onBatchIndex();
    }

    public void onLock(HttpServletRequest request_p, Object oReason_p) throws Exception {
        this.getObjectRef().setLock(true);
        this.safeUpdate(this, 2);
    }

    public void onNext(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.onApplyInternal(request_p, null)) {
            ((OwView)oReason_p).activate();
        }
    }

    public void onPasteAllMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteAllMetaData(request_p);
    }

    public void onPasteThisMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteThisMetaData(request_p);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectPropertyView.jsp", w_p);
        ((OwMainAppContext)this.getContext()).setFocusControlID(this.m_theFieldManager.getFocusControlID());
    }

    public void onUnLock(HttpServletRequest request_p, Object oReason_p) throws Exception {
        this.getObjectRef().setLock(false);
        this.safeUpdate(this, 2);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 2: {
                if (this.m_fSystem || this.hasViewMask(8)) {
                    this.m_fReadOnly = true;
                } else {
                    boolean bl = this.m_fReadOnly = this.getObjectRef().canLock() && !this.getObjectRef().getLock(2) || !this.getObjectRef().canSetProperties(2);
                }
                if (this.getMenu() != null && this.isSupportLock() && this.getObjectRef().canLock()) {
                    if (this.getObjectRef().getLock(2)) {
                        this.getMenu().enable(this.m_iLockIndex, false);
                        this.getMenu().enable(this.m_iUnLockIndex, true);
                        this.getMenu().setDefaultMenuItem(this.m_iAppyBtnIndex);
                    } else {
                        this.getMenu().enable(this.m_iLockIndex, true);
                        this.getMenu().enable(this.m_iUnLockIndex, false);
                        this.getMenu().setDefaultMenuItem(this.m_iLockIndex);
                    }
                }
                this.m_batchPropertiesHandler.setProperties(this.getFilteredClonedProperties());
                this.m_pasteMetadataHandler.setProperties(this.getFilteredClonedProperties());
                break;
            }
            case 1: 
            case 19: {
                this.m_Properties = null;
                if (this.m_batchPropertiesHandler != null) {
                    this.m_batchPropertiesHandler.setProperties(this.getFilteredClonedProperties());
                }
                if (this.m_pasteMetadataHandler == null) break;
                this.m_pasteMetadataHandler.setProperties(this.getFilteredClonedProperties());
                break;
            }
        }
    }

    protected void renderErrorsRegion(Writer w_p) throws Exception {
        w_p.write(this.m_theFieldManager.renderErrors());
    }

    protected void renderExtraColumnHeader(Writer w_p) throws Exception {
        if (this.m_pasteMetadataHandler.isPasteMetadataActivated()) {
            w_p.write("<th class=\"OwPasteMetadata\">");
            this.m_pasteMetadataHandler.renderPasteAllMetadata(w_p, this);
            w_p.write("</th>");
        }
    }

    protected void renderExtraColumnRows(Writer w_p, OwProperty prop_p) throws Exception {
        if (this.m_pasteMetadataHandler.isPasteMetadataActivated()) {
            w_p.write("\n<td class=\"OwPasteMetadata\">");
            this.m_pasteMetadataHandler.renderPasteMetadata(w_p, prop_p, this);
            w_p.write("</td>");
        }
    }

    protected void renderGroupHeader(OwPropertyGroup theGroup_p, Writer w_p, String strRowClassName_p) throws Exception {
        if (this.isGroupWithErrors(theGroup_p)) {
            theGroup_p.setCollapsed(false);
        }
        w_p.write("<tr class=\"" + strRowClassName_p + "\" ");
        w_p.write("onClick=\"");
        w_p.write("OwPropGroup.toggleGroup('" + theGroup_p.getGroupId() + "','" + this.getAjaxEventURL("PropertyGroupCollapse", null) + "');");
        w_p.write("\">\n");
        w_p.write("<td id=\"td_" + OwHTMLHelper.encodeJavascriptVariableName(theGroup_p.getGroupId()) + "\" class=\"");
        if (!theGroup_p.isCollapsed()) {
            w_p.write("OwGroupExpanded");
        } else {
            w_p.write("OwGroupCollapsed");
        }
        w_p.write("\">&nbsp;</td>");
        int numberOfColumns = this.m_pasteMetadataHandler.isPasteMetadataActivated() ? 3 : 2;
        w_p.write("<td colspan=\"" + numberOfColumns + "\" class=\"OwGroupName\">");
        w_p.write(OwHTMLHelper.encodeToSecureHTML(theGroup_p.getDisplayName(this.getContext())));
        w_p.write("<input type=\"hidden\" value =\"" + theGroup_p.isCollapsed() + "\" id=\"isCollapsed_" + theGroup_p.getGroupId() + "\"/>");
        w_p.write("</td>");
        w_p.write("</tr>\n");
    }

    protected void renderHorizontalProperties(Writer w_p) throws Exception {
        Iterator it = this.getFilteredClonedProperties().values().iterator();
        String strRowClassName = null;
        int iIndex = 0;
        while (it.hasNext()) {
            OwProperty property = (OwProperty)it.next();
            OwPropertyClass propertyClass = property.getPropertyClass();
            if (this.m_fSystem != propertyClass.isSystemProperty()) continue;
            strRowClassName = this.getRowClassName(iIndex, property);
            this.renderHorizontalProperty(w_p, strRowClassName, property, propertyClass);
            ++iIndex;
        }
    }

    protected void renderHorizontalProperty(Writer w_p, String strRowClassName_p, OwProperty property_p, OwPropertyClass propertyClass_p) throws Exception {
        w_p.write("<tr class=\"" + strRowClassName_p + "\">\n");
        this.renderExtraColumnRows(w_p, property_p);
        w_p.write("<td class=\"OwRequired\">");
        if (propertyClass_p.isRequired()) {
            String requiredTooltip = this.getContext().localize("app.OwObjectPropertyView.required", "Required");
            w_p.write("<img src=\"" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/required.png\" alt=\"" + requiredTooltip + "\" title=\"" + requiredTooltip + "\"/>");
        } else {
            w_p.write("<img src=\"" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif\" alt=\"\">");
        }
        w_p.write("</td>\n");
        w_p.write("<td class=\"OwPropertyName\" title=\"" + propertyClass_p.getClassName() + "\">");
        boolean propReadOnly = this.isPropertyReadonly(property_p);
        this.m_theFieldManager.insertLabel(w_p, this.m_fReadOnly, propReadOnly, property_p, ":&nbsp;&nbsp;", true);
        w_p.write("</td>\n<td class=\"DefaultInput\">\n");
        w_p.write("<div class=\"OwPropertyControl\">");
        if (this.m_fReadOnly || propReadOnly) {
            this.m_theFieldManager.insertReadOnlyField(w_p, property_p);
        } else {
            w_p.write("\n");
            this.m_theFieldManager.insertEditField(w_p, property_p);
            this.m_fAllPropertiesReadonly = false;
        }
        w_p.write("</div>\n");
        w_p.write("<div class=\"OwPropertyError\">");
        w_p.write(this.m_theFieldManager.getSafeFieldError(property_p));
        w_p.write("</div>\n");
        w_p.write("<div class=\"OwPropertyError\" id=\"HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(property_p) + "\"></div>\n");
        w_p.write("</td>\n");
        w_p.write("</tr>\n");
    }

    protected void renderHorizontalPropertyGroups(Writer w_p) throws Exception {
        int index = 0;
        for (OwPropertyGroup owPropertyGroup : this.m_groupPropertyConfiguration.getGroups()) {
            List groupProperties = owPropertyGroup.getProperties();
            ArrayList<OwProperty> properties = new ArrayList<OwProperty>(groupProperties.size());
            for (org.alfresco.wd.ui.conf.prop.OwPropertyInfo owPropertyInfo : groupProperties) {
                String propertyName = owPropertyInfo.getPropertyName();
                OwProperty prop = (OwProperty)this.getFilteredClonedProperties().get(propertyName);
                if (prop != null) {
                    properties.add(prop);
                    continue;
                }
                String msg = String.format("Property %s, specified in group %s was not found in the current object!", propertyName, owPropertyGroup.getGroupId());
                LOG.debug((Object)msg);
            }
            if (properties.isEmpty()) continue;
            this.renderPropertyGroup(w_p, owPropertyGroup, index, properties);
            index += properties.size();
        }
    }

    protected void renderPropertyGroup(Writer w_p, OwPropertyGroup<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> group, int propertyIndex, List<OwProperty> properties) throws Exception {
        String encodedGroupId = OwHTMLHelper.encodeJavascriptVariableName(group.getGroupId());
        w_p.write("<tbody id=\"groupHeader");
        w_p.write(encodedGroupId);
        w_p.write("\">");
        this.renderGroupHeader(group, w_p, GROUP_HEADER_CLASS_NAME);
        w_p.write("</tbody>");
        w_p.write("<tbody id=\"");
        w_p.write(encodedGroupId);
        w_p.write("\" class=\"");
        if (group.isCollapsed()) {
            w_p.write(GROUP_COLLAPSED_CLASS_NAME);
        } else {
            w_p.write(GROUP_EXPANDED_CLASS_NAME);
        }
        w_p.write("\">");
        for (OwProperty prop : properties) {
            OwPropertyClass propertyClass = prop.getPropertyClass();
            String strRowClassName = this.getRowClassName(propertyIndex, prop);
            this.renderHorizontalProperty(w_p, strRowClassName, prop, propertyClass);
            ++propertyIndex;
        }
        w_p.write("</tbody>");
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.m_theFieldManager.reset();
        OwPropertyCollection props = this.getFilteredClonedProperties();
        if (props == null || props.size() == 0) {
            return;
        }
        if (this.hasViewMask(4)) {
            this.renderVertically(w_p);
        } else {
            w_p.write("<table class=\"OwObjectPropertyView_PropList\">\n");
            w_p.write("<thead>\n");
            w_p.write("<tr class=\"OwObjectPropertyView_Header\">\n");
            this.renderExtraColumnHeader(w_p);
            w_p.write("<th class=\"OwRequired\"><img  alt=\"\" src=\"");
            w_p.write(this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif\"></th>");
            w_p.write("<th class=\"OwPropertyName\">");
            w_p.write(this.getContext().localize("app.OwObjectPropertyView.propertycolumn", "Property"));
            w_p.write("&nbsp;&nbsp;</th><th>");
            w_p.write(this.getContext().localize("app.OwObjectPropertyView.valuecolumn", "Value"));
            w_p.write("&nbsp;&nbsp;</th>\n");
            w_p.write("</tr>\n");
            w_p.write("</thead>\n");
            if (this.getPropertyListConfiguration() != null) {
                this.getContext().renderJSInclude("/js/oweditproperties.js", w_p);
                this.renderPropertyListConfiguration(w_p);
            } else {
                w_p.write("<tbody>\n");
                this.renderHorizontalProperties(w_p);
                w_p.write("</tbody>\n");
            }
            w_p.write("</table>\n");
        }
        if (this.m_fSystem || this.hasViewMask(8) || this.m_fAllPropertiesReadonly) {
            this.m_fReadOnly = true;
        } else {
            boolean bl = this.m_fReadOnly = this.getObjectRef().canLock() && !this.getObjectRef().getLock(2) || !this.getObjectRef().canSetProperties(2);
        }
        if (this.getMenu() != null) {
            this.getMenu().enable(this.m_iAppyBtnIndex, !this.m_fReadOnly);
        }
    }

    protected void renderModesRegion(Writer w_p) throws Exception {
        if (this.m_modetype == 0 || this.m_fReadOnly) {
            return;
        }
        List propmodes = this.getObjectRef().getObjectClass().getModes(this.m_modetype);
        if (null != propmodes) {
            LinkedList<OwDefaultComboItem> items = new LinkedList<OwDefaultComboItem>();
            for (int i = 0; i < propmodes.size(); ++i) {
                OwEnum mode = (OwEnum)propmodes.get(i);
                OwDefaultComboItem item = new OwDefaultComboItem(String.valueOf(i), mode.getDisplayName(this.getContext().getLocale()));
                items.add(item);
            }
            OwDefaultComboModel model = new OwDefaultComboModel(false, false, "" + this.m_icurrentmode, items);
            OwString description = new OwString("app.OwObjectPropertyView.modes.title", "Modes");
            OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(model, MODES_SELECT_ID, null, null, description);
            String modesDisplayName = description.getString(this.getContext().getLocale());
            OwInsertLabelHelper.insertLabelValue(w_p, modesDisplayName, MODES_SELECT_ID);
            renderer.renderCombo(w_p);
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 4: {
                this.renderErrorsRegion(w_p);
                break;
            }
            case 3: {
                this.renderModesRegion(w_p);
                break;
            }
            case 1: {
                this.renderMainRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private void safeBatchIndexProperties() throws Exception {
        this.m_batchPropertiesHandler.saveBatchIndexProperties();
    }

    private void safeUpdate(OwEventTarget target_p, int iCode_p) throws Exception {
        OwDocument doc = this.getDocument();
        if (null != doc) {
            doc.update(target_p, iCode_p, null);
        }
    }

    protected boolean save(OwPropertyCollection changedProperties_p) throws Exception {
        if (changedProperties_p == null || changedProperties_p.size() == 0) {
            return this.m_updateNoChanges;
        }
        Object mode = null;
        if (-1 != this.m_icurrentmode) {
            List propmodes = this.getObjectRef().getObjectClass().getModes(this.m_modetype);
            OwEnum modeenum = (OwEnum)propmodes.get(this.m_icurrentmode);
            mode = modeenum.getValue();
        }
        try {
            this.getObjectRef().setProperties(changedProperties_p, mode);
        }
        catch (Exception e) {
            String msg = "Error saving the properties to the object.";
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            this.m_Properties = null;
        }
        return true;
    }

    public void setBatchProperties(Collection set_p) {
        this.m_batchIndexProperties = set_p;
        this.m_batchPropertiesHandler.setBatchIndexProperties(set_p);
    }

    protected void setDisplayNoSaveMsg(boolean display_p) {
        this.m_displayNoSaveMsg = display_p;
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = (OwField)this.getFilteredClonedProperties().get(sName_p);
        if (null == field) {
            String msg = "OwObjectPropertyView.setField: Field not found, name = " + sName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        field.setValue(value_p);
    }

    @Deprecated
    public void setGroupPropertiesConfiguration(OwGroupPropertiesConfiguration groupPropertyConfiguration_p) {
        LOG.warn((Object)"OwGroupPropertiesConfiguration is deprected and should not be used, use EditPropertyList instead");
        OwPropertyListConfiguration propLstConf = null;
        if (groupPropertyConfiguration_p != null) {
            propLstConf = new OwPropertyListConfiguration();
            for (OwPropertyGroup owPropertyGroup : groupPropertyConfiguration_p.getGroups()) {
                OwSimplePropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> region = new OwSimplePropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo>(owPropertyGroup);
                propLstConf.addRegion(region);
            }
        }
        this.setPropertyListConfiguration(propLstConf);
    }

    public void setModeType(int modetype_p) {
        this.m_modetype = modetype_p;
    }

    @Override
    public void setNextActivateView(OwView nextView_p) throws Exception {
        if (this.getMenu() != null) {
            this.m_iNextButtonIndex = this.getMenu().addFormMenuItem((OwEventTarget)this, this.getContext().localize("app.OwObjectPropertyView.next", "Next"), null, "Next", nextView_p, null);
            this.getMenu().enable(this.m_iNextButtonIndex, true);
        }
    }

    public void setObjectRef(OwObject objectRef_p, boolean showSystemProperties_p) throws Exception {
        this.m_theFieldManager.reset();
        this.m_ObjectRef = objectRef_p;
        this.m_theFieldManager.setFieldProvider(this);
        this.m_fSystem = showSystemProperties_p;
        if (this.getMenu() != null && this.isSupportLock() && this.m_ObjectRef.canLock()) {
            this.m_iLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.lock", "Lock document"), "Lock", null);
            this.m_iUnLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.unlcok", "Unlock document"), "UnLock", null);
        }
        this.m_Properties = null;
        this.onUpdate(this, 2, null);
    }

    @Deprecated
    public void setObjectRefEx(OwObject objectRef_p, boolean showSystemProperties_p, Collection propertyInfos_p) throws Exception {
        OwPropertyListConfiguration propLstConf = null;
        if (null != propertyInfos_p) {
            propLstConf = new OwPropertyListConfiguration();
            Iterator it = propertyInfos_p.iterator();
            LinkedList<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> propInfoLst = new LinkedList<org.alfresco.wd.ui.conf.prop.OwPropertyInfo>();
            while (it.hasNext()) {
                org.alfresco.wd.ui.conf.prop.OwPropertyInfo pi = (org.alfresco.wd.ui.conf.prop.OwPropertyInfo)it.next();
                propInfoLst.add(pi);
            }
            propLstConf.addRegion(new OwSimplePropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo>(propInfoLst));
        }
        this.setPropertyListConfiguration(propLstConf);
        this.m_theFieldManager.reset();
        this.m_ObjectRef = objectRef_p;
        this.m_theFieldManager.setFieldProvider(this);
        this.m_fSystem = showSystemProperties_p;
        if (this.getMenu() != null && this.isSupportLock() && this.m_ObjectRef.canLock()) {
            this.m_iLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.lock", "Lock document"), "Lock", null);
            this.m_iUnLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.unlcok", "Unlock document"), "UnLock", null);
        }
        this.onUpdate(this, 2, null);
    }

    @Override
    public void setPrevActivateView(OwView prevView_p) throws Exception {
    }

    public void setReadOnlyContext(int context_p) {
        this.m_ReadOnlyContext = context_p;
    }

    public int getReadOnlyContext() {
        return this.m_ReadOnlyContext;
    }

    public void setSaveAllActive(boolean active_p) {
        this.m_saveAllActive = active_p;
    }

    public void setSaveBtnIndex(int mIAppyBtnIndex_p) {
        this.m_iAppyBtnIndex = mIAppyBtnIndex_p;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected OwPropertyCollection update(HttpServletRequest request_p) throws Exception {
        OwStandardPropertyCollection changedProperties;
        List propmodes;
        if (this.m_modetype != 0 && null != (propmodes = this.getObjectRef().getObjectClass().getModes(this.m_modetype))) {
            this.m_icurrentmode = Integer.parseInt(request_p.getParameter(MODES_SELECT_ID));
        }
        if (this.m_theFieldManager.update(request_p, changedProperties = new OwStandardPropertyCollection(), this.getObjectRef().getProperties(null))) {
            this.safeBatchIndexProperties();
            return changedProperties;
        }
        return null;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
        if (this.getObjectRef() == null) {
            LOG.debug((Object)"OwObjectPropertyView.updateExternalFormTarget: The refer object (property, objectclass...) is missing. Please select one.");
            throw new OwInvalidOperationException(this.getContext().localize("app.OwObjectPropertyView.invalid.objectreferer", "The refer object (property, objectclass...) is missing. Please select one."));
        }
        OwPropertyCollection properties = this.getObjectRef().getProperties(null);
        return this.m_theFieldManager.update(request_p, changedProperties, properties);
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public void setPropertyListConfiguration(OwPropertyListConfiguration propListConfiguration) {
        this.propertyListConfiguration = propListConfiguration;
        if (this.m_propertyfilter != null) {
            this.m_propertyfilter.clear();
            this.m_propertyfilter = null;
        }
        if (this.m_readOnlyProperties != null) {
            this.m_readOnlyProperties.clear();
            this.m_readOnlyProperties = null;
        }
        if (this.getContext() != null) {
            try {
                this.onUpdate(this, 19, null);
            }
            catch (Exception e) {
                throw new OwViewUpdateException(this.getContext().localize("app.OwObjectPropertyView.err.setPropertyListConfiguration", "Failed to update view after Filter/Grouping definition."), (Throwable)e);
            }
        }
    }

    public OwPropertyListConfiguration getPropertyListConfiguration() {
        return this.propertyListConfiguration;
    }

    protected void renderVertically(Writer w_p) throws Exception {
        for (OwProperty property : this.getFilteredClonedProperties().values()) {
            OwPropertyClass propertyClass = property.getPropertyClass();
            if (this.m_fSystem != propertyClass.isSystemProperty()) continue;
            w_p.write("<div class=\"OwPropertyName\" style=\"clear: both;\">");
            this.m_theFieldManager.insertLabel(w_p, this.m_fReadOnly, this.isPropertyReadonly(property), property, ":&nbsp;&nbsp;", true);
            w_p.write("</div>\n");
            w_p.write("<div>\n");
            w_p.write("<div class=\"OwPropertyControl\">");
            if (this.m_fReadOnly || this.isPropertyReadonly(property)) {
                this.m_theFieldManager.insertReadOnlyField(w_p, property);
            } else {
                this.m_theFieldManager.insertEditField(w_p, property);
                this.m_fAllPropertiesReadonly = false;
            }
            w_p.write("</div>\n");
            w_p.write("<div class=\"OwPropertyError\">");
            w_p.write(this.m_theFieldManager.getSafeFieldError(property));
            w_p.write("</div>\n");
            w_p.write("<div class=\"OwPropertyError\" id=\"HotInfo" + this.m_theFieldManager.getFieldJSErrorCtrlID(property) + "\"></div>\n");
            w_p.write("<br><br>\n");
            w_p.write("</div>\n");
        }
    }

    protected void renderPropertyListConfiguration(Writer writer) throws Exception {
        int idx = 0;
        for (OwPropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> subregion : this.getPropertyListConfiguration().getSubregions()) {
            List<OwProperty> availableProperties = this.getSubregionAvailable(subregion);
            if (availableProperties.isEmpty()) continue;
            if (subregion.isGroup()) {
                this.renderPropertyGroup(writer, subregion.getPropertyGroup(), idx, availableProperties);
            } else {
                writer.write("<tbody>\n");
                for (OwProperty prop : availableProperties) {
                    String rowClass = this.getRowClassName(idx++, prop);
                    this.renderHorizontalProperty(writer, rowClass, prop, prop.getPropertyClass());
                }
                writer.write("</tbody>\n");
            }
            idx += availableProperties.size();
        }
    }

    protected List<OwProperty> getSubregionAvailable(OwPropertySubregion<org.alfresco.wd.ui.conf.prop.OwPropertyInfo> subregion) throws Exception {
        LinkedList<OwProperty> lst = new LinkedList<OwProperty>();
        OwPropertyCollection col = this.getFilteredClonedProperties();
        for (org.alfresco.wd.ui.conf.prop.OwPropertyInfo propInfo : subregion.getPropertyInfos()) {
            OwProperty prop = (OwProperty)col.get(propInfo.getPropertyName());
            if (prop == null) continue;
            lst.add(prop);
        }
        return lst;
    }

    @Deprecated
    public static class OwPropertyInfo
    extends org.alfresco.wd.ui.conf.prop.OwPropertyInfo {
        public OwPropertyInfo(String propertyName_p, boolean readOnly_p) {
            super(propertyName_p, readOnly_p);
        }
    }
}

