/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.List;

public class OwObjectTreeView
extends OwTreeView {
    protected OwConfiguration m_Configuration;
    protected int m_iMaxChildSize = 50;
    private boolean m_isDynamicSplitUsed = false;

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_Configuration = ((OwMainAppContext)this.getContext()).getConfiguration();
    }

    public void setMaxChildSize(int iMaxChildSize_p) {
        this.m_iMaxChildSize = iMaxChildSize_p;
    }

    public void navigateChildObject(OwObject obj_p) throws Exception {
        this.navigate(this.m_strPath + obj_p.getID() + "/");
    }

    @Override
    protected List createChildObjects(Object obj_p) throws Exception {
        return ((OwObject)obj_p).getChilds(new int[]{8192}, null, this.childrenSort, this.m_iMaxChildSize, 0, null);
    }

    @Override
    protected String getCloseIconURL(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(this.m_Configuration, (OwObject)obj_p);
        return ((OwMainAppContext)this.getContext()).getDesignURL() + "/micon/" + mimeNode.getSafeTextValue("icon", "unknown.png");
    }

    @Override
    protected String getOpenIconURL(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        OwXMLUtil mimeNode = OwMimeManager.getMimeNode(this.m_Configuration, (OwObject)obj_p);
        return ((OwMainAppContext)this.getContext()).getDesignURL() + "/micon/" + mimeNode.getSafeTextValue("openicon", "unknown.png");
    }

    @Override
    protected String getName(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        return ((OwObject)obj_p).getID();
    }

    @Override
    protected String getDisplayName(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        return ((OwObject)obj_p).getName();
    }

    @Override
    protected String getDisplayHTML(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        try {
            int iChildCount = ((OwObject)obj_p).getChildCount(new int[]{4096}, 1);
            StringBuffer ret = new StringBuffer();
            ret.append(OwHTMLHelper.encodeToSecureHTML(this.getDisplayName(obj_p, node_p)));
            ret.append("<span class='OwObjectTreeViewChildCount'> (");
            ret.append(String.valueOf(iChildCount));
            ret.append(")</span>");
            return ret.toString();
        }
        catch (OwStatusContextException e) {
            return OwHTMLHelper.encodeToSecureHTML(this.getDisplayName(obj_p, node_p));
        }
    }

    @Override
    protected boolean hasPlusMinusIcon(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        try {
            return ((OwObject)obj_p).hasChilds(new int[]{8192}, 1);
        }
        catch (OwStatusContextException e) {
            return super.hasPlusMinusIcon(obj_p, node_p);
        }
    }

    public void setIsDynamicSplitUsed(boolean isynamicSplitUsed_p) {
        this.m_isDynamicSplitUsed = isynamicSplitUsed_p;
    }

    public boolean isDynamicSplitUsed() {
        return this.m_isDynamicSplitUsed;
    }

    @Override
    protected void expandParents(Object theObject_p) throws Exception {
        OwObject theObject = (OwObject)theObject_p;
        OwObjectCollection parents = theObject.getParents();
        if (parents != null && parents.size() > 0) {
            for (int i = parents.size() - 1; i >= 0; --i) {
                OwTreeView.OwTreeViewNode node = this.getNodeForObject(parents.get(i));
                if (node == null) continue;
                node.expand();
            }
        }
    }
}

