/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public abstract class OwPageSelectorComponent {
    protected static final Logger LOG = OwLogCore.getLogger(OwPageSelectorComponent.class);
    protected OwPageableView m_view;
    protected Node m_configNode;
    @Deprecated
    protected boolean isStickyFooterInUse;

    public OwPageSelectorComponent(OwPageableView view_p) {
        this.m_view = view_p;
        this.isStickyFooterInUse = true;
    }

    public abstract void render(Writer var1) throws Exception;

    public String getPageAbsolutURL(int iPage_p) {
        return this.m_view.getPageAbsolutEventURL("page=" + String.valueOf(iPage_p));
    }

    public boolean hasPaging() {
        return this.m_view.hasPaging();
    }

    public String getPagePrevURL() {
        return this.m_view.getPagePrevEventURL();
    }

    public String getPageNextURL() {
        return this.m_view.getPageNextEventURL();
    }

    protected int getDisplayCurrentPageNumber() throws Exception {
        return this.getHumanReadablePageNumber(this.m_view.getCurrentPage());
    }

    protected int getHumanReadablePageNumber(int pageNumber_p) {
        return pageNumber_p + 1;
    }

    protected int getLastPage() throws Exception {
        int lastPage = this.m_view.getPageCount() - 1;
        return lastPage;
    }

    protected boolean shouldRenderComponent() throws Exception {
        int pageCount = this.m_view.getPageCount();
        return pageCount > 1 || pageCount == -1;
    }

    public void setConfigNode(Node configNode_p) {
        this.m_configNode = configNode_p;
    }

    public void init() throws Exception {
    }

    protected void renderAccessibilityMark(Writer w_p) throws Exception {
        w_p.write("<h3 id=\"owpaging\" class=\"accessibility\">" + this.m_view.getContext().localize("dmsdialogs.views.OwPageSelectorComponent.accessibility", "Page selector component") + "</h3>");
    }
}

