/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwPermissionsDocument;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OwPrivilegesDocument
extends OwDocument {
    private static final Map<String, String> privilegeGUIDMap = new HashMap<String, String>();
    private static final Map<String, String> guidPrivilegeMap = new HashMap<String, String>();
    private static long lastGUID = 0L;
    private OwPermissionsDocument permissionsDocument;
    private Map<String, String> privilegeDisplayNames;

    public static final synchronized String guidToPrivilege(String guid_p) throws OwInvalidOperationException {
        String privilege = guidPrivilegeMap.get(guid_p);
        if (privilege == null) {
            throw new OwInvalidOperationException("Invalid privilege GUID : " + guid_p);
        }
        return privilege;
    }

    public static final synchronized String privilegeToGuid(OwPrivilege privilege_p) {
        return OwPrivilegesDocument.privilegeToGuid(privilege_p.getName());
    }

    public static final synchronized String privilegeToGuid(String privilegeName_p) {
        String guid = privilegeGUIDMap.get(privilegeName_p);
        if (guid == null) {
            guid = "" + ++lastGUID;
            privilegeGUIDMap.put(privilegeName_p, guid);
            guidPrivilegeMap.put(guid, privilegeName_p);
        }
        return guid;
    }

    public OwPrivilegesDocument(OwPermissionsDocument permissionsDocument_p, Map<String, String> privilegeDisplayNames_p) {
        this.permissionsDocument = permissionsDocument_p;
        this.privilegeDisplayNames = privilegeDisplayNames_p;
    }

    protected OwPermissionCollection getPermissions() {
        return this.permissionsDocument.getPermissions();
    }

    protected OwPermissionsDocument getPermissionsDocument() {
        return this.permissionsDocument;
    }

    public OwObject getObject() {
        return this.permissionsDocument.getObject();
    }

    public Collection<OwPrivilegeSet> getAppliedPrivilegeSets() {
        OwPermissionCollection permissions = this.getPermissions();
        return permissions.getAppliedPrivilegeSets();
    }

    public void removePrivilegeSet(OwPrivilegeSet privilegeSet_p) throws OwException {
        OwPermissionCollection permissions = this.getPermissions();
        permissions.removePrivilegeSet(privilegeSet_p);
    }

    public String displayNameOf(OwPrivilege privilege_p) {
        String name = privilege_p.getName();
        String displayName = this.privilegeDisplayNames.get(name.trim());
        if (displayName != null) {
            return displayName;
        }
        return this.getContext().localize("owlabel." + name, name);
    }

    public Collection<OwPrivilege> getAvailablePrivileges(OwUserInfo principal_p) {
        OwPermissionCollection permissions = this.getPermissions();
        return permissions.getAvailablePrivileges(principal_p);
    }

    public OwPrivilegeSet addPrivilegeSet(OwUserInfo principal_p, Collection privileges_p, boolean deny_p, int inheritancedepth_p) throws OwException {
        OwPermissionCollection permissions = this.getPermissions();
        return permissions.addPrivilegeSet(principal_p, privileges_p, deny_p, inheritancedepth_p);
    }
}

