/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import java.io.Writer;

public abstract class OwSimplePageSelectorComponent
extends OwPageSelectorComponent {
    public OwSimplePageSelectorComponent(OwPageableView view_p) {
        super(view_p);
    }

    @Override
    public void render(Writer w_p) throws Exception {
        w_p.write("<!--writing paging navigation component (");
        w_p.write(this.getClass().getSimpleName());
        w_p.write(")-->\n");
        if (this.hasPaging() && this.shouldRenderComponent()) {
            w_p.write("<div id=\"OwNextResults_page\">\n");
            this.renderAccessibilityMark(w_p);
            this.renderFirstPage(w_p);
            this.renderPreviousPage(w_p);
            this.renderCurrentPage(w_p);
            this.renderNextPage(w_p);
            this.renderLastPage(w_p);
            this.renderNumberOfItems(w_p);
            w_p.write("</div>\n");
        }
        w_p.write("<!-- END writing paging navigation component (");
        w_p.write(this.getClass().getSimpleName());
        w_p.write(")-->\n");
    }

    private void renderLastPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            if (this.m_view.getCurrentPage() < this.m_view.getPageCount() - 1) {
                w_p.write("<a href=\"" + this.getPageAbsolutURL(this.m_view.getPageCount() - 1) + "\">\n");
                this.renderLastPageActiveContent(w_p);
                w_p.write("</a>\n");
            } else {
                this.renderLastPageInactiveContent(w_p);
            }
            w_p.write("</div>\n");
        }
    }

    private void renderNextPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            if (this.m_view.canPageNext()) {
                w_p.write("<a href=\"" + this.getPageNextURL() + "\">\n");
                this.renderNextPageActiveContent(w_p);
                w_p.write("</a>\n");
            } else {
                this.renderNextPageInactiveContent(w_p);
            }
            w_p.write("</div>\n");
        }
    }

    private void renderCurrentPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            String locationURL = this.m_view.getPageAbsolutEventURL("page=");
            if (locationURL == null) {
                locationURL = "null";
            }
            String lastPage = "" + this.getHumanReadablePageNumber(this.getLastPage());
            String currentPage = "" + this.getHumanReadablePageNumber(this.m_view.getCurrentPage());
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            w_p.write("<input id=\"navigationPage\" title=\"");
            w_p.write(this.m_view.getContext().localize("dmsdialogs.views.OwIndividualPageSelectionComponent.OwSimplePageSelectorComponent.current.page.title", "Current page"));
            w_p.write("\" type=\"text\" value=\"");
            w_p.write(Integer.toString(this.getDisplayCurrentPageNumber()));
            w_p.write("\" onblur='jumpTo(\"");
            w_p.write(locationURL);
            w_p.write("\",");
            w_p.write(currentPage);
            w_p.write(",");
            w_p.write(lastPage);
            w_p.write(");' onkeydown='processkey(event,this.form,\"");
            w_p.write(locationURL);
            w_p.write("\",");
            w_p.write(currentPage);
            w_p.write(",");
            w_p.write(lastPage);
            w_p.write(");' size=\"");
            w_p.write(Integer.toString(this.calculateInputFieldSize()));
            w_p.write("\" />\n");
            w_p.write("</div>\n");
        }
    }

    private int calculateInputFieldSize() throws Exception {
        int lastPage = this.getLastPage();
        return ("" + lastPage).length();
    }

    private void renderNumberOfItems(Writer w_p) throws Exception {
        if (this.shouldRenderComponent() && this.m_view.getCount() >= 0) {
            w_p.write("<div class=\"OwSimplePageSelectorSeparator\"></div>");
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            int pageSize = ((OwMainAppContext)this.m_view.getContext()).getPageSizeForLists();
            String firstItem = "" + (this.m_view.getCurrentPage() * pageSize + 1);
            int endIndex = (this.m_view.getCurrentPage() + 1) * pageSize;
            if (endIndex >= this.m_view.getCount()) {
                endIndex = this.m_view.getCount();
            }
            String lastItem = "" + endIndex;
            String message = this.m_view.getContext().localize3("dmsdialogs.views.OwIndividualPageSelectionComponent.OwSimplePageSelectorComponent.pagingDisplayMsg", "Displaying items %1 - %2 of %3", firstItem, lastItem, "" + this.m_view.getCount());
            w_p.write(message);
            w_p.write("</div>\n");
        }
    }

    private void renderPreviousPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            if (this.m_view.canPagePrev()) {
                w_p.write("<a href=\"" + this.getPagePrevURL() + "\">\n");
                this.renderPreviousPageActiveContent(w_p);
                w_p.write("</a>\n");
            } else {
                this.renderPreviousPageInactiveContent(w_p);
            }
            w_p.write("</div>\n");
        }
    }

    private void renderFirstPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<div class=\"" + this.getSimplePageSelectorStyleClass() + "\">\n");
            if (this.m_view.getCurrentPage() == 0) {
                this.renderFirstPageInactiveContent(w_p);
            } else {
                w_p.write("<a href=\"" + this.getPageAbsolutURL(0) + "\">\n");
                this.renderFirstPageActiveContent(w_p);
                w_p.write("</a>\n");
            }
            w_p.write("</div>\n");
        }
    }

    protected String getSimplePageSelectorStyleClass() {
        return "OwSimplePageSelector";
    }

    protected abstract void renderFirstPageInactiveContent(Writer var1) throws Exception;

    protected abstract void renderFirstPageActiveContent(Writer var1) throws Exception;

    protected abstract void renderPreviousPageInactiveContent(Writer var1) throws Exception;

    protected abstract void renderPreviousPageActiveContent(Writer var1) throws Exception;

    protected abstract void renderNextPageInactiveContent(Writer var1) throws Exception;

    protected abstract void renderNextPageActiveContent(Writer var1) throws Exception;

    protected abstract void renderLastPageInactiveContent(Writer var1) throws Exception;

    protected abstract void renderLastPageActiveContent(Writer var1) throws Exception;
}

