/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwBatchPropertiesHandler;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OwStandardBatchPropertiesHandler
implements OwBatchPropertiesHandler {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardBatchPropertiesHandler.class);
    protected Collection m_batchIndexProperties;
    protected OwDocument m_document;
    protected OwPropertyCollection m_properties;
    protected static final String BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME = "OwObjectPropertyViewBatchIndexProperties";

    public OwStandardBatchPropertiesHandler(OwDocument document_p) {
        this.m_document = document_p;
        this.m_properties = new OwStandardPropertyCollection();
    }

    @Override
    public void setBatchIndexProperties(Collection batchIndexProperties_p) {
        this.m_batchIndexProperties = batchIndexProperties_p;
    }

    @Override
    public void saveBatchIndexProperties() throws Exception {
        if (this.m_batchIndexProperties != null) {
            if (null != this.m_document) {
                OwStandardPropertyCollection savedBatchProperties = new OwStandardPropertyCollection();
                Iterator it = this.m_batchIndexProperties.iterator();
                while (it.hasNext()) {
                    OwProperty prop = (OwProperty)this.m_properties.get(it.next());
                    if (null == prop) continue;
                    savedBatchProperties.put(prop.getPropertyClass().getClassName(), prop);
                }
                this.m_document.setAttribute(BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME, savedBatchProperties);
            } else {
                String msg = "OwObjectPropertyView.safeBatchIndexProperties: Use OwPropViewDocument as the document class for batch indexing to work.";
                LOG.error((Object)msg);
                throw new OwInvalidOperationException(msg);
            }
        }
    }

    @Override
    public void clearBatchIndex() throws OwInvalidOperationException {
        if (null == this.m_document) {
            String msg = "OwObjectPropertyView.clearBatchIndex: Use OwPropViewDocument as the document class for batch indexing to work.";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        this.m_document.remove(BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME);
    }

    @Override
    public void onBatchIndex() throws Exception {
        if (null != this.m_document) {
            OwPropertyCollection propCollection = (OwPropertyCollection)this.m_document.getAttribute(BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME);
            if (null != propCollection) {
                Iterator it = propCollection.keySet().iterator();
                while (it.hasNext()) {
                    OwProperty propPrev = (OwProperty)propCollection.get(it.next());
                    OwProperty propCurrent = (OwProperty)this.m_properties.get(propPrev.getPropertyClass().getClassName());
                    if (null == propCurrent) continue;
                    propCurrent.setValue(propPrev.getValue());
                }
            }
        } else {
            String msg = "OwObjectPropertyView.onBatchIndex: use OwPropViewDocument as the document class for batch indexing to work.";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) {
        this.m_properties = properties_p;
    }
}

