/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import org.w3c.dom.Node;

public class OwVicinityPageSelectorComponent
extends OwPageSelectorComponent {
    private static final int FIRST_PAGE_DISPLAY_NUMBER = 1;
    private int m_numberOfSelectablePages = 5;

    public OwVicinityPageSelectorComponent(OwPageableView view_p) {
        super(view_p);
    }

    @Override
    public void render(Writer w_p) throws Exception {
        w_p.write("<!--writing paging navigation component (OwVicinityPageSelectorComponent)-->\n");
        if (this.hasPaging() && this.shouldRenderComponent()) {
            w_p.write("<div id=\"OwNextResults_page\">\n");
            this.renderAccessibilityMark(w_p);
            this.renderNumberOfItems(w_p);
            this.renderJumpTo(w_p);
            this.renderFirstPage(w_p);
            this.renderPagesNearCurrentPage(w_p);
            this.renderLastPage(w_p);
            w_p.write(" </div>\n");
        }
        w_p.write("<!--END writing paging navigation component (OwVicinityPageSelectorComponent)-->\n");
    }

    private void renderJumpTo(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<script type=\"text/javascript\">\n");
            w_p.write("function jumpTo() {\n     var page = prompt(" + this.getSelectPageNumberMessage() + ",'" + this.getDisplayCurrentPageNumber() + "');\n" + "     if (page>0 && page<=" + this.getHumanReadablePageNumber(this.getLastPage()) + ") {\n" + "        document.location='" + this.m_view.getPageAbsolutEventURL("page=") + "'+(page-1);\n" + "     };\n" + "}\n");
            w_p.write("</script>\n");
            w_p.write("<div class=\"OwIndividualPageSelection\">\n");
            w_p.write("<span>&nbsp;\u2022&nbsp;</span><a title=\"" + this.getPromptTitleMessage() + "\" onclick=\"jumpTo()\" href=\"#\">" + this.getPageOfMessage() + " " + this.getHumanReadablePageNumber(this.getLastPage()) + "</a>\n");
            w_p.write("<span>&nbsp;\u2022&nbsp;</span></div>\n");
        }
    }

    private String getPageOfMessage() throws Exception {
        return this.m_view.getContext().localize1("dmsdialogs.views.OwIndividualPageSelectionComponent.pageOf", "Page %1 of", "" + this.getDisplayCurrentPageNumber());
    }

    private String getPromptTitleMessage() {
        return this.m_view.getContext().localize("dmsdialogs.views.OwIndividualPageSelectionComponent.promptTitle", "Jump to page...");
    }

    private String getSelectPageNumberMessage() {
        return "'" + this.m_view.getContext().localize("dmsdialogs.views.OwIndividualPageSelectionComponent.pageNumberSelection", "Enter the page number you want to go to:") + "'";
    }

    private void renderNumberOfItems(Writer w_p) throws Exception {
        if (this.shouldRenderComponent()) {
            w_p.write("<div class=\"OwIndividualPageSelection\"><span>" + this.m_view.getCount() + " " + this.m_view.getContext().localize("dmsdialogs.views.OwIndividualPageSelectionComponent.items", "Items") + "</span>\n");
            w_p.write("</div>\n");
        }
    }

    private void renderLastPage(Writer w_p) throws Exception {
        if (this.getLastPage() != this.getLastPageToBeRendered()) {
            w_p.write("<div class=\"OwIndividualPageSelection\">\n");
            w_p.write("<a href=\"" + this.getPageAbsolutURL(this.getLastPage()) + "\">&nbsp;" + this.getHumanReadablePageNumber(this.getLastPage()) + "&nbsp;</a>\n");
            w_p.write("</div>\n");
        }
    }

    private void renderPagesNearCurrentPage(Writer w_p) throws Exception {
        if (this.m_numberOfSelectablePages < 1) {
            throw new Exception("Invalid configuration: " + this.m_numberOfSelectablePages);
        }
        if (this.shouldRenderComponent()) {
            int currentPage = this.m_view.getCurrentPage();
            int firstPageToBeRendered = this.getFirstPageToBeRendered();
            int lastPage = this.getLastPage();
            int lastPageToBeRendered = this.getLastPageToBeRendered();
            w_p.write("<div class=\"OwIndividualPageSelection\">\n");
            for (int i = firstPageToBeRendered; i <= lastPageToBeRendered; ++i) {
                if (i == firstPageToBeRendered && firstPageToBeRendered > 1) {
                    w_p.write("<span>..</span>\n");
                }
                if (i == currentPage) {
                    w_p.write("<span class=\"OwIndividualPageSelection_selected\">&nbsp;" + this.getDisplayCurrentPageNumber() + "&nbsp;</span>\n");
                } else {
                    w_p.write("<a href=\"" + this.getPageAbsolutURL(i) + "\">&nbsp;" + this.getHumanReadablePageNumber(i) + "&nbsp;</a>\n");
                }
                if (i != lastPageToBeRendered || lastPageToBeRendered >= lastPage - 1) continue;
                w_p.write("<span>..</span>\n");
            }
            w_p.write("</div>\n");
        }
    }

    private int getLastPageToBeRendered() throws Exception {
        int possibleLastPage;
        int lastPage = this.getLastPage();
        int lastPageToBeRendered = this.m_view.getCurrentPage() + this.m_numberOfSelectablePages / 2;
        if ((lastPageToBeRendered = Math.min(lastPageToBeRendered, lastPage)) < (possibleLastPage = this.m_numberOfSelectablePages / 2 * 2) && possibleLastPage <= this.getLastPage()) {
            lastPageToBeRendered = possibleLastPage;
        }
        return lastPageToBeRendered;
    }

    private int getFirstPageToBeRendered() throws Exception {
        int possibleFirstPage;
        int firstPageToBeRendered = this.m_view.getCurrentPage() - this.m_numberOfSelectablePages / 2;
        if ((firstPageToBeRendered = Math.max(0, firstPageToBeRendered)) > (possibleFirstPage = this.getLastPage() - this.m_numberOfSelectablePages / 2 * 2) && possibleFirstPage >= 0) {
            firstPageToBeRendered = possibleFirstPage;
        }
        return firstPageToBeRendered;
    }

    private void renderFirstPage(Writer w_p) throws Exception {
        if (this.shouldRenderComponent() && this.m_view.getCurrentPage() != 0 && this.getFirstPageToBeRendered() != 0) {
            w_p.write("<div class=\"OwIndividualPageSelection\"><a href=\"" + this.getPageAbsolutURL(0) + "\">\n");
            w_p.write("&nbsp;1&nbsp;");
            w_p.write("</a></div>\n");
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        Node node = OwXMLDOMUtil.getChildNode(this.m_configNode, "NumberOfSelectablePages");
        if (node != null) {
            String maxSelectablePages = node.getFirstChild().getNodeValue().trim();
            LOG.debug((Object)("OwVicinityPageSelectorComponent.init: Maximum number of selectable pages is = " + maxSelectablePages));
            this.m_numberOfSelectablePages = Integer.parseInt(maxSelectablePages);
        } else {
            LOG.debug((Object)("OwVicinityPageSelectorComponent.init: No <NumberOfSelectablePages> element in the configuration, using default value = " + this.m_numberOfSelectablePages));
        }
    }
}

