/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardDBAttributeBagWriteableFactory;
import com.wewebu.ow.server.util.OwStandardDBInvertedAttributeBag;
import com.wewebu.ow.server.util.OwTableSpec;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public class OwAttributeBagResolver
implements OwAttributeBagsSupport {
    private static final Logger LOG = OwLogCore.getLogger(OwAttributeBagResolver.class);
    public static OwTableSpec DB_ATTRIBUTE_BAG_TABLE = new OwTableSpec();
    protected OwStandardDBAttributeBagWriteableFactory m_writeablebagfactory;

    public static OwAttributeBagResolver createAndCheckResolver(OwNetworkContext networkContext_p) throws OwNotSupportedException {
        OwAttributeBagResolver resolver = new OwAttributeBagResolver();
        try {
            resolver.getUserKeyAttributeBagWriteable(networkContext_p, "testBag", "testUser");
            return resolver;
        }
        catch (Exception e) {
            LOG.debug((Object)"DB AttributeBags are not supported (configuration/initialisation error or not configured)!", (Throwable)e);
            throw new OwNotSupportedException(networkContext_p.localize("app.OwAttributeBagResolver.db.bags.not.supported", "DB bags are not supported!"), (Throwable)e);
        }
    }

    @Override
    public OwAttributeBag getNameKeyAttributeBag(OwNetworkContext context_p, String bagname_p, String attributename_p) throws Exception {
        JdbcTemplate jdbc = context_p.getJDBCTemplate();
        if (jdbc == null) {
            String msg = "OwAttributeBagResolver.getAttributeBagWriteable: No DataSource was specified, so DB-AttributeBag is not available.";
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        OwAttributeBagResolver.initTableName(context_p);
        return new OwStandardDBInvertedAttributeBag(jdbc, bagname_p, attributename_p, DB_ATTRIBUTE_BAG_TABLE);
    }

    private static void initTableName(OwNetworkContext context_p) {
        try {
            OwXMLUtil bootstrapConfiguration = ((OwMainAppContext)context_p).getConfiguration().getBootstrapConfiguration();
            OwXMLUtil ecmAdapterUtil = bootstrapConfiguration.getSubUtil("EcmAdapter");
            OwXMLUtil attributeBagTableXML = ecmAdapterUtil.getSubUtil("DbAttributeBagTableName");
            if (null != attributeBagTableXML) {
                DB_ATTRIBUTE_BAG_TABLE = OwTableSpec.fromXML(attributeBagTableXML);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot detect the name of the ATTRIBUTE_BAG table. Using default name: " + DB_ATTRIBUTE_BAG_TABLE.getTableName()), (Throwable)e);
            }
            LOG.warn((Object)("OwAttributeBagResolver.initTableName: Cannot detect the name of the ATTRIBUTE_BAG table. Using default name: " + DB_ATTRIBUTE_BAG_TABLE.getTableName()));
        }
    }

    @Override
    public OwAttributeBagWriteable getUserKeyAttributeBagWriteable(OwNetworkContext context_p, String bagname_p, String username_p) throws Exception {
        JdbcTemplate jdbc = context_p.getJDBCTemplate();
        if (jdbc == null) {
            String msg = "OwAttributeBagResolver.getAttributeBagWriteable: No DataSource was specified, so DB-AttributeBag is not available.";
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        OwAttributeBagResolver.initTableName(context_p);
        if (null != username_p) {
            OwStandardDBAttributeBagWriteableFactory owStandardDBAttributeBagWriteableFactory = new OwStandardDBAttributeBagWriteableFactory(jdbc, username_p, DB_ATTRIBUTE_BAG_TABLE);
            owStandardDBAttributeBagWriteableFactory.init();
            return owStandardDBAttributeBagWriteableFactory.getBag(bagname_p);
        }
        try {
            if (null == this.m_writeablebagfactory) {
                this.m_writeablebagfactory = new OwStandardDBAttributeBagWriteableFactory(jdbc, context_p.getCurrentUser().getUserID(), DB_ATTRIBUTE_BAG_TABLE);
                this.m_writeablebagfactory.init();
            }
            return this.m_writeablebagfactory.getBag(bagname_p);
        }
        catch (Exception e) {
            String msg = "Error getting application object, name = " + bagname_p;
            LOG.error((Object)msg, (Throwable)e);
            throw new OwObjectNotFoundException(msg, (Throwable)e);
        }
    }
}

