/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwSemiVirtualRecordClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Map;

public class OwManagedSemiVirtualRecordConfiguration {
    private static Collection<String> findSelectiveConfigurationIds(OwRoleManager roleManager_p) throws OwConfigurationException {
        try {
            return roleManager_p.getAllowedResources(8);
        }
        catch (OwConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not create semi virtual folder classes.", (Throwable)e);
        }
    }

    public OwSemiVirtualRecordClass semiVirtualFolderForObjectClass(String className_p, OwRoleManager roleManager_p, OwXMLUtil configuration_p) throws OwException {
        Map<String, OwSemiVirtualRecordClass> semivirtualfolderMap = OwSemiVirtualRecordClass.createVirtualRecordClasses(configuration_p, OwManagedSemiVirtualRecordConfiguration.findSelectiveConfigurationIds(roleManager_p));
        OwSemiVirtualRecordClass virtualFolderEntry = semivirtualfolderMap.get(className_p);
        if (virtualFolderEntry != null) {
            String virtualFolder = virtualFolderEntry.getVirtualFolder();
            try {
                if (roleManager_p != null && !roleManager_p.isAllowed(12, virtualFolder)) {
                    virtualFolderEntry = null;
                }
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OwInvalidOperationException("Could not search semivirtual folder for object class " + className_p, (Throwable)e);
            }
        }
        return virtualFolderEntry;
    }
}

