/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwSemiVirtualRecordClass {
    private static final Logger LOG = OwLogCore.getLogger(OwSemiVirtualRecordClass.class);
    public static final String SEMIVIRTUALRECORDCLASSES_ELEMENT = "SemiVirtualRecordClasses";
    public static final String SEMIVIRTUALRECORDCLASSNAME_ELEMENT = "SemiVirtualRecordClassName";
    public static final String INCLUDEPHYSICALCHILDS_ATTRIBUTE = "includephysicalchilds";
    public static final String FOLDERCLASSNAME_ATTRIBUTE = "folderclassname";
    public static final String VIRTUALFOLDER_ATTRIBUTE = "virtualfolder";
    public static final String SEARCHSUBSTRUCTURE_ATTRIBUTE = "searchSubstructure";
    private String virtualFolder;
    private String folderClassName;
    private boolean includePhysicalChilds;
    private boolean searchSubstructure;
    private Map propertyMapping;

    public static final Map<String, OwSemiVirtualRecordClass> createVirtualRecordClasses(OwXMLUtil configuration_p) throws OwConfigurationException {
        return OwSemiVirtualRecordClass.createVirtualRecordClasses(configuration_p, null);
    }

    public static final Map<String, OwSemiVirtualRecordClass> createVirtualRecordClasses(OwXMLUtil configuration_p, Collection<String> selectiveConfigurationIds_p) throws OwConfigurationException {
        String optionId = null;
        if (selectiveConfigurationIds_p != null) {
            try {
                for (String id : selectiveConfigurationIds_p) {
                    int i;
                    String key = id.substring(0, i = id.lastIndexOf(46));
                    if (!SEMIVIRTUALRECORDCLASSES_ELEMENT.equals(key)) continue;
                    optionId = id.substring(i + 1, id.length());
                    break;
                }
            }
            catch (Exception e) {
                throw new OwConfigurationException("Could not create virtual record classes.", (Throwable)e);
            }
        }
        List list = configuration_p.getSafeUtilList(SEMIVIRTUALRECORDCLASSES_ELEMENT);
        HashMap<String, OwSemiVirtualRecordClass> semivirtualfolderMap = new HashMap<String, OwSemiVirtualRecordClass>();
        for (OwXMLUtil declaration : list) {
            String declarationOptionId = declaration.getSafeStringAttributeValue("optionid", null);
            if ((optionId != null || declarationOptionId != null) && declarationOptionId != null && !declarationOptionId.equals(optionId)) continue;
            List recordClassDeclarations = declaration.getSafeNodeList();
            for (Node recordClassDeclaration : recordClassDeclarations) {
                OwSemiVirtualRecordClass entry = new OwSemiVirtualRecordClass(recordClassDeclaration);
                semivirtualfolderMap.put(entry.getFolderClassName(), entry);
            }
        }
        return semivirtualfolderMap;
    }

    public OwSemiVirtualRecordClass(Node n_p) throws OwConfigurationException {
        this.virtualFolder = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, VIRTUALFOLDER_ATTRIBUTE, null);
        if (null == this.virtualFolder) {
            String msg = "OwSemiVirtualRecordClass: Please define \"virtualfolder\" attribute for SemiVirtualRecordClassName node in the owbootstrap.xml.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.folderClassName = OwXMLDOMUtil.getSafeStringAttributeValue(n_p, FOLDERCLASSNAME_ATTRIBUTE, null);
        if (null == this.folderClassName) {
            String msg = "OwSemiVirtualRecordClass: Please define \"folderclassname\" attribute for SemiVirtualRecordClassName node in the owbootstrap.xml.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.includePhysicalChilds = OwXMLDOMUtil.getSafeBooleanAttributeValue(n_p, INCLUDEPHYSICALCHILDS_ATTRIBUTE, false);
        this.searchSubstructure = OwXMLDOMUtil.getSafeBooleanAttributeValue(n_p, SEARCHSUBSTRUCTURE_ATTRIBUTE, false);
        this.propertyMapping = new HashMap();
        List propertymappings = OwXMLDOMUtil.getSafeNodeList(n_p);
        for (Node vfProperty : propertymappings) {
            if (null == vfProperty.getFirstChild()) continue;
            this.propertyMapping.put(vfProperty.getFirstChild().getNodeValue(), OwXMLDOMUtil.getSafeStringAttributeValue(vfProperty, "folderproperty", null));
        }
    }

    public String getFolderClassName() {
        return this.folderClassName;
    }

    public String getVirtualFolder() {
        return this.virtualFolder;
    }

    public boolean isIncludePhysicalChilds() {
        return this.includePhysicalChilds;
    }

    public Map getPropertyMapping() {
        return this.propertyMapping;
    }

    public boolean isSearchSubstructure() {
        return this.searchSubstructure;
    }
}

