/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwStandardObjectCollection
extends ArrayList
implements OwObjectCollection {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = OwLogCore.getLogger(OwStandardObjectCollection.class);
    private Map m_Attributes = null;

    @Override
    public void sort(OwSort sortCriteria_p) throws Exception {
        Iterator<OwSort.OwSortCriteria> it = sortCriteria_p.getCriteriaCollection().iterator();
        while (it.hasNext()) {
            Collections.sort(this, new OwObjectCollectionComparator(it.next()));
        }
    }

    @Override
    public boolean isComplete() throws Exception {
        Object o;
        if (this.m_Attributes != null && (o = this.m_Attributes.get("ow_complete")) != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                String val = (String)o;
                if (Boolean.TRUE.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase(val)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setComplete(boolean fComplete_p) {
        this.setAttribute("ow_complete", fComplete_p);
    }

    @Override
    public boolean hasNext() throws Exception {
        return false;
    }

    @Override
    public boolean hasPrev() throws Exception {
        return false;
    }

    @Override
    public void getNext() throws Exception {
    }

    @Override
    public void getPrev() throws Exception {
    }

    @Override
    public Object getAttribute(int iIndex_p) throws Exception {
        throw new OwInvalidOperationException("OwStandardObjectCollection.getAttribute(int iIndex_p): Not implemented, use getAttribute(String strName_p).");
    }

    @Override
    public Object getSafeAttribute(String strName_p, Object default_p) {
        if (null != this.m_Attributes) {
            Object obj = this.m_Attributes.get(strName_p);
            if (obj != null) {
                return obj;
            }
            return default_p;
        }
        return default_p;
    }

    @Override
    public Object getAttribute(String strName_p) throws Exception {
        if (null != this.m_Attributes) {
            Object obj = this.m_Attributes.get(strName_p);
            if (obj != null) {
                return obj;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwStandardObjectCollection.getAttribute(String strName_p): Object not found Exception, strName_p = " + strName_p));
            }
            throw new OwObjectNotFoundException("OwStandardObjectCollection.getAttribute(String strName_p): strName_p = " + strName_p);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwStandardObjectCollection.getAttribute(String strName_p): Object not found Exception, The map for the OwAttributeBag implementation (Attributes == null), strName_p = " + strName_p));
        }
        throw new OwObjectNotFoundException("OwStandardObjectCollection.getAttribute(String strName_p): The map for the OwAttributeBag implementation (Attributes == null), strName_p = " + strName_p);
    }

    public void setAttribute(String strName_p, Object object_p) {
        if (null == this.m_Attributes) {
            this.m_Attributes = new HashMap();
        }
        this.m_Attributes.put(strName_p, object_p);
    }

    @Override
    public boolean hasAttribute(String strName_p) {
        if (null != this.m_Attributes) {
            return this.m_Attributes.containsKey(strName_p);
        }
        return false;
    }

    @Override
    public Collection getAttributeNames() {
        if (null != this.m_Attributes) {
            return this.m_Attributes.keySet();
        }
        return new ArrayList();
    }

    @Override
    public int attributecount() {
        return this.m_Attributes.size();
    }

    public boolean addAll(OwObjectCollection c, int iMaxSize_p) throws Exception {
        boolean changed = false;
        int currentSize = this.size();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (currentSize >= iMaxSize_p) break;
            this.add(object);
            changed = true;
        }
        if (it.hasNext() || !c.isComplete()) {
            this.setComplete(false);
        }
        this.setAttribute("ow_size", this.size());
        return changed;
    }

    protected static class OwObjectCollectionComparator
    implements Comparator {
        private OwSort.OwSortCriteria m_SortCriteria;

        public OwObjectCollectionComparator(OwSort.OwSortCriteria sortCriteria_p) {
            this.m_SortCriteria = sortCriteria_p;
        }

        public int compare(Object o1_p, Object o2_p) {
            int iRet = 0;
            OwProperty prop1 = null;
            OwProperty prop2 = null;
            try {
                prop1 = ((OwObject)o1_p).getProperty(this.m_SortCriteria.getPropertyName());
                prop2 = ((OwObject)o2_p).getProperty(this.m_SortCriteria.getPropertyName());
                Object value1 = prop1.getValue();
                Object value2 = prop2.getValue();
                if (value1 == null && value2 == null) {
                    iRet = 0;
                } else if (value1 == null) {
                    iRet = -1;
                } else if (value2 == null) {
                    iRet = 1;
                } else if (value1 instanceof String && value2 instanceof String) {
                    String v1 = (String)value1;
                    String v2 = (String)value2;
                    v1 = v1.replaceAll(" ", "");
                    v2 = v2.replaceAll(" ", "");
                    iRet = v1.compareToIgnoreCase(v2);
                } else {
                    iRet = prop1.compareTo(prop2);
                }
            }
            catch (Exception e) {
                iRet = prop1 == null && prop2 == null ? 0 : (prop1 == null ? -1 : 1);
            }
            if (!this.m_SortCriteria.getAscFlag()) {
                return -1 * iRet;
            }
            return iRet;
        }
    }
}

