/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.collections.OwAggregateIterable;
import com.wewebu.ow.server.collections.OwIterable;
import com.wewebu.ow.server.collections.OwLoadContext;
import com.wewebu.ow.server.collections.OwObjectCollectionIterableAdapter;
import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwSearchPathField;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardSearchTemplate;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwHeaderFieldColumnInfoDecorator;
import com.wewebu.ow.server.field.OwPriorityRule;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwStandardVirtualFolderObjectFactory
implements OwVirtualFolderObjectFactory,
OwVirtualFolderObject {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardVirtualFolderObjectFactory.class);
    public static final String MIME_TYPE = "ow_default/virtual_folder";
    public static final String NODE_ATTRIBUTE_MIME_TYPE = "mimetype";
    protected static final String NODE_ATTRIBUTE_CONTAINS_DOCUMENTS = "containsdocs";
    protected static final String NODE_ATTRIBUTE_NAME = "name";
    protected static final String NODE_TAG_NAME = "node";
    protected static final String SEARCH_NODE_TAG_NAME = "search";
    protected static final String REFINE_CRITERIA_NODE_TAG_NAME = "refinecriteria";
    protected static final OwVirtualFolderObjectClass m_StandardClassDescription = new OwVirtualFolderObjectClass();
    protected OwObjectCollection m_folderChilds;
    protected OwStandardVirtualFolderObjectFactory m_parent;
    protected OwRepository m_repository;
    private OwNetworkContext m_context;
    protected Node m_rootNode;
    protected OwPropertyCollection m_PropertyMap;
    protected String m_nodePath = "/";
    protected String m_objectPath = "/";
    protected OwXMLUtil m_OpenFolderNode;
    protected String m_strDMSID;
    protected OwSearchTemplate m_SearchTemplate;
    protected List m_refinementCriteriaList;
    protected Set m_searchTemplateRefinementCriteriaNameSet;
    private Map searchCriteriaMap;
    private Map propagationMap;
    private String m_virtualFolderName;

    @Override
    public void init(OwNetworkContext context_p, OwRepository repository_p, String strBaseDMSID_p, String virtualFolderName_p, Node rootNode_p) throws Exception {
        this.m_repository = repository_p;
        this.m_context = context_p;
        this.m_virtualFolderName = virtualFolderName_p;
        this.m_strDMSID = strBaseDMSID_p;
        this.m_rootNode = rootNode_p;
        this.m_OpenFolderNode = new OwStandardXMLUtil(this.getSubNode(this.m_nodePath));
        this.createProperties(this.nameFromNode(this.m_OpenFolderNode));
    }

    private String nameFromNode(OwXMLUtil folderNode_p) {
        return folderNode_p.getNode().getAttributes().getNamedItem(NODE_ATTRIBUTE_NAME).getNodeValue();
    }

    private void validateSearchTemplate() throws Exception, OwConfigurationException {
        List refineCriteriaList = this.getRefineCriteriaList();
        for (OwVirtualFolderRefineCriteria refCriteria : refineCriteriaList) {
            this.validateRefineCriteria(refCriteria.m_strCriteria);
        }
    }

    protected OwStandardVirtualFolderObjectFactory createNewSubfolderInstance() throws Exception {
        return new OwStandardVirtualFolderObjectFactory();
    }

    public OwNetworkContext getContext() {
        return this.m_context;
    }

    public OwRepository getRepository() {
        return this.m_repository;
    }

    protected Node getRootNode() throws Exception {
        return this.m_rootNode;
    }

    protected Node getSubNode(String strPath_p) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(strPath_p, "/");
        Node node = this.getRootNode();
        while (tokenizer.hasMoreElements()) {
            String strPathToken = tokenizer.nextToken();
            boolean fFound = false;
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                String strName;
                if (!"root".equals(n.getNodeName()) && !NODE_TAG_NAME.equals(n.getNodeName()) || !(strName = n.getAttributes().getNamedItem(NODE_ATTRIBUTE_NAME).getNodeValue()).equals(strPathToken)) continue;
                node = n;
                fFound = true;
                break;
            }
            if (fFound) continue;
            return null;
        }
        return node;
    }

    protected void createProperties(String strName_p) throws Exception {
        if (this.m_PropertyMap == null) {
            this.m_PropertyMap = new OwStandardPropertyCollection();
            String localizedName = OwString.localizeLabel(this.m_context.getLocale(), strName_p, strName_p);
            this.m_PropertyMap.put(OwResource.m_ObjectNamePropertyClass.getClassName(), new OwStandardProperty(localizedName, this.getObjectClass().getPropertyClass(OwResource.m_ObjectNamePropertyClass.getClassName())));
        }
    }

    public boolean isRoot() throws Exception {
        return this == this.getRootObject();
    }

    @Override
    public String getName() {
        try {
            return ((OwStandardProperty)this.m_PropertyMap.get(OwResource.m_ObjectNamePropertyClass.getClassName())).getValue().toString();
        }
        catch (Exception e) {
            return "[undef]";
        }
    }

    @Override
    public String getID() {
        return this.getName();
    }

    protected List getRefineCriteriaList() throws Exception {
        if (this.m_refinementCriteriaList == null) {
            this.m_refinementCriteriaList = this.getRefineCriteriaListForNode(this.m_OpenFolderNode);
            OwStandardVirtualFolderObjectFactory bottomUpScan = this.m_parent;
            while (bottomUpScan != null && bottomUpScan.getRootNode() != this.getRootNode()) {
                this.m_refinementCriteriaList.addAll(0, bottomUpScan.getRefineCriteriaList());
                bottomUpScan = bottomUpScan.m_parent;
            }
        }
        return this.m_refinementCriteriaList;
    }

    protected Set getSearchTemplateRefineCriteriaNameSet() throws Exception {
        if (this.m_searchTemplateRefinementCriteriaNameSet == null) {
            this.m_searchTemplateRefinementCriteriaNameSet = new HashSet();
            this.scanSearchNode(this.m_rootNode);
            if ((this.m_searchTemplateRefinementCriteriaNameSet == null || this.m_searchTemplateRefinementCriteriaNameSet.size() == 0) && this.getParent() != null && this.getParent().getSearchTemplate().equals(this.getSearchTemplate())) {
                throw new OwConfigurationException("The virtual Searchtemplate seems to have no refine criteria!");
            }
            if (this.propagationMap != null) {
                this.m_searchTemplateRefinementCriteriaNameSet.addAll(this.propagationMap.keySet());
            }
        }
        return this.m_searchTemplateRefinementCriteriaNameSet;
    }

    protected void scanSearchNode(Node searchDOMNode_p) throws Exception {
        List nodeList;
        if (searchDOMNode_p.getNodeType() == 1 && NODE_TAG_NAME.equals(searchDOMNode_p.getNodeName()) && (nodeList = this.getRefineCriteriaListForNode(new OwStandardXMLUtil(searchDOMNode_p))) != null) {
            for (OwVirtualFolderRefineCriteria refineCriteria : nodeList) {
                this.m_searchTemplateRefinementCriteriaNameSet.add(refineCriteria.m_strCriteria);
            }
        }
        for (Node n = searchDOMNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !NODE_TAG_NAME.equals(n.getNodeName())) continue;
            this.scanSearchNode(n);
        }
    }

    private List getRefineCriteriaListForNode(OwXMLUtil node_p) {
        LinkedList<OwVirtualFolderRefineCriteria> refineCriteriaList = new LinkedList<OwVirtualFolderRefineCriteria>();
        List refineNodes = node_p.getSafeNodeList(REFINE_CRITERIA_NODE_TAG_NAME);
        if (refineNodes != null) {
            for (Node n : refineNodes) {
                String strCriteriaName = n.getAttributes().getNamedItem("symname").getNodeValue();
                Node l = null;
                if (n.hasChildNodes()) {
                    l = n.getFirstChild();
                }
                refineCriteriaList.add(new OwVirtualFolderRefineCriteria(strCriteriaName, l));
            }
        }
        return refineCriteriaList;
    }

    private void validateRefineCriteria(String strCriteriaName_p) throws OwConfigurationException {
        if (this.searchCriteriaMap == null) {
            try {
                OwSearchNode searchTree = this.getSearchTemplate().getSearch(false);
                this.searchCriteriaMap = searchTree.getCriteriaMap(0);
            }
            catch (Exception e) {
                throw new OwConfigurationException("Could not get Searchtemplate to validate virtual search.", (Throwable)e);
            }
        }
        if (this.searchCriteriaMap.get(strCriteriaName_p) == null) {
            throw new OwConfigurationException("Invalid virtual Searchtemplate! RefineCriteria " + strCriteriaName_p + " not defined in WHERE clause!");
        }
    }

    protected OwSearchNode getRefinedSearch(OwSearchNode search_p, List refineList_p) throws Exception {
        List criteriaList = search_p.getCriteriaList(0);
        this.resetAllRefineCriteria(criteriaList);
        for (OwSearchCriteria searchcriteria : criteriaList) {
            for (OwVirtualFolderRefineCriteria refineCriteria : refineList_p) {
                if (!refineCriteria.m_strCriteria.equals(searchcriteria.getUniqueName())) continue;
                Object value = this.resolveLiteralValue(this.getName(), searchcriteria, refineCriteria.m_literalNode);
                searchcriteria.setValue(value);
            }
        }
        return search_p;
    }

    private void resetAllRefineCriteria(List criteriaList_p) throws Exception {
        Set searchTemplateRefineCriteriaNameSet = this.getSearchTemplateRefineCriteriaNameSet();
        for (OwSearchCriteria criteria : criteriaList_p) {
            String critName = criteria.getClassName();
            String uniqueCritName = criteria.getUniqueName();
            if (!searchTemplateRefineCriteriaNameSet.contains(critName) && !searchTemplateRefineCriteriaNameSet.contains(uniqueCritName)) continue;
            if (this.getPropagationMap() != null && !this.getPropagationMap().isEmpty()) {
                if (this.getPropagationMap().containsKey(critName)) {
                    criteria.setValue(this.getPropagationMap().get(critName));
                    continue;
                }
                if (this.getPropagationMap().containsKey(uniqueCritName)) {
                    criteria.setValue(this.getPropagationMap().get(uniqueCritName));
                    continue;
                }
                criteria.setValue(criteria.getDefaultValue());
                continue;
            }
            if (!criteria.isHidden() && !criteria.isReadonly()) continue;
            criteria.setValue(criteria.getDefaultValue());
        }
    }

    protected Object resolveLiteralValue(String contextname_p, OwFieldDefinition propClass_p, Node literal_p) throws Exception {
        if (literal_p == null) {
            return null;
        }
        String literal = literal_p.getNodeValue();
        if (null == literal) {
            return propClass_p.getValueFromNode(literal_p);
        }
        if (literal.startsWith("\\{")) {
            return propClass_p.getValueFromString(literal.substring(1));
        }
        if (literal.startsWith("{") && literal.endsWith("}")) {
            if (OwStandardSearchTemplate.isDocId(literal)) {
                return propClass_p.getValueFromNode(literal_p);
            }
            return this.resolveLiteralPlaceholder(contextname_p, literal.substring(1, literal.length() - 1));
        }
        return propClass_p.getValueFromNode(literal_p);
    }

    protected Object resolveLiteralPlaceholder(String contextname_p, String placeholdername_p) throws Exception {
        return this.getContext().resolveLiteralPlaceholder(contextname_p, placeholdername_p);
    }

    @Override
    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    @Override
    public OwObjectClass getObjectClass() {
        return m_StandardClassDescription;
    }

    protected OwStandardVirtualFolderObjectFactory getRootObject() throws Exception {
        if (this.getParent() != null) {
            return this.getParent().getRootObject();
        }
        return this;
    }

    protected OwStandardVirtualFolderObjectFactory getParent() throws Exception {
        return this.m_parent;
    }

    @Override
    public OwObjectCollection getParents() throws Exception {
        if (this.m_parent != null) {
            OwStandardObjectCollection parents = new OwStandardObjectCollection();
            parents.add(this.m_parent);
            return parents;
        }
        return null;
    }

    @Override
    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        OwSearchTemplate searchtemplate = this.getSearchTemplate();
        if (searchtemplate != null) {
            this.checkResetState();
            return this.getChilds(searchtemplate.getSearch(false), iObjectTypes_p, propertyNames_p, sort_p, iMaxSize_p, iVersionSelection_p, filterCriteria_p);
        }
        return null;
    }

    @Override
    public OwIterable<OwObject> getChildren(OwLoadContext loadContext) throws OwException {
        try {
            OwSearchTemplate searchtemplate = this.getSearchTemplate();
            if (searchtemplate != null) {
                this.checkResetState();
                return this.getChildren(searchtemplate.getSearch(false), loadContext);
            }
            return null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwServerException(e.getMessage(), (Throwable)e);
        }
    }

    protected OwObjectCollection getFolderChilds() throws Exception {
        if (this.m_folderChilds == null) {
            this.m_folderChilds = new OwStandardObjectCollection();
            for (Node n = this.m_OpenFolderNode.getNode().getFirstChild(); n != null; n = n.getNextSibling()) {
                OwSearchTemplate childTemplate;
                OwSearchTemplate thisSearchTemplate;
                if (!n.getNodeName().equals(NODE_TAG_NAME)) continue;
                String strSubPath = n.getAttributes().getNamedItem(NODE_ATTRIBUTE_NAME).getNodeValue();
                OwStandardVirtualFolderObjectFactory newChild = this.createNewSubfolderInstance();
                newChild.setPropagationMap(this.getPropagationMap());
                newChild.m_parent = this;
                OwStandardXMLUtil nodeUtil = new OwStandardXMLUtil(n);
                OwXMLUtil searchSubUtil = nodeUtil.getSubUtil(SEARCH_NODE_TAG_NAME);
                Node childRootNode = null;
                newChild.m_objectPath = this.m_objectPath.length() == 1 ? "/" + strSubPath : this.m_objectPath + "/" + strSubPath;
                if (searchSubUtil == null) {
                    newChild.m_nodePath = this.m_nodePath.length() == 1 ? "/" + strSubPath : this.m_nodePath + "/" + strSubPath;
                    childRootNode = this.getRootNode();
                } else {
                    newChild.m_nodePath = "/";
                    childRootNode = n;
                }
                newChild.init(this.m_context, this.m_repository, this.m_strDMSID, this.m_virtualFolderName, childRootNode);
                if (searchSubUtil != null && (thisSearchTemplate = this.getSearchTemplate()) != (childTemplate = newChild.getSearchTemplate())) {
                    OwSearchNode childSearch = childTemplate.getSearch(false);
                    OwSearchNode thisSearch = thisSearchTemplate.getSearch(false);
                    List refineCriteriaList = this.getRefineCriteriaList();
                    thisSearch = this.getRefinedSearch(thisSearch, refineCriteriaList);
                    this.deepCriteriaValuePropagation(childSearch, thisSearch);
                }
                this.m_folderChilds.add(newChild);
            }
        }
        return this.m_folderChilds;
    }

    protected void deepCriteriaValuePropagation(OwSearchNode childNode, OwSearchNode parentNode) throws Exception {
        Map thisCriteriaMap = parentNode.getCriteriaMap(0);
        Set thisEntries = thisCriteriaMap.entrySet();
        Map childCriteriaMap = childNode.getCriteriaMap(0);
        for (Map.Entry criteriaEntry : thisEntries) {
            Object criteriaKey = criteriaEntry.getKey();
            if ("OwClassSelectObject".equals(criteriaKey) || "OwClassFrom".equals(criteriaKey) || "OwClassSubclasses".equals(criteriaKey)) continue;
            OwSearchCriteria criteria = (OwSearchCriteria)criteriaEntry.getValue();
            Object value = criteria.getValue();
            if (childCriteriaMap.containsKey(criteriaKey)) {
                OwSearchCriteria childCriteria = (OwSearchCriteria)childCriteriaMap.get(criteriaKey);
                if (childCriteria.getDefaultValue() != null) continue;
                childCriteria.setValue(value);
                continue;
            }
            if (!"VirtualFolderSearchPathProperty".equals(criteriaKey)) continue;
            OwSearchNode specialNode = childNode.findSearchNode(2);
            if (specialNode == null) {
                specialNode = new OwSearchNode(1, 2);
                childNode.add(specialNode);
            }
            OwSearchNode searchPathNode = new OwSearchNode(OwSearchPathField.classDescription, 1025, value, 1, "VirtualFolderSearchPathProperty", "vfPathInstruction", null);
            specialNode.add(searchPathNode);
        }
    }

    private OwIterable<OwObject> getFolderChildren() throws Exception {
        return new OwObjectCollectionIterableAdapter<OwObject>(this.getFolderChilds());
    }

    public OwObjectCollection getChilds(OwSearchNode search_p, int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        OwStandardObjectCollection retCollection = new OwStandardObjectCollection();
        block4: for (int iObjectTypeindex = 0; iObjectTypeindex < iObjectTypes_p.length; ++iObjectTypeindex) {
            int iObjectType = iObjectTypes_p[iObjectTypeindex];
            switch (iObjectType) {
                case 8192: 
                case 8193: {
                    OwObjectCollection folderChilds = this.getFolderChilds();
                    retCollection.addAll(folderChilds, iMaxSize_p);
                    continue block4;
                }
                case 4096: 
                case 4097: {
                    if (!this.m_OpenFolderNode.getSafeBooleanAttributeValue(NODE_ATTRIBUTE_CONTAINS_DOCUMENTS, false)) continue block4;
                    List refineCriteriaList = this.getRefineCriteriaList();
                    OwSearchNode search = this.getRefinedSearch(search_p, refineCriteriaList);
                    if (iVersionSelection_p == 1) {
                        iVersionSelection_p = this.getSearchTemplate().getVersionSelection();
                    }
                    OwObjectCollection searchResult = this.m_repository.doSearch(search, sort_p, propertyNames_p, iMaxSize_p, iVersionSelection_p);
                    retCollection.addAll(searchResult, iMaxSize_p);
                    continue block4;
                }
            }
        }
        return retCollection;
    }

    private OwIterable<OwObject> getChildren(OwSearchNode search_p, OwLoadContext loadContext) throws Exception {
        ArrayList retCollection = new ArrayList();
        int[] iObjectTypes_p = loadContext.getObjectTypes();
        int iVersionSelection_p = loadContext.getVersionSelection();
        block4: for (int iObjectTypeindex = 0; iObjectTypeindex < iObjectTypes_p.length; ++iObjectTypeindex) {
            int iObjectType = iObjectTypes_p[iObjectTypeindex];
            switch (iObjectType) {
                case 8192: 
                case 8193: {
                    retCollection.add(this.getFolderChildren());
                    continue block4;
                }
                case 4096: 
                case 4097: {
                    if (!this.m_OpenFolderNode.getSafeBooleanAttributeValue(NODE_ATTRIBUTE_CONTAINS_DOCUMENTS, false)) continue block4;
                    List refineCriteriaList = this.getRefineCriteriaList();
                    OwSearchNode search = this.getRefinedSearch(search_p, refineCriteriaList);
                    if (iVersionSelection_p == 1) {
                        iVersionSelection_p = this.getSearchTemplate().getVersionSelection();
                    }
                    retCollection.add(this.m_repository.doSearch(search, loadContext));
                    continue block4;
                }
            }
        }
        return OwAggregateIterable.forList(retCollection);
    }

    protected boolean compatibleObjectClasses(OwClass classInfo_p, OwObjectClass objectClass_p) {
        String strObjectClassName = objectClass_p.getClassName();
        return classInfo_p.getClassName().equalsIgnoreCase(strObjectClassName);
    }

    @Override
    public void setFiledObjectProperties(OwObjectClass objectClass_p, OwPropertyCollection properties_p) throws Exception {
        OwSearchTemplate searchtemplate = this.getSearchTemplate();
        OwSearchNode specialNode = searchtemplate.getSearch(false).findSearchNode(2);
        if (null != specialNode) {
            boolean classInSearchTemplate = false;
            Object[] classes = this.findSearchTemplateClassesList(specialNode);
            if (null != classes) {
                for (int i = 0; i < classes.length; ++i) {
                    OwClass classinfo = (OwClass)classes[i];
                    if (!this.compatibleObjectClasses(classinfo, objectClass_p)) continue;
                    classInSearchTemplate = true;
                }
                if (!classInSearchTemplate) {
                    String msg = this.getContext().localize("OwStandardVirtualFolderObjectFactory.classmismatch", "The class of the new object must comply with the class of the virtual folder.");
                    LOG.error((Object)("OwStandardVirtualFolderObjectFactory.setFiledObjectProperties: " + msg));
                    throw new OwInvalidOperationException(msg);
                }
            }
        }
        OwSearchNode search = this.getRefinedSearch(searchtemplate.getSearch(false), this.getRefineCriteriaList());
        this.setFiledObjectPropertiesIter(search, objectClass_p, properties_p);
    }

    private void setFiledObjectPropertiesIter(OwSearchNode searchnode_p, OwObjectClass objectClass_p, OwPropertyCollection properties_p) throws Exception {
        switch (searchnode_p.getNodeType()) {
            case 1: {
                if (searchnode_p.getOperator() == 1) {
                    List Childs = searchnode_p.getChilds();
                    if (Childs == null) break;
                    for (int i = 0; i < Childs.size(); ++i) {
                        this.setFiledObjectPropertiesIter((OwSearchNode)Childs.get(i), objectClass_p, properties_p);
                    }
                    break;
                }
                String msg = "OwStandardVirtualFolderObjectFactory.setFiledObjectPropertiesIter: If you want to add documents to virtual folders, the search criteria in the search template may only be connected by AND.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            case 2: {
                break;
            }
            case 3: {
                String msg = "OwStandardVirtualFolderObjectFactory.setFiledObjectPropertiesIter: If you want to add documents to virtual folders, CBR conditions are not allowed in the search template.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            case 4: {
                OwSearchCriteria criteria = searchnode_p.getCriteria();
                if (null == criteria) break;
                String strPropertyName = criteria.getClassName();
                if (4 != criteria.getOperator()) {
                    LOG.fatal((Object)"OwStandardVirtualFolderObjectFactory.setFiledObjectPropertiesIter: If you want to add documents to virtual folders, the search template may only contain EQUAL criterias.");
                    throw new OwConfigurationException(this.getContext().localize("fncm.OwFNCMNetwork.virtualfolder.AddDocuments.EQUAL", "If you want to add documents to virtual folders, the search template may only contain EQUAL criteria."));
                }
                Object searchTemplateDefinedValue = criteria.getValue();
                if (null == searchTemplateDefinedValue) break;
                OwProperty prop = (OwProperty)properties_p.get(strPropertyName);
                if (null == prop) {
                    OwPropertyClass classDescription = objectClass_p.getPropertyClass(strPropertyName);
                    if (null == classDescription) {
                        String msg = "OwStandardVirtualFolderObjectFactory.setFiledObjectPropertiesIter: Property not found, PropertyName = " + strPropertyName;
                        LOG.error((Object)msg);
                        throw new OwObjectNotFoundException(msg);
                    }
                    prop = new OwStandardProperty(searchTemplateDefinedValue, classDescription);
                    properties_p.put(strPropertyName, prop);
                    break;
                }
                prop.setValue(searchTemplateDefinedValue);
                break;
            }
            case 5: {
                List childs = searchnode_p.getChilds();
                if (childs == null) break;
                for (int i = 0; i < childs.size(); ++i) {
                    this.setFiledObjectPropertiesIter((OwSearchNode)childs.get(i), objectClass_p, properties_p);
                }
                break;
            }
            default: {
                String msg = "OwStandardVirtualFolderObjectFactory.setFiledObjectPropertiesIter: Invalid node. If you want to add documents, the search template may only consist of AND-nodes and EQUAL criterias.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
        }
    }

    @Override
    public boolean canFilterChilds() throws Exception {
        return false;
    }

    @Override
    public Collection getFilterProperties(Collection propertynames_p) throws Exception {
        return null;
    }

    @Override
    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    @Override
    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    @Override
    public OwVersion getVersion() throws Exception {
        return null;
    }

    @Override
    public int getType() {
        return this.getObjectClass().getType();
    }

    @Override
    public String getDMSID() throws Exception {
        return this.m_strDMSID + "," + this.m_nodePath;
    }

    @Override
    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwProperty prop = (OwProperty)this.m_PropertyMap.get(strPropertyName_p);
        if (prop == null && this.m_parent != null) {
            prop = this.m_parent.getProperty(strPropertyName_p);
        } else if (null == prop) {
            String msg = "OwStandardVirtualFolderObjectFactory.getProperty: Cannot find the property, propertyName = " + strPropertyName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return prop;
    }

    @Override
    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        OwStandardPropertyCollection allProperties = new OwStandardPropertyCollection();
        if (this.m_parent != null) {
            allProperties.putAll(this.m_parent.getProperties(propertyNames_p));
        }
        allProperties.putAll(this.m_PropertyMap);
        return allProperties;
    }

    @Override
    public OwPropertyCollection getClonedProperties(Collection strPropertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties(this, strPropertyNames_p);
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        this.m_PropertyMap.putAll(properties_p);
    }

    @Override
    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canGetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canLock() throws Exception {
        return false;
    }

    @Override
    public boolean setLock(boolean fLock_p) throws Exception {
        return false;
    }

    @Override
    public boolean getLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    @Override
    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return true;
    }

    @Override
    public String getMIMEType() throws Exception {
        return this.m_OpenFolderNode != null ? this.m_OpenFolderNode.getSafeStringAttributeValue(NODE_ATTRIBUTE_MIME_TYPE, MIME_TYPE) : MIME_TYPE;
    }

    @Override
    public String getMIMEParameter() throws Exception {
        return "";
    }

    @Override
    public void delete() throws Exception {
        throw new OwNotSupportedException("OwStandardVirtualFolderObjectFactory.delete: Virtual folders do not support delete().");
    }

    @Override
    public boolean canDelete(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public void removeReference(OwObject oObject_p) throws Exception {
        throw new OwNotSupportedException("OwStandardVirtualFolderObjectFactory.removeReference: Virtual Folders do not support removeReference().");
    }

    @Override
    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    private Object[] findSearchTemplateClassesList(OwSearchNode searchNode_p) throws Exception {
        if (!searchNode_p.isCriteriaNode()) {
            Iterator itSearch = searchNode_p.getChilds().iterator();
            while (itSearch.hasNext()) {
                Object[] o = this.findSearchTemplateClassesList((OwSearchNode)itSearch.next());
                if (null == o) continue;
                return o;
            }
        } else if (searchNode_p.getCriteria().getFieldDefinition().getClassName().equals("OwClassSelectObject")) {
            Object o = searchNode_p.getCriteria().getValue();
            return (Object[])o;
        }
        return null;
    }

    @Override
    public void add(OwObject oObject_p) throws Exception {
        if (!this.m_OpenFolderNode.getSafeBooleanAttributeValue(NODE_ATTRIBUTE_CONTAINS_DOCUMENTS, false)) {
            throw new OwInvalidOperationException(this.getContext().localize("fncm.OwFNCMNetwork.virtualfoldernodocuments", "This virtual folder cannot contain documents."));
        }
        OwObjectClass objectClass = oObject_p.getObjectClass();
        OwSearchNode specialNode = this.getSearchTemplate().getSearch(false).findSearchNode(2);
        if (null != specialNode) {
            boolean classInSearchTemplate = false;
            Object[] classes = this.findSearchTemplateClassesList(specialNode);
            if (null != classes) {
                for (int i = 0; i < classes.length; ++i) {
                    OwClass classinfo = (OwClass)classes[i];
                    if (!this.compatibleObjectClasses(classinfo, objectClass)) continue;
                    classInSearchTemplate = true;
                }
                if (!classInSearchTemplate) {
                    throw new OwInvalidOperationException(this.getContext().localize("fncm.OwFNCMNetwork.virtualfolderclassmismatch", "Class of the new document must correspond to the class of the virtual folder."));
                }
            }
        }
        OwStandardPropertyCollection props = new OwStandardPropertyCollection();
        this.setFiledObjectProperties(objectClass, props);
        oObject_p.setProperties(props);
    }

    @Override
    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        if (null == oObject_p) {
            return false;
        }
        if (!this.m_OpenFolderNode.getSafeBooleanAttributeValue(NODE_ATTRIBUTE_CONTAINS_DOCUMENTS, false)) {
            return false;
        }
        OwObjectClass objectClass = oObject_p.getObjectClass();
        OwSearchNode specialNode = this.getSearchTemplate().getSearch(false).findSearchNode(2);
        if (null != specialNode) {
            boolean classInSearchTemplate = false;
            Object[] classes = this.findSearchTemplateClassesList(specialNode);
            if (null != classes) {
                for (int i = 0; i < classes.length; ++i) {
                    OwClass classinfo = (OwClass)classes[i];
                    if (!this.compatibleObjectClasses(classinfo, objectClass)) continue;
                    classInSearchTemplate = true;
                }
                if (!classInSearchTemplate) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
        this.add(oObject_p);
        oldParent_p.removeReference(oObject_p);
    }

    @Override
    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return this.canAdd(oObject_p, iContext_p);
    }

    @Override
    public OwSearchTemplate getSearchTemplate() throws Exception {
        if (this.m_SearchTemplate == null) {
            Node searchNode = this.m_OpenFolderNode.getSubNode(SEARCH_NODE_TAG_NAME);
            if (searchNode != null) {
                String strResourceName = null;
                if (null != this.getResource()) {
                    strResourceName = this.getResource().getID();
                }
                this.m_SearchTemplate = new OwSearchTemplateWrapper(this.createSearchTemplate(searchNode, strResourceName));
            } else {
                OwStandardVirtualFolderObjectFactory parent = this.getParent();
                if (parent != null) {
                    this.m_SearchTemplate = parent.getSearchTemplate();
                }
            }
        }
        return this.m_SearchTemplate;
    }

    protected OwSearchTemplate createSearchTemplate(Node searchNode_p, String sResourceName_p) throws Exception {
        OwStandardSearchTemplate searchTemplate = new OwStandardSearchTemplate(this.m_context, searchNode_p, "VirtualFolder", sResourceName_p);
        searchTemplate.init(this.m_repository);
        return searchTemplate;
    }

    private String getColumnHeaderId() throws Exception {
        Node searchNode;
        String headerId = this.m_virtualFolderName;
        OwStandardVirtualFolderObjectFactory parent = this.getParent();
        if (parent != null) {
            headerId = parent.getColumnHeaderId();
        }
        if ((searchNode = this.m_OpenFolderNode.getSubNode(SEARCH_NODE_TAG_NAME)) != null) {
            headerId = headerId + "." + this.nameFromNode(this.m_OpenFolderNode);
        }
        return headerId;
    }

    @Override
    public Collection getColumnInfoList() throws Exception {
        Collection templateInfoList = this.getSearchTemplate().getColumnInfoList();
        if (this.m_virtualFolderName == null) {
            return templateInfoList;
        }
        String headerId = this.getColumnHeaderId();
        LinkedList<OwHeaderFieldColumnInfoDecorator> headerInfos = new LinkedList<OwHeaderFieldColumnInfoDecorator>();
        for (OwFieldColumnInfo templateInfo : templateInfoList) {
            headerInfos.add(new OwHeaderFieldColumnInfoDecorator(templateInfo, headerId));
        }
        return headerInfos;
    }

    @Override
    public int getPageCount() throws Exception {
        return 1;
    }

    @Override
    public OwResource getResource() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getClonedPermissions() throws Exception {
        throw new OwNotSupportedException("OwStandardVirtualFolderObjectFactory.getClonedPermissions: Not implemented.");
    }

    @Override
    public boolean canGetPermissions() throws Exception {
        return false;
    }

    @Override
    public boolean canSetPermissions() throws Exception {
        return false;
    }

    @Override
    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
        throw new OwNotSupportedException("OwStandardVirtualFolderObjectFactory.setPermissions: Not implemented.");
    }

    @Override
    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    @Override
    public OwContentCollection getContentCollection() throws Exception {
        return null;
    }

    @Override
    public void refreshProperties() throws Exception {
    }

    @Override
    public void refreshProperties(Collection props_p) throws Exception {
        this.refreshProperties();
    }

    @Override
    public Object getNativeObject() throws Exception {
        throw new OwObjectNotFoundException("OwStandardVirtualFolderObjectFactory.getNativeObject: Not implemented or Not supported.");
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return this.getProperty(strFieldClassName_p);
    }

    @Override
    public Object getFieldProviderSource() {
        return this;
    }

    @Override
    public int getFieldProviderType() {
        return 1;
    }

    @Override
    public boolean hasContent(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        switch (iObjectTypes_p[0]) {
            case 8192: 
            case 8193: {
                return this.getFolderChilds().size() > 0;
            }
        }
        throw new OwStatusContextException("");
    }

    @Override
    public String getPath() throws Exception {
        return this.m_objectPath;
    }

    @Override
    public OwVirtualFolderObject getInstance(String strDmsIDPart_p) throws Exception {
        this.validateSearchTemplate();
        return this;
    }

    @Override
    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        throw new OwStatusContextException("");
    }

    @Override
    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
        throw new OwInvalidOperationException("OwStandardVirtualFolderObjectFactory.changeClass: Not implemented.");
    }

    @Override
    public boolean canChangeClass() throws Exception {
        return false;
    }

    @Override
    public String getFieldProviderName() {
        return this.getName();
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        this.getProperty(sName_p).setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            return this.getProperty(sName_p).getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public OwObject getInstance() throws Exception {
        return this;
    }

    @Override
    public String getResourceID() throws Exception {
        try {
            return this.getResource().getID();
        }
        catch (NullPointerException e) {
            throw new OwObjectNotFoundException("OwStandardVirtualFolderObjectFactory.getResourceID: Resource Id not found for DMSID = " + this.getDMSID(), (Throwable)e);
        }
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }

    @Override
    public Collection getFields() throws Exception {
        return this.getProperties(null).values();
    }

    @Override
    public Map getPropagationMap() {
        return this.propagationMap;
    }

    @Override
    public void setPropagationMap(Map propagationMap) {
        this.propagationMap = propagationMap;
    }

    @Override
    public String getVirtualFolderName() {
        return this.m_virtualFolderName;
    }

    protected void checkResetState() throws Exception {
        OwSearchTemplate parentSearch;
        OwSearchTemplateWrapper wrapedSearchTemplate;
        if (this.getParent() != null && this.getSearchTemplate() instanceof OwSearchTemplateWrapper && (wrapedSearchTemplate = (OwSearchTemplateWrapper)this.getSearchTemplate()).isReseted() && (parentSearch = this.findParentSearch(this.getParent())) != null) {
            OwSearchNode parentNode = parentSearch.getSearch(false);
            parentNode = this.getParent().getRefinedSearch(parentNode, this.getParent().getRefineCriteriaList());
            this.deepCriteriaValuePropagation(wrapedSearchTemplate.getSearch(false), parentNode);
            wrapedSearchTemplate.setReseted(false);
        }
    }

    protected OwSearchTemplate findParentSearch(OwStandardVirtualFolderObjectFactory parent) throws Exception {
        if (parent != null) {
            if (parent.getSearchTemplate() == this.getSearchTemplate()) {
                return this.findParentSearch(parent.getParent());
            }
            return parent.getSearchTemplate();
        }
        return null;
    }

    protected static class OwSearchTemplateWrapper
    implements OwSearchTemplate {
        private OwSearchTemplate template;
        private boolean reseted;

        public OwSearchTemplateWrapper(OwSearchTemplate template) {
            this.template = template;
        }

        @Override
        public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
            return this.template.getField(strFieldClassName_p);
        }

        @Override
        public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
            this.template.setField(sName_p, value_p);
        }

        @Override
        public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
            return this.template.getSafeFieldValue(sName_p, defaultvalue_p);
        }

        @Override
        public Collection getFields() throws Exception {
            return this.template.getFields();
        }

        @Override
        public int getFieldProviderType() {
            return this.template.getFieldProviderType();
        }

        @Override
        public Object getFieldProviderSource() {
            return this.template.getFieldProviderSource();
        }

        @Override
        public String getFieldProviderName() {
            return this.template.getFieldProviderName();
        }

        @Override
        public void init(OwFieldDefinitionProvider fieldDefinitionProvider_p) throws Exception {
            this.template.init(fieldDefinitionProvider_p);
        }

        @Override
        public Collection getColumnInfoList() throws Exception {
            return this.template.getColumnInfoList();
        }

        @Override
        public OwSearchNode getSearch(boolean fRefresh_p) throws Exception {
            if (fRefresh_p) {
                this.setReseted(fRefresh_p);
            }
            return this.template.getSearch(fRefresh_p);
        }

        @Override
        public String getHtmlLayout() {
            return this.template.getHtmlLayout();
        }

        @Override
        public boolean hasHtmlLayout() {
            return this.template.hasHtmlLayout();
        }

        @Override
        public String getJspLayoutPage() {
            return this.template.getJspLayoutPage();
        }

        @Override
        public boolean hasJspLayoutPage() {
            return this.template.hasJspLayoutPage();
        }

        @Override
        public String getIcon() {
            return this.template.getIcon();
        }

        @Override
        public String getName() {
            return this.template.getName();
        }

        @Override
        public String getDisplayName(Locale locale_p) {
            return this.template.getDisplayName(locale_p);
        }

        @Override
        public int getVersionSelection() {
            return this.template.getVersionSelection();
        }

        @Override
        public OwSort getSort(int iMinSortCriteria_p) {
            return this.template.getSort(iMinSortCriteria_p);
        }

        @Override
        public OwPriorityRule getPriorityRule() {
            return this.template.getPriorityRule();
        }

        @Override
        public boolean isInitalized() {
            return this.template.isInitalized();
        }

        @Override
        public int getDefaultMaxSize() {
            return this.template.getDefaultMaxSize();
        }

        @Override
        public boolean canSaveSearch() {
            return this.template.canSaveSearch();
        }

        @Override
        public boolean canDeleteSearch() {
            return this.template.canDeleteSearch();
        }

        @Override
        public boolean canUpdateSearch() {
            return this.template.canUpdateSearch();
        }

        @Override
        public void deleteSavedSearch(String name_p) throws Exception {
            this.template.deleteSavedSearch(name_p);
        }

        @Override
        public Collection getSavedSearches() throws Exception {
            return this.template.getSavedSearches();
        }

        @Override
        public void setSavedSearch(String name_p) throws Exception {
            this.template.setSavedSearch(name_p);
        }

        @Override
        public String getSavedSearch() throws Exception {
            return this.template.getSavedSearch();
        }

        @Override
        public void saveSearch(String name_p) throws Exception {
            this.template.saveSearch(name_p);
        }

        public boolean isReseted() {
            return this.reseted;
        }

        public void setReseted(boolean rested) {
            this.reseted = rested;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            return this.template.equals(obj);
        }

        public OwSearchTemplate getTemplate() {
            return this.template;
        }
    }

    protected static class OwVirtualFolderRefineCriteria {
        public String m_strCriteria;
        public Node m_literalNode;

        public OwVirtualFolderRefineCriteria(String strCriteria_p, Node node_p) {
            this.m_strCriteria = strCriteria_p;
            this.m_literalNode = node_p;
        }

        public boolean equals(Object obj_p) {
            if (obj_p == null) {
                return false;
            }
            if (obj_p instanceof OwVirtualFolderRefineCriteria) {
                OwVirtualFolderRefineCriteria secondObj = (OwVirtualFolderRefineCriteria)obj_p;
                return this.m_strCriteria.equals(secondObj.m_strCriteria);
            }
            if (obj_p instanceof OwSearchCriteria) {
                OwSearchCriteria criteria = (OwSearchCriteria)obj_p;
                return this.m_strCriteria.equals(criteria.getClassName());
            }
            return false;
        }

        public int hashCode() {
            return this.m_strCriteria.hashCode();
        }
    }

    public static class OwVirtualFolderObjectClass
    implements OwObjectClass {
        protected HashMap m_PropertyClassesMap = new HashMap();

        public OwVirtualFolderObjectClass() {
            this.m_PropertyClassesMap.put(OwResource.m_ObjectNamePropertyClass.getClassName(), OwResource.m_ObjectNamePropertyClass);
        }

        @Override
        public int getType() {
            return 8207;
        }

        @Override
        public List getChilds(OwNetwork network_p, boolean fExcludeHidden_p) throws Exception {
            return null;
        }

        @Override
        public List getModes(int operation_p) throws Exception {
            return null;
        }

        @Override
        public boolean hasChilds(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p, int context_p) {
            return false;
        }

        @Override
        public Map getChildNames(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p) {
            return null;
        }

        @Override
        public String getClassName() {
            return "OwVirtualFolder";
        }

        public String getID() {
            return this.getClassName();
        }

        @Override
        public String getDisplayName(Locale locale_p) {
            return this.getClassName();
        }

        @Override
        public OwPropertyClass getPropertyClass(String strClassName_p) throws Exception {
            OwPropertyClass propertyClassDescription = (OwPropertyClass)this.m_PropertyClassesMap.get(strClassName_p);
            if (null == propertyClassDescription) {
                throw new OwObjectNotFoundException("OwStandardVirtualFolderObjectFactory$OwVirtualFolderObjectClass.getPropertyClass: Cannot find the class for property = " + strClassName_p);
            }
            return propertyClassDescription;
        }

        @Override
        public Collection getPropertyClassNames() throws Exception {
            return this.m_PropertyClassesMap.keySet();
        }

        @Override
        public String getNamePropertyName() throws Exception {
            return OwResource.m_ObjectNamePropertyClass.getClassName();
        }

        @Override
        public boolean canCreateNewObject() throws Exception {
            return false;
        }

        @Override
        public boolean hasVersionSeries() throws Exception {
            return false;
        }

        @Override
        public String getDescription(Locale locale_p) {
            return OwString.localize(locale_p, "ecm.OwVirtualFolderObject.description", "Standard class for virtual folders / eFiles.");
        }

        @Override
        public boolean isHidden() throws Exception {
            return true;
        }

        @Override
        public OwObjectClass getParent() throws Exception {
            return null;
        }
    }
}

