/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm.eaop;

import com.wewebu.ow.server.ecm.eaop.OwReflectiveCollector;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.lang.reflect.Method;

public abstract class OwPeerMethodCollector
extends OwReflectiveCollector {
    @Override
    protected final Method findCollectMethod(Method method_p) throws OwException {
        Class<?> thisClass = this.getClass();
        try {
            Method collectMethod = thisClass.getMethod(method_p.getName(), method_p.getReturnType());
            if (!collectMethod.getReturnType().equals(Void.TYPE)) {
                throw new OwInvalidOperationException("Invalid collect method " + collectMethod + ". void return type expexted.");
            }
            return collectMethod;
        }
        catch (SecurityException e) {
            throw new OwInvalidOperationException("Security exception while collecting result.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new OwInvalidOperationException("No reflective collection method for " + method_p.toString() + " in " + thisClass, (Throwable)e);
        }
    }
}

