/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl;

import com.wewebu.ow.server.ao.OwAOConfigurableProvider;
import com.wewebu.ow.server.ao.OwAOContext;
import com.wewebu.ow.server.ao.OwAOProvider;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwRoleManagedAOType;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecmimpl.OwAOTypesEnum;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.LinkedList;
import java.util.List;

public class OwBackwardsCompatibilityAOProvider
implements OwAOConfigurableProvider {
    private OwAOProvider safeProvider;
    private OwRoleManager roleManager;
    private OwNetwork<?> network;

    public OwBackwardsCompatibilityAOProvider() {
    }

    public OwBackwardsCompatibilityAOProvider(OwNetwork adaptor, OwRoleManager roleManager) throws OwException {
        this.network = adaptor;
        this.roleManager = roleManager;
    }

    @Override
    public <T> List<T> getApplicationObjects(OwAOType<T> type, String name, boolean forceSpecificObj) throws OwException {
        List<T> col = null;
        try {
            col = this.getSafeProvider().getApplicationObjects(type, this.getDefaultLocation(type, name, null), forceSpecificObj);
            if (type instanceof OwRoleManagedAOType) {
                LinkedList<T> allowedCollection = new LinkedList<T>();
                OwRoleManagedAOType roleManagedType = (OwRoleManagedAOType)type;
                for (Object object : col) {
                    if (this.roleManager != null && !roleManagedType.isAllowed(object, this.roleManager)) continue;
                    allowedCollection.add(object);
                }
                col = allowedCollection;
            }
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        return new LinkedList<T>(col);
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> type, String name, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        Object answer = null;
        try {
            answer = this.getSafeProvider().getApplicationObject(type, name, forceSpecificObj, createNonExisting);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        Object tAnswer = answer;
        if (type instanceof OwRoleManagedAOType) {
            OwRoleManagedAOType roleManagedType = (OwRoleManagedAOType)type;
            if (this.roleManager != null && !roleManagedType.isAllowed(tAnswer, this.roleManager)) {
                throw new OwAccessDeniedException(new OwString1("app.OwAOProvider.acces.denied", "Access to the application object %1 was denied", name));
            }
        }
        return tAnswer;
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> aoType, String name, List<Object> params, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        T answer = null;
        try {
            answer = this.getSafeProvider().getApplicationObject(aoType, name, params, forceSpecificObj, createNonExisting);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        return answer;
    }

    protected String getDefaultLocation(OwAOType<?> aoType, String name, List<Object> params) {
        String location = name;
        if (name == null) {
            int theType = aoType.getType();
            location = theType == OwAOTypesEnum.SEARCHTEMPLATE.type ? "owsearchtemplates" : (theType == OwAOTypesEnum.VIRTUAL_FOLDER.type ? "other" : name);
        }
        return location;
    }

    private synchronized OwAOProvider getSafeProvider() throws OwConfigurationException {
        if (this.safeProvider == null) {
            try {
                this.safeProvider = ((OwLegacyAONetwork)((Object)this.network)).getSafeAOProvider();
            }
            catch (Exception e) {
                throw new OwConfigurationException("Invalid AO configuration.", (Throwable)e);
            }
        }
        return this.safeProvider;
    }

    @Override
    public void init(OwXMLUtil configuration, OwAOContext context) throws OwConfigurationException {
        this.network = context.getNetwork();
        this.roleManager = context.isRoleManaged() ? context.getNetwork().getRoleManager() : null;
    }

    public static interface OwLegacyAONetwork {
        public OwAOProvider getSafeAOProvider() throws OwException;
    }
}

