/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwString;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class OwSearchSQLOperator {
    private static final Logger LOG = OwLogCore.getLogger(OwSearchSQLOperator.class);
    public static final int DATE_MODE_FNIM = 1;
    public static final int DATE_MODE_MS_ACCESS = 2;
    public static final int DATE_MODE_FNCM = 3;
    public static final int DATE_MODE_ORACLE = 4;
    public static final int DATE_MODE_MSSQL = 5;
    public static final int DATE_MODE_DB2 = 6;
    public static final int DATE_MODE_DEFAULT = 7;
    public static final int DATE_MODE_TREAT_IGNORE_TIME_AS_RANGE = 256;
    private DateFormat m_DateAndTimeFormat;
    private DateFormat m_DateFormat;
    protected int m_iMode;
    protected static final SqlOperatorSingleton m_SqlOperators = new SqlOperatorSingleton();

    protected static int getDateMode(int iMode_p) {
        return iMode_p & 0xF;
    }

    public OwSearchSQLOperator(int iMode_p) {
        this.m_iMode = iMode_p;
        switch (OwSearchSQLOperator.getDateMode(iMode_p)) {
            case 2: {
                this.m_DateFormat = new SimpleDateFormat("yyyy.MM.dd");
                this.m_DateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 3: {
                this.m_DateFormat = new SQLDateFormat("yyyy-MM-dd'Q'");
                this.m_DateAndTimeFormat = new SQLDateFormat("yyyy-MM-dd'T'HH:mm:ss'Q'");
                break;
            }
            case 5: {
                this.m_DateFormat = new SimpleDateFormat("yyyy.MM.dd");
                this.m_DateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 4: {
                this.m_DateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.m_DateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 6: {
                this.m_DateFormat = new SimpleDateFormat("yyyy.MM.dd");
                this.m_DateAndTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                break;
            }
            default: {
                this.m_DateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.m_DateAndTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
        }
    }

    public void setDateFormats(DateFormat dateAndTimeFormat_p, DateFormat dateFormat_p) {
        this.m_DateAndTimeFormat = dateAndTimeFormat_p;
        this.m_DateFormat = dateFormat_p;
    }

    public boolean createSQLSearchCriteria(OwSearchNode searchNode_p, Writer w_p) throws Exception {
        if (searchNode_p == null) {
            return false;
        }
        List CriteriaList = searchNode_p.getChilds();
        if (CriteriaList != null) {
            boolean fValidSub = false;
            boolean fWroteBracked = false;
            for (int i = 0; i < CriteriaList.size(); ++i) {
                StringWriter subWriter;
                OwSearchNode Search = (OwSearchNode)CriteriaList.get(i);
                OwSearchCriteria criteria = Search.getCriteria();
                if (criteria != null && "OwSearchPath".equals(criteria.getClassName()) || !this.createSQLSearchCriteria(Search, subWriter = new StringWriter())) continue;
                if (CriteriaList.size() > 1 && i == 0 && searchNode_p.getOperator() != 0) {
                    w_p.write(" (");
                    fWroteBracked = true;
                }
                if (fValidSub) {
                    switch (searchNode_p.getOperator()) {
                        case 1: {
                            w_p.write("and ");
                            break;
                        }
                        case 2: {
                            w_p.write("or ");
                        }
                    }
                }
                w_p.write(subWriter.toString());
                fValidSub = true;
            }
            if (fWroteBracked) {
                w_p.write(") ");
            }
            return fValidSub;
        }
        OwSearchCriteria criteria_p = searchNode_p.getCriteria();
        int operator = criteria_p.getOperator();
        if (operator == 0) {
            return false;
        }
        String strOpSQL = this.getOperatorSQL(criteria_p, criteria_p.getValue(), this.isOperatorFieldFirst(operator));
        if (strOpSQL == null) {
            return false;
        }
        w_p.write(strOpSQL);
        return true;
    }

    protected boolean isOperatorFieldFirst(int iOP_p) {
        switch (iOP_p) {
            case 276: 
            case 277: {
                return false;
            }
        }
        return true;
    }

    protected String getOperatorSQL(OwSearchCriteria criteria_p, Object value_p, boolean fFieldFirst_p) throws Exception {
        if (criteria_p == null) {
            return null;
        }
        switch (criteria_p.getOperator()) {
            case 16: 
            case 17: {
                StringBuffer buf = new StringBuffer();
                buf.append(this.getCriteriaQueryName(criteria_p));
                buf.append(" ");
                buf.append(this.getSQLOperatorAsString(criteria_p.getOperator()));
                buf.append(" ");
                return buf.toString();
            }
        }
        if (criteria_p.isArray() && value_p instanceof Object[]) {
            return this.getArrayOperatorSQL(criteria_p, value_p, fFieldFirst_p);
        }
        if (criteria_p.isDateType()) {
            return this.getDateOperatorSQL(criteria_p, value_p, fFieldFirst_p);
        }
        if (criteria_p.isCriteriaOperatorRange()) {
            return this.getRangeOperatorSQL(criteria_p, value_p, criteria_p.getSecondRangeCriteria().getValue(), fFieldFirst_p);
        }
        if (value_p == null || value_p.toString().length() == 0) {
            return null;
        }
        switch (criteria_p.getOperator()) {
            case 274: 
            case 275: {
                StringTokenizer inTokens = new StringTokenizer(value_p.toString(), ",");
                if (!inTokens.hasMoreTokens()) {
                    return null;
                }
                StringBuffer buf = new StringBuffer();
                buf.append(this.getCriteriaQueryName(criteria_p));
                buf.append(" ");
                buf.append(this.getSQLOperatorAsString(criteria_p.getOperator()));
                buf.append(" (");
                while (inTokens.hasMoreTokens()) {
                    buf.append(this.getSQLValueString(criteria_p, inTokens.nextToken(), this.m_iMode));
                    if (!inTokens.hasMoreTokens()) continue;
                    buf.append(",");
                }
                buf.append(")");
                return buf.toString();
            }
            case 7: {
                StringBuffer buf = new StringBuffer();
                buf.append("not");
                buf.append(" (");
                buf.append(this.getSingleOperatorSQL(criteria_p, value_p, 6, fFieldFirst_p));
                buf.append(") ");
                return buf.toString();
            }
        }
        return this.getSingleOperatorSQL(criteria_p, value_p, criteria_p.getOperator(), fFieldFirst_p);
    }

    private String getDateOperatorSQL(OwSearchCriteria criteria_p, Object value_p, boolean fFieldFirst_p) throws Exception {
        boolean ignoreTime;
        if (criteria_p == null) {
            return null;
        }
        if (!criteria_p.isType(Date.class)) {
            String msg = "OwSearchSQLOperator.getDateOperatorSQL: SearchCriteria isn't type 'Date'.";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        int iOperator_p = criteria_p.getOperator();
        boolean bl = ignoreTime = criteria_p.isIgnoreTime() && this.hasMode(256);
        if (criteria_p.isCriteriaOperatorRange()) {
            if (ignoreTime) {
                Date fromDate = value_p != null ? OwDateTimeUtil.setBeginOfDayTime((Date)value_p) : null;
                Date toDate = criteria_p.getSecondRangeCriteria().getValue() != null ? OwDateTimeUtil.setBeginOfNextDayTime((Date)criteria_p.getSecondRangeCriteria().getValue()) : null;
                return this.getRangeOperatorSQL(criteria_p, fromDate, toDate, fFieldFirst_p);
            }
            return this.getRangeOperatorSQL(criteria_p, value_p, criteria_p.getSecondRangeCriteria().getValue(), fFieldFirst_p);
        }
        if (value_p == null) {
            return null;
        }
        switch (iOperator_p) {
            case 6: 
            case 7: {
                String msg = "OwSearchSQLOperator.getDateOperatorSQL: Invalid search operator for date: " + this.getSQLOperatorAsString(iOperator_p);
                LOG.error((Object)msg);
                throw new OwInvalidOperationException(msg);
            }
        }
        if (ignoreTime) {
            switch (iOperator_p) {
                case 4: {
                    Date beginOfDayTime = OwDateTimeUtil.setBeginOfDayTime((Date)value_p);
                    Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime((Date)value_p);
                    String sFrom = this.getSingleOperatorSQL(criteria_p, beginOfDayTime, 12, fFieldFirst_p);
                    String sTo = this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 10, fFieldFirst_p);
                    return " (" + sFrom + " and " + sTo + ") ";
                }
                case 5: {
                    Date beginOfDayTime = OwDateTimeUtil.setBeginOfDayTime((Date)value_p);
                    Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime((Date)value_p);
                    String sLess = this.getSingleOperatorSQL(criteria_p, beginOfDayTime, 10, fFieldFirst_p);
                    String sGreaterEq = this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 12, fFieldFirst_p);
                    return " (" + sLess + " or " + sGreaterEq + ") ";
                }
                case 8: {
                    Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime((Date)value_p);
                    return this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 12, fFieldFirst_p);
                }
                case 14: {
                    Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime((Date)value_p);
                    return this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 10, fFieldFirst_p);
                }
                case 274: {
                    StringTokenizer inTokens = new StringTokenizer(value_p.toString(), ",");
                    if (!inTokens.hasMoreTokens()) {
                        return null;
                    }
                    DateFormat format = this.m_DateFormat;
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.getCriteriaQueryName(criteria_p));
                    buf.append(" ");
                    buf.append(this.getSQLOperatorAsString(criteria_p.getOperator()));
                    while (inTokens.hasMoreTokens()) {
                        Date tokenDate = format.parse(inTokens.nextToken());
                        Date beginOfDayTime = OwDateTimeUtil.setBeginOfDayTime(tokenDate);
                        Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime(tokenDate);
                        String sFrom = this.getSingleOperatorSQL(criteria_p, beginOfDayTime, 12, fFieldFirst_p);
                        String sTo = this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 10, fFieldFirst_p);
                        buf.append(" (" + sFrom + " and " + sTo + ") ");
                        if (!inTokens.hasMoreTokens()) continue;
                        buf.append("or");
                    }
                    return buf.toString();
                }
                case 275: {
                    StringTokenizer inTokens = new StringTokenizer(value_p.toString(), ",");
                    if (!inTokens.hasMoreTokens()) {
                        return null;
                    }
                    DateFormat format = this.m_DateFormat;
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.getCriteriaQueryName(criteria_p));
                    buf.append(" ");
                    buf.append(this.getSQLOperatorAsString(criteria_p.getOperator()));
                    while (inTokens.hasMoreTokens()) {
                        Date tokenDate = format.parse(inTokens.nextToken());
                        Date beginOfDayTime = OwDateTimeUtil.setBeginOfDayTime(tokenDate);
                        Date beginOfNextDayTime = OwDateTimeUtil.setBeginOfNextDayTime(tokenDate);
                        String sLess = this.getSingleOperatorSQL(criteria_p, beginOfDayTime, 10, fFieldFirst_p);
                        String sGreaterEq = this.getSingleOperatorSQL(criteria_p, beginOfNextDayTime, 12, fFieldFirst_p);
                        buf.append(" (" + sLess + " or " + sGreaterEq + ") ");
                        if (!inTokens.hasMoreTokens()) continue;
                        buf.append("or");
                    }
                    return buf.toString();
                }
            }
            Date beginOfDayTime = OwDateTimeUtil.setBeginOfDayTime((Date)value_p);
            return this.getSingleOperatorSQL(criteria_p, beginOfDayTime, iOperator_p, fFieldFirst_p);
        }
        if (iOperator_p == 274 || iOperator_p == 275) {
            StringTokenizer inTokens = new StringTokenizer(value_p.toString(), ",");
            if (!inTokens.hasMoreTokens()) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(this.getCriteriaQueryName(criteria_p));
            buf.append(" ");
            buf.append(this.getSQLOperatorAsString(criteria_p.getOperator()));
            buf.append(" (");
            while (inTokens.hasMoreTokens()) {
                buf.append(this.getSQLValueString(criteria_p, inTokens.nextToken(), this.m_iMode));
                if (!inTokens.hasMoreTokens()) continue;
                buf.append(",");
            }
            buf.append(")");
            return buf.toString();
        }
        return this.getSingleOperatorSQL(criteria_p, value_p, iOperator_p, fFieldFirst_p);
    }

    private String getRangeOperatorSQL(OwSearchCriteria criteria_p, Object firstvalue_p, Object secondvalue_p, boolean fFieldFirst_p) throws Exception {
        if (criteria_p == null) {
            return null;
        }
        if (!criteria_p.isCriteriaOperatorRange()) {
            String msg = "OwSearchSQLOperator.getRangeOperatorSQL: SearchCriteria operator isn't a range operator.";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        if (firstvalue_p == null && secondvalue_p == null) {
            return null;
        }
        int iOperator_p = criteria_p.getOperator();
        switch (iOperator_p) {
            case 530: {
                String sFrom = this.getSingleOperatorSQL(criteria_p, firstvalue_p, 12, fFieldFirst_p);
                String sTo = this.getSingleOperatorSQL(criteria_p, secondvalue_p, 10, fFieldFirst_p);
                if (sFrom == null) {
                    return sTo;
                }
                if (sTo == null) {
                    return sFrom;
                }
                return " (" + sFrom + " and " + sTo + ") ";
            }
            case 531: {
                String sFrom = this.getSingleOperatorSQL(criteria_p, firstvalue_p, 10, fFieldFirst_p);
                String sTo = this.getSingleOperatorSQL(criteria_p, secondvalue_p, 12, fFieldFirst_p);
                if (sFrom == null) {
                    return sTo;
                }
                if (sTo == null) {
                    return sFrom;
                }
                return " (" + sFrom + " or " + sTo + ") ";
            }
        }
        String msg = "OwSearchSQLOperator.getRangeOperatorSQL: Invalid range operator: " + criteria_p.getOperator();
        LOG.error((Object)msg);
        throw new OwInvalidOperationException(msg);
    }

    private String getArrayOperatorSQL(OwSearchCriteria criteria_p, Object value_p, boolean fFieldFirst_p) throws Exception {
        if (criteria_p == null || value_p == null) {
            return null;
        }
        if (!criteria_p.isArray()) {
            String msg = "OwSearchSQLOperator.getArrayOperatorSQL: SearchCriteria operator isn't an array.";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        if (!(value_p instanceof Object[])) {
            String msg = "OwSearchSQLOperator.getArrayOperatorSQL: SearchCriteria operator is not instanceof Object[].";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        StringBuffer buf = new StringBuffer();
        Object[] values = (Object[])value_p;
        boolean fWroteOne = false;
        for (int i = 0; i < values.length; ++i) {
            String strOpSWL = this.getOperatorSQL(criteria_p, values[i], fFieldFirst_p);
            if (strOpSWL == null) continue;
            if (fWroteOne) {
                if (OwSearchOperator.isCriteriaOperatorNot(criteria_p.getOperator())) {
                    buf.append(" and ");
                } else {
                    buf.append(" or ");
                }
            }
            buf.append(strOpSWL);
            fWroteOne = true;
        }
        if (fWroteOne) {
            return buf.toString();
        }
        return null;
    }

    private boolean hasMode(int mode_p) {
        return (this.m_iMode & mode_p) > 0;
    }

    protected String getSingleOperatorSQL(OwSearchCriteria criteria_p, Object value_p, int iOperator_p, boolean fFieldFirst_p) throws Exception {
        if (value_p == null || value_p.toString().length() == 0) {
            return null;
        }
        String strValueString = this.getSQLValueString(criteria_p, value_p, this.m_iMode);
        StringBuffer buf = new StringBuffer();
        if (fFieldFirst_p) {
            buf.append(this.getCriteriaQueryName(criteria_p));
            buf.append(" ");
            buf.append(this.getSQLOperatorAsString(iOperator_p));
            buf.append(" ");
            buf.append(strValueString);
            buf.append(" ");
        } else {
            buf.append(strValueString);
            buf.append(" ");
            buf.append(this.getSQLOperatorAsString(iOperator_p));
            buf.append(" ");
            buf.append(this.getCriteriaQueryName(criteria_p));
            buf.append(" ");
        }
        return buf.toString();
    }

    protected String getSQLValueString(OwSearchCriteria criteria_p, Object value_p, int iDateMode_p) throws Exception {
        StringBuffer ret = new StringBuffer();
        try {
            Date dateValue = (Date)value_p;
            DateFormat format = this.m_DateAndTimeFormat;
            if (criteria_p.isIgnoreTime()) {
                format = this.m_DateFormat;
            }
            switch (OwSearchSQLOperator.getDateMode(iDateMode_p)) {
                case 1: {
                    ret.append(String.valueOf(((Date)value_p).getTime() / 86400000L + 1L));
                    break;
                }
                case 2: {
                    ret.append(" datevalue('");
                    ret.append(format.format(dateValue));
                    ret.append("') ");
                    break;
                }
                case 5: {
                    if (criteria_p.isIgnoreTime()) {
                        ret.append(" CONVERT(datetime,'");
                        ret.append(format.format(dateValue));
                        ret.append("',102) ");
                        break;
                    }
                    ret.append(" CONVERT(datetime,'");
                    ret.append(format.format(dateValue));
                    ret.append("',120) ");
                    break;
                }
                case 4: {
                    ret.append(" to_date('");
                    ret.append(format.format(dateValue));
                    ret.append("','yyyy-MM-dd HH24:MI:SS')");
                    break;
                }
                case 6: {
                    ret.append(" TIMESTAMP_FORMAT('");
                    ret.append(format.format(dateValue));
                    ret.append("','dd.MM.yyyy HH:mm:ss')");
                    break;
                }
                default: {
                    ret.append(format.format(dateValue));
                }
            }
            return ret.toString();
        }
        catch (ClassCastException cce) {
            if (this.isStringLiteral(criteria_p)) {
                ret.append("'");
                ret.append(this.getStringValue(criteria_p, this.convertWildCards(criteria_p, value_p.toString())));
                ret.append("'");
            } else {
                ret.append(this.convertWildCards(criteria_p, value_p.toString()));
            }
            return ret.toString();
        }
    }

    protected boolean isStringLiteral(OwSearchCriteria criteria_p) throws Exception {
        return criteria_p.getOriginalJavaClassName().equals("java.lang.String");
    }

    protected String getStringValue(OwSearchCriteria criteria_p, String value_p) {
        value_p = OwString.replaceAll(value_p, "'", "\\'");
        return value_p;
    }

    protected String convertWildCards(OwSearchCriteria criteria_p, String value_p) {
        Collection wdefs = criteria_p.getWildCardDefinitions();
        if (null == wdefs) {
            return value_p;
        }
        for (OwWildCardDefinition def : wdefs) {
            value_p = OwString.replaceAll(value_p, def.getWildCard(), def.getNativeWildCard());
        }
        return value_p;
    }

    protected String getSQLOperatorAsString(int operator_p) {
        return OwSearchSQLOperator.m_SqlOperators.m_OperatorMap.get(operator_p).toString();
    }

    protected String getCriteriaQueryName(OwSearchCriteria criteria_p) throws OwException {
        try {
            return criteria_p.getFieldDefinition().getClassName();
        }
        catch (Exception e) {
            LOG.debug((Object)"OwSearchSQLOperator.getCriteriaQueryName:Cannot retrieve field definition class name", (Throwable)e);
            throw new OwServerException(e.getMessage(), (Throwable)e);
        }
    }

    protected static class SqlOperatorSingleton {
        public Map m_OperatorMap = null;

        private SqlOperatorSingleton() {
            if (this.m_OperatorMap == null) {
                this.m_OperatorMap = new HashMap();
                this.m_OperatorMap.put(4, "=");
                this.m_OperatorMap.put(5, "<>");
                this.m_OperatorMap.put(6, "like");
                this.m_OperatorMap.put(7, "not like");
                this.m_OperatorMap.put(8, ">");
                this.m_OperatorMap.put(10, "<");
                this.m_OperatorMap.put(12, ">=");
                this.m_OperatorMap.put(14, "<=");
                this.m_OperatorMap.put(274, "in");
                this.m_OperatorMap.put(275, "not in");
                this.m_OperatorMap.put(276, "in");
                this.m_OperatorMap.put(277, "not in");
                this.m_OperatorMap.put(16, "is null");
                this.m_OperatorMap.put(17, "is not null");
            }
        }
    }

    private static class SQLDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        public SQLDateFormat(String string_p) {
            super(string_p);
        }

        @Override
        public StringBuffer format(Date date_p, StringBuffer toAppendTo_p, FieldPosition fieldPosition_p) {
            StringBuffer ret = super.format(date_p, toAppendTo_p, fieldPosition_p);
            int iFind = ret.indexOf("Q");
            if (-1 != iFind) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date_p);
                int iZoneH = calendar.get(15) / 3600000;
                int iZoneM = Math.abs(calendar.get(15) / 60000 - 60 * iZoneH);
                if (calendar.getTimeZone().inDaylightTime(date_p)) {
                    int iDSTH = calendar.getTimeZone().getDSTSavings() / 3600000;
                    int iDSTM = Math.abs(calendar.getTimeZone().getDSTSavings() / 60000 - 60 * iDSTH);
                    iZoneH += iDSTH;
                    iZoneM += iDSTM;
                }
                ret = ret.replace(iFind, iFind + 1, MessageFormat.format("{0,number,+00;-00}:{1,number,00}", iZoneH, iZoneM));
            }
            return ret;
        }
    }
}

