/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class OwSort {
    protected LinkedList<OwSortCriteria> m_SortList;
    protected int m_iMax;
    protected boolean m_fDefaultAsc;

    public OwSort() {
        this(1, true);
    }

    public OwSort(int iMaxSize_p, boolean fAsc_p) {
        this.m_iMax = iMaxSize_p;
        this.m_fDefaultAsc = fAsc_p;
        this.m_SortList = new LinkedList();
    }

    public int getMaxSize() {
        return this.m_iMax;
    }

    public boolean getDefaultAsc() {
        return this.m_fDefaultAsc;
    }

    public void setMaxSize(int iMax_p) {
        if (iMax_p < 0) {
            throw new IllegalArgumentException("Provide max size is lower then 0 (zero)!");
        }
        this.m_iMax = iMax_p;
        this.reduceToMaxSize();
    }

    public int getSize() {
        return this.m_SortList.size();
    }

    public Collection<OwSortCriteria> getCriteriaCollection() {
        return this.m_SortList;
    }

    public void addCriteria(OwSortCriteria criteria_p) {
        this.m_SortList.add(criteria_p);
    }

    public void removeCriteria(String strPropertyName_p) {
        Iterator critIt = this.m_SortList.iterator();
        while (critIt.hasNext()) {
            OwSortCriteria criteria = (OwSortCriteria)critIt.next();
            if (!criteria.getPropertyName().equals(strPropertyName_p)) continue;
            critIt.remove();
            return;
        }
    }

    public OwSortCriteria getLastCriteria() {
        if (this.m_SortList.size() > 0) {
            return this.m_SortList.getLast();
        }
        return null;
    }

    public OwSortCriteria getCriteria(String strPropertyName_p) {
        for (OwSortCriteria criteria : this.m_SortList) {
            if (!criteria.getPropertyName().equals(strPropertyName_p)) continue;
            return criteria;
        }
        return null;
    }

    public void toggleCriteria(String strPropertyName_p) {
        Iterator it = this.m_SortList.iterator();
        while (it.hasNext()) {
            OwSortCriteria criteria = (OwSortCriteria)it.next();
            if (!criteria.getPropertyName().equals(strPropertyName_p)) continue;
            it.remove();
            this.m_SortList.add(criteria);
            criteria.m_fAsc = !criteria.m_fAsc;
            return;
        }
        this.m_SortList.add(new OwSortCriteria(strPropertyName_p, this.m_fDefaultAsc));
        this.reduceToMaxSize();
    }

    public int getPriority(OwSortCriteria criteria_p) {
        int priority = this.m_SortList.indexOf(criteria_p);
        return priority + 1;
    }

    public void setCriteria(String strPropertyName_p, boolean fAsc_p) {
        Iterator critIt = this.m_SortList.iterator();
        while (critIt.hasNext()) {
            OwSortCriteria criteria = (OwSortCriteria)critIt.next();
            if (!criteria.getPropertyName().equals(strPropertyName_p)) continue;
            critIt.remove();
            this.m_SortList.add(criteria);
            criteria.m_fAsc = fAsc_p;
            return;
        }
        this.m_SortList.add(new OwSortCriteria(strPropertyName_p, fAsc_p));
        this.reduceToMaxSize();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("m_fDefaultAsc = [");
        ret.append(this.m_fDefaultAsc);
        ret.append("], m_iMax = [");
        ret.append(this.m_iMax);
        ret.append("], m_SortList = [");
        ret.append(this.m_SortList);
        ret.append("]");
        return ret.toString();
    }

    public Iterator<OwSortCriteria> getPrioritizedIterator() {
        return this.m_SortList.descendingIterator();
    }

    protected void reduceToMaxSize() {
        while (this.m_SortList.size() > this.m_iMax) {
            this.m_SortList.removeFirst();
        }
    }

    public static class OwSortCriteria {
        protected String m_strPropertyName;
        protected boolean m_fAsc;

        public OwSortCriteria(String strPropertyName_p, boolean fAsc_p) {
            this.m_strPropertyName = strPropertyName_p;
            this.m_fAsc = fAsc_p;
        }

        public String getPropertyName() {
            return this.m_strPropertyName;
        }

        public boolean getAscFlag() {
            return this.m_fAsc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OwSortCriteria) {
                return ((OwSortCriteria)obj).getPropertyName().equals(this.getPropertyName());
            }
            return false;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("PropertyName = [");
            ret.append(this.m_strPropertyName);
            ret.append("], Asc = [");
            ret.append(this.m_fAsc);
            ret.append("]");
            return ret.toString();
        }
    }
}

