/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.field.OwEnum;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class OwFieldManagerControlImageInsteadOfValue
extends OwFieldManagerControl {
    private static final String IMAGE_PATH = "ImagePath";
    private static final String VALUE_STRING = "{value}";
    private static final String VALUE_PATTERN = "\\{value\\}";
    private static final int BEGIN_URL = 1;
    private static final int END_URL = 2;
    private static final int COMPLETE_PATH = 3;
    private String pathPattern;

    @Override
    public void init(OwFieldManager fieldmanager_p, Node configNode_p) throws Exception {
        super.init(fieldmanager_p, configNode_p);
        OwStandardXMLUtil config = new OwStandardXMLUtil(configNode_p);
        this.pathPattern = config.getSafeTextValue(IMAGE_PATH, null);
        if (this.pathPattern == null) {
            throw new OwConfigurationException("Invalid configuration: Missing subnode <ImagePath> for value replacement");
        }
        if (!this.pathPattern.contains(VALUE_STRING)) {
            throw new OwConfigurationException("Error in configuration: The configured <ImagePath>-Element does not contain the wildcard \"{value}\"");
        }
    }

    public String getUrl(String value_p, int urlPart) throws Exception {
        String[] split = this.pathPattern.split(VALUE_PATTERN);
        if (urlPart == 1) {
            return this.getContext().getBaseURL() + split[0];
        }
        if (urlPart == 2) {
            return split[1];
        }
        if (urlPart == 3) {
            String url = this.getContext().getBaseURL() + split[0] + value_p + split[1];
            return url;
        }
        return null;
    }

    public String insertUpdateFunction(String strID_p) throws Exception {
        StringBuffer function = new StringBuffer("\nfunction renewIcon(){\n");
        function.append("var value = this.value;");
        function.append("var beginPath = \"" + this.getUrl("", 1) + "\";\n");
        function.append("var endPath = \"" + this.getUrl("", 2) + "\";\n");
        function.append("var url = beginPath + value.toLowerCase() + endPath;\n");
        function.append("document.getElementById(\"img");
        function.append(strID_p);
        function.append("\").src = url;\n");
        function.append("document.getElementById(\"img");
        function.append(strID_p);
        function.append("\").alt = value;\n");
        function.append("}\n");
        return function.toString();
    }

    public void renderImage(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String id_p) throws Exception {
        w_p.write("<img src=\"");
        if (value_p != null && value_p.toString() != null) {
            String fieldValue = value_p.toString();
            w_p.write(this.getUrl(fieldValue.toLowerCase(), 3));
            w_p.write("\" alt=\"");
            w_p.write(fieldValue);
            w_p.write("\" title=\"");
            w_p.write(fieldValue);
            w_p.write("\"");
        } else {
            w_p.write(this.getContext().getBaseURL());
            w_p.write("/js/extjs/resources/images/default/s.gif\" alt=\"\"");
        }
        if (id_p != null) {
            w_p.write(" id=\"img");
            w_p.write(id_p);
            w_p.write("\"");
        }
        w_p.write(" />");
    }

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        this.renderImage(w_p, fieldDef_p, value_p, null);
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        this.getContext().renderJSInclude("/js/wewebucombo.js", w_p);
        w_p.write("<script type=\"text/javascript\">\n");
        w_p.write("Ext.BLANK_IMAGE_URL = \"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.getContext().getBaseURL() + "/js/extjs/resources/images/default/s.gif"));
        w_p.write("\";\n");
        w_p.write("</script>\n");
        w_p.write("<div class='OwInputControl OwInputControlAdvancedChoice'> ");
        w_p.write("<select name='");
        OwHTMLHelper.writeSecureHTML(w_p, strID_p);
        w_p.write("' id='");
        OwHTMLHelper.writeSecureHTML(w_p, strID_p);
        w_p.write("' >\n");
        Iterator it = fieldDef_p.getEnums().iterator();
        Object value = field_p.getValue();
        boolean fSelected = false;
        if (value == null || value.equals("")) {
            fSelected = true;
            w_p.write("<option value='' selected >&nbsp;</option>\n");
        }
        while (it.hasNext()) {
            OwEnum Item = (OwEnum)it.next();
            w_p.write("<option value='");
            OwHTMLHelper.writeSecureHTML(w_p, Item.getValue().toString());
            w_p.write("' ");
            if (Item.getValue().equals(value)) {
                fSelected = true;
                w_p.write("selected ");
            }
            w_p.write(">");
            OwHTMLHelper.writeSecureHTML(w_p, Item.getDisplayName(this.getFieldManager().getContext().getLocale()));
            w_p.write("</option>\n");
        }
        if (!fSelected) {
            String strValue = "";
            if (null != value) {
                strValue = value.toString();
            }
            w_p.write("<option value='");
            OwHTMLHelper.writeSecureHTML(w_p, strValue);
            w_p.write("' selected>");
            w_p.write(OwString.localize(this.getFieldManager().getContext().getLocale(), "app.OwStandardFieldManager.outofrangelist.symbol", "(!)"));
            OwHTMLHelper.writeSecureHTML(w_p, strValue);
            w_p.write("</option>");
        }
        w_p.write("</select>");
        String encId = OwHTMLHelper.encodeJavascriptString(strID_p);
        String varName = OwHTMLHelper.encodeJavascriptVariableName(encId);
        this.renderImage(w_p, fieldDef_p, field_p.getValue(), encId);
        w_p.write("</div>\n");
        if (!fSelected) {
            w_p.write("<span class='OwInstructionName'>");
            w_p.write(OwString.localize(this.getFieldManager().getContext().getLocale(), "app.OwStandardFieldManager.outofrangelist", "(!) Out of range list"));
            w_p.write("</span>");
        }
        w_p.write("<script type=\"text/javascript\">\n");
        w_p.write("Ext.onReady(function(){\n");
        w_p.write("     var converted_" + varName + " = new Ext.form.ComboBox({\n");
        w_p.write("     typeAhead: true,\n");
        w_p.write("     triggerAction: 'all',\n");
        w_p.write("     transform:'" + encId + "',\n");
        w_p.write("     grow:true,\n");
        w_p.write("     autoWidth:'auto',\n");
        w_p.write("     listWidth:'auto',\n");
        w_p.write("     selectOnFocus: true,\n");
        w_p.write("     forceSelection:true\n");
        w_p.write("});\n");
        w_p.write("converted_");
        w_p.write(varName);
        w_p.write(".el.setWidth('auto');\n");
        w_p.write("converted_");
        w_p.write(varName);
        w_p.write(".addListener('select', ");
        w_p.write(this.insertUpdateFunction(encId));
        w_p.write(");\n");
        w_p.write("converted_");
        w_p.write(varName);
        w_p.write(".autoSize();\n");
        w_p.write("});\n");
        w_p.write("</script>\n");
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String value = request_p.getParameter(strID_p);
        if (value != null && !"".equals(value)) {
            Iterator it = fieldDef_p.getEnums().iterator();
            Object val = null;
            while (it.hasNext() && !value.equals(String.valueOf(val = ((OwEnum)it.next()).getValue()))) {
                val = null;
            }
            return val;
        }
        return value_p;
    }
}

