/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwUnresolvedReference;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwFieldManagerControlObject
extends OwFieldManagerControl {
    protected static final String ATTACHMENT_DMS_ID = "dmsid";
    protected static final String PLUG_INDEX_KEY = "pi";
    private static final Logger LOG = OwLogCore.getLogger(OwFieldManagerControlObject.class);

    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (value_p != null) {
            if (fieldDef_p.isArray()) {
                Object[] values = (Object[])value_p;
                w_p.write("<table border='0' cellpadding='0' cellspacing='0'>");
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    w_p.write("<tr><td valign='center'>");
                    try {
                        this.renderObjectReferenceLinkInternal(w_p, fieldDef_p, (OwObjectReference)values[i], null, false);
                    }
                    catch (ClassCastException cce) {
                        LOG.error((Object)"Bad object for OwFieldManagerControlObject", (Throwable)cce);
                        w_p.write("Bad object!<br>");
                        w_p.write("The OwFieldManagerControlObject can only handle objects of type OwObjectReference,<br>");
                        w_p.write("but no objects of type ");
                        w_p.write(values[i].getClass().getName());
                        w_p.write(".");
                    }
                    w_p.write("</td></tr>");
                    if (i + 1 >= values.length) continue;
                    w_p.write("<tr><td class='OwObjectListDelimiter'></td></tr>");
                }
                w_p.write("</table>");
            } else {
                try {
                    this.renderObjectReferenceLinkInternal(w_p, fieldDef_p, (OwObjectReference)value_p, null, false);
                }
                catch (ClassCastException cce) {
                    LOG.error((Object)"Bad object for OwFieldManagerControlObject", (Throwable)cce);
                    w_p.write("Bad object!<br>");
                    w_p.write("The OwFieldManagerControlObject can only handle objects of type OwObjectReference,<br>");
                    w_p.write("but no objects of type ");
                    w_p.write(value_p.getClass().getName());
                    w_p.write(".");
                }
            }
        }
    }

    protected void renderObjectReferenceLinkInternal(Writer w_p, OwFieldDefinition fieldDef_p, OwObjectReference obj_p, String strID_p, boolean fEdit_p) throws Exception {
        if (obj_p == null) {
            this.renderObjectReferenceLink(w_p, fieldDef_p, obj_p, strID_p, fEdit_p);
            return;
        }
        try {
            String sUnresolvedReason = ((OwUnresolvedReference)obj_p).getUnresolvedReason();
            w_p.write("<span class=\"OwPropertyError\">");
            w_p.write(sUnresolvedReason == null ? "" : sUnresolvedReason);
            w_p.write("</span>");
        }
        catch (ClassCastException e) {
            this.renderObjectReferenceLink(w_p, fieldDef_p, obj_p, strID_p, fEdit_p);
        }
    }

    protected void renderObjectReferenceLink(Writer w_p, OwFieldDefinition fieldDef_p, OwObjectReference obj_p, String strID_p, boolean fEdit_p) throws Exception {
        if (obj_p != null) {
            w_p.write("<table border='0' cellspacing='0' cellpadding='0' width='100%'><tr>");
            w_p.write("<td class='OwWorkItemListViewMimeItem' width='10%' nowrap>");
            this.getFieldManager().getMimeManager().insertIconLink(w_p, obj_p);
            w_p.write("&nbsp;");
            this.getFieldManager().getMimeManager().insertTextLink(w_p, obj_p.getName(), obj_p);
            w_p.write("</td><td>&nbsp;</td>");
            if (fEdit_p) {
                w_p.write("<td class='OwWorkItemListViewMimeItem'>");
                this.renderPasteLink(w_p, "PasteObjectReference", strID_p, fieldDef_p);
                w_p.write("</td>");
            }
            w_p.write("</tr></table>");
        } else if (fEdit_p) {
            this.renderPasteLink(w_p, "PasteObjectReference", strID_p, fieldDef_p);
        }
    }

    protected void renderPasteObjectLink(Writer w_p, String strID_p, OwFieldDefinition fieldDef_p) throws Exception {
        this.renderPasteLink(w_p, "PasteObjectReference", strID_p, fieldDef_p);
    }

    private void renderPasteLink(Writer w_p, String callbackfunction_p, String strID_p, OwFieldDefinition fieldDef_p) throws Exception {
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        if (clipboard.getContentType() == 1 && (fieldDef_p.isArray() || !fieldDef_p.isArray() && clipboard.getContent().size() == 1)) {
            String pasteClipboardObjectTooltip = this.getContext().localize("app.OwStandardFieldManager.pasteobject", "Paste an object from the clipboard.");
            w_p.write("<a class=\"OwMimeItem\" title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" href=\"");
            w_p.write(this.getFormEventURL(callbackfunction_p, "fieldid" + "=" + strID_p, true));
            w_p.write("\">");
            w_p.write("<img style=\"vertical-align:top;border:0px none;margin:1px 2px;\" alt=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\"  src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/plug/owpaste/add_paste.png\">");
            w_p.write("</a>");
        } else {
            String pasteClipboardObjectTooltip = !fieldDef_p.isArray() && clipboard.getContent().size() > 1 ? this.getContext().localize("app.OwStandardFieldManager.howtopasteobject.onlyone", "Please copy only one object to the clipboard first. Then you can paste it using the paste icon.") : this.getContext().localize("app.OwStandardFieldManager.howtopasteobject", "Please copy an object to the clipboard first. Then you can paste it using the paste icon.");
            w_p.write("<img style=\"vertical-align:top;border:0px none;margin:1px 2px;\" alt=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\" title=\"");
            w_p.write(pasteClipboardObjectTooltip);
            w_p.write("\"  src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/plug/owpaste/add_paste_disabled.png\">");
        }
    }

    public void onPasteObjectReference(HttpServletRequest request_p) throws Exception {
        OwField field = this.getFieldManager().getField(request_p.getParameter("fieldid"));
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        if (clipboard.getContentType() == 1 && clipboard.getContent().size() == 1) {
            field.setValue(((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject());
            if (field.getFieldDefinition().isRequired()) {
                this.getFieldManager().clearFieldError(field);
            }
        }
    }

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        if (fieldDef_p.isArray()) {
            Object[] values;
            if (field_p.getValue() != null && (values = (Object[])field_p.getValue()) != null) {
                w_p.write("<table border='0' cellpadding='0' cellspacing='0'>");
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    w_p.write("<tr><td valign='center'>");
                    try {
                        this.renderObjectReferenceLinkInternal(w_p, fieldDef_p, (OwObjectReference)values[i], null, false);
                    }
                    catch (ClassCastException cce) {
                        LOG.error((Object)"Bad object for OwFieldManagerControlObject", (Throwable)cce);
                        w_p.write("Bad object!<br>");
                        w_p.write("The OwFieldManagerControlObject can only handle objects of type OwObjectReference,<br>");
                        w_p.write("but no objects of type ");
                        w_p.write(values[i].getClass().getName());
                        w_p.write(".");
                    }
                    String tooltip = this.getContext().localize("app.OwFieldManagerControlObject.delarrayitem", "Delete Item");
                    w_p.write("</td><td>");
                    w_p.write("<a title=\"");
                    w_p.write(tooltip);
                    w_p.write("\" href=\"");
                    w_p.write(this.getFormEventURL("DeleteArrayItem", "aitem=" + String.valueOf(i) + "&" + "fieldid" + "=" + strID_p));
                    w_p.write("\"><img src=\"");
                    w_p.write(this.getContext().getDesignURL());
                    w_p.write("/images/deletebtn.png\"");
                    String deleteTooltip = tooltip;
                    String fieldDisplayName = fieldDef_p.getDisplayName(this.getContext().getLocale());
                    deleteTooltip = this.getContext().localize2("app.OwStandardFieldManager.delarrayitemindexed", "Delete element at position %1 from %2", "" + (i + 1), fieldDisplayName);
                    w_p.write(" alt=\"");
                    w_p.write(deleteTooltip);
                    w_p.write("\" title=\"");
                    w_p.write(deleteTooltip);
                    w_p.write("\" /></a></td></tr>");
                    if (i + 1 >= values.length) continue;
                    w_p.write("<tr><td class=\"OwObjectListDelimiter\"></td></tr>");
                }
                w_p.write("</table>");
            }
            this.renderPasteLink(w_p, "PasteObjectArrayItem", strID_p, fieldDef_p);
        } else {
            try {
                this.renderObjectReferenceLinkInternal(w_p, fieldDef_p, (OwObjectReference)field_p.getValue(), strID_p, true);
            }
            catch (ClassCastException cce) {
                LOG.error((Object)"Bad object for OwFieldManagerControlObject", (Throwable)cce);
                w_p.write("Bad object!<br>");
                w_p.write("The OwFieldManagerControlObject can only handle objects of type OwObjectReference,<br>");
                w_p.write("but no objects of type ");
                w_p.write(field_p.getValue().getClass().getName());
                w_p.write(".");
            }
        }
    }

    public void onDeleteArrayItem(HttpServletRequest request_p) throws Exception {
        int iIndex = Integer.parseInt(request_p.getParameter("aitem"));
        OwField field = this.getFieldManager().getField(request_p.getParameter("fieldid"));
        Object[] values = (Object[])field.getValue();
        if (values.length < 2) {
            field.setValue(null);
            return;
        }
        Object[] newValues = new Object[values.length - 1];
        int iNew = 0;
        int iOrigin = 0;
        do {
            if (iIndex == iOrigin) {
                // empty if block
            }
            int n = iNew++;
            int n2 = ++iOrigin;
            ++iOrigin;
            newValues[n] = values[n2];
        } while (iNew < newValues.length);
        field.setValue(newValues);
    }

    public void onPasteObjectArrayItem(HttpServletRequest request_p) throws Exception {
        int i;
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        if (clipboard.getContentType() != 1) {
            return;
        }
        OwField field = this.getFieldManager().getField(request_p.getParameter("fieldid"));
        Object[] values = (Object[])field.getValue();
        Object[] newValues = null;
        if (null == values) {
            newValues = new Object[clipboard.getContent().size()];
        } else {
            newValues = new Object[values.length + clipboard.getContent().size()];
            for (i = 0; i < values.length; ++i) {
                newValues[i] = values[i];
            }
        }
        for (i = 0; i < clipboard.getContent().size(); ++i) {
            newValues[newValues.length - clipboard.getContent().size() + i] = ((OwClipboardContentOwObject)clipboard.getContent().get(i)).getObject();
        }
        field.setValue(newValues);
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        return value_p;
    }

    @Override
    public void insertLabel(Writer w_p, String suffix_p, OwField field, String strID_p, boolean writeLabel_p) throws Exception {
        OwFieldDefinition fieldDef_p = field.getFieldDefinition();
        w_p.write("<span>");
        w_p.write(fieldDef_p.getDisplayName(this.getContext().getLocale()));
        if (suffix_p != null) {
            w_p.write(suffix_p);
        }
        w_p.write("</span>");
    }
}

