/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl.dynamic;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwComboboxRendererFactory;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidValueException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.fieldctrlimpl.dynamic.OwDependentComboboxDataHandler;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwDependentComboboxFieldControl
extends OwFieldManagerControl {
    private static final Logger LOG = OwLogCore.getLogger(OwDependentComboboxFieldControl.class);
    public static final String EL_ACTIVE = "Active";
    public static final String EL_DEPENDENT_DATA = "DependentData";
    private OwXMLUtil config;
    private boolean search;
    private boolean create;
    private boolean edit;
    private boolean checkIn;
    private OwDependentComboboxDataHandler dataHandler;

    @Override
    public void init(OwFieldManager fieldmanager_p, Node configNode_p) throws Exception {
        super.init(fieldmanager_p, configNode_p);
        this.config = new OwStandardXMLUtil(configNode_p);
        OwXMLUtil activeContext = this.config.getSubUtil(EL_ACTIVE);
        if (activeContext != null) {
            this.search = this.config.getSafeBooleanAttributeValue("search", false);
            this.create = this.config.getSafeBooleanAttributeValue("create", true);
            this.edit = this.config.getSafeBooleanAttributeValue("edit", true);
            this.checkIn = this.config.getSafeBooleanAttributeValue("checkin", true);
        } else {
            this.search = false;
            this.create = true;
            this.edit = true;
            this.checkIn = true;
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        OwXMLUtil dataHandlerConfig = this.config.getSubUtil(EL_DEPENDENT_DATA);
        String dataHandlerClass = dataHandlerConfig.getSafeStringAttributeValue("class", "com.wewebu.ow.server.fieldctrlimpl.dynamic.OwDBDependentComboboxDataHandler");
        try {
            Class<?> clazz = Class.forName(dataHandlerClass);
            this.dataHandler = (OwDependentComboboxDataHandler)clazz.newInstance();
        }
        catch (InstantiationException instEx) {
            LOG.error((Object)("Failed to instantiate DataHandler for class=" + dataHandlerClass));
            throw new OwServerException(this.getContext().localize1("dynamic.OwDependentChoiceListFieldControl.init.dataHandler", "Failed to instantiate DataHandler for class=%1.", dataHandlerClass), (Throwable)instEx);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to instantiate DataHandler for class=" + dataHandlerClass), (Throwable)e);
            throw new OwConfigurationException(this.getContext().localize1("dynamic.OwDependentChoiceListFieldControl.create.dataHandler", "Could not create DataHandler for class=%1.", dataHandlerClass), (Throwable)e);
        }
        this.dataHandler.init(this.getContext(), dataHandlerConfig);
    }

    @Override
    public void insertReadOnlyField(Writer w, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (value_p != null) {
            w.write(String.valueOf(value_p));
        }
    }

    @Override
    public void insertEditField(Writer w, OwFieldDefinition fieldDef, OwField field, String strID) throws Exception {
        if (this.isActiveContext()) {
            this.insertComboField(w, fieldDef, field, strID);
        } else {
            this.insertEditTextField(w, fieldDef, field.getValue(), strID);
        }
    }

    protected void insertComboField(Writer w, OwFieldDefinition fieldDef, OwField field, String strID) throws OwException, IOException {
        String eventUrl = this.getAjaxEventURL("GetComboItems", "fid=" + strID);
        this.getContext().renderJSInclude("/js/dependentCombobox.js", w);
        String varName = "d" + OwHTMLHelper.encodeJavascriptVariableName(strID);
        w.write("<script type=\"text/javascript\">");
        w.write(varName);
        w.write("= new DependentComboBox(\"");
        w.write(this.getFieldManager().getFormName());
        w.write("\", \"");
        w.write(eventUrl);
        w.write("\", \"");
        w.write(strID);
        w.write("\", [");
        Iterator<String> it = this.getDataHandler().getDependentFieldIds().iterator();
        while (it.hasNext()) {
            w.write("\"");
            w.write(it.next());
            w.write("\"");
            if (!it.hasNext()) continue;
            w.write(", ");
        }
        w.write("]);\n");
        w.write("OwdJs.addOnChangeListener(");
        w.write(varName);
        w.write(");\n</script>");
        List<OwComboItem> items = this.getDataHandler().getData(this.getFieldManager().getFieldProvider());
        OwComboboxRendererFactory comboFactory = this.getContext().getRegisteredInterface(OwComboboxRendererFactory.class);
        OwComboboxRenderer renderer = comboFactory.createComboboxRenderer();
        renderer.setFieldDefinition(fieldDef);
        renderer.setFieldId(strID);
        renderer.setModel(this.createComboModel(field, items));
        renderer.addEvent("click", varName + ".onSelect");
        try {
            renderer.renderCombo(w);
        }
        catch (OwException owex) {
            throw owex;
        }
        catch (Exception e) {
            LOG.error((Object)"Faild to render combobox", (Throwable)e);
            throw new OwServerException("Could not render value representation", (Throwable)e);
        }
    }

    protected OwComboModel createComboModel(OwField field, List<OwComboItem> items) throws OwException {
        try {
            Object value = field.getValue();
            if (value != null) {
                return new OwDefaultComboModel(true, false, "" + value, items);
            }
            return new OwDefaultComboModel(true, false, null, items);
        }
        catch (OwException owex) {
            throw owex;
        }
        catch (Exception e1) {
            throw new OwServerException("Cannot retrieve current field value", (Throwable)e1);
        }
    }

    protected void insertEditTextField(Writer w, OwFieldDefinition fieldDef, Object currentValue, String id) throws OwException, IOException {
        String strText = "";
        if (currentValue != null) {
            strText = currentValue.toString();
        }
        int iMaxSize = 64;
        try {
            Object value = fieldDef.getMaxValue();
            if (value != null) {
                iMaxSize = (Integer)value;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int iVisibleSize = iMaxSize > 32 ? 32 : iMaxSize;
        w.write("<input id=\"");
        OwHTMLHelper.writeSecureHTML(w, id);
        w.write("\" maxlength=\"");
        OwHTMLHelper.writeSecureHTML(w, String.valueOf(iMaxSize));
        w.write("\" size=\"");
        OwHTMLHelper.writeSecureHTML(w, String.valueOf(iVisibleSize));
        w.write("\" title=\"");
        OwHTMLHelper.writeSecureHTML(w, fieldDef.getDescription(this.getContext().getLocale()));
        w.write("\" class=\"OwInputControl OwInputControlString OwInputControl_");
        w.write(fieldDef.getClassName());
        w.write("\" name=\"");
        OwHTMLHelper.writeSecureHTML(w, id);
        w.write("\" type=\"text\" value=\"");
        OwHTMLHelper.writeSecureHTML(w, strText);
        w.write("\" onblur='onFieldManagerFieldExit(\"");
        OwHTMLHelper.writeSecureHTML(w, OwHTMLHelper.encodeJavascriptString(fieldDef.getClassName()));
        w.write("\",\"");
        OwHTMLHelper.writeSecureHTML(w, OwHTMLHelper.encodeJavascriptString(fieldDef.getJavaClassName()));
        w.write("\",\"");
        if (this.getFieldManager().getFieldProvider() != null) {
            OwHTMLHelper.writeSecureHTML(w, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.getFieldManager().getFieldProvider().getFieldProviderType())));
            w.write("\",\"");
            OwHTMLHelper.writeSecureHTML(w, OwHTMLHelper.encodeJavascriptString(this.getFieldManager().getFieldProvider().getFieldProviderName()));
            w.write("\",\"");
        }
        OwHTMLHelper.writeSecureHTML(w, OwHTMLHelper.encodeJavascriptString(id));
        w.write("\",this.value)'>");
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        String strValue = request_p.getParameter(strID_p);
        if (strValue != null && this.isActiveContext()) {
            List<OwComboItem> allowedValues = this.getDataHandler().getData(this.getFieldManager().getFieldProvider());
            boolean validValue = true;
            for (OwComboItem item : allowedValues) {
                if (!strValue.equals(item.getValue())) continue;
                validValue = true;
                break;
            }
            if (!validValue) {
                throw new OwInvalidValueException(this.getContext().localize("dynamic.OwDependentComboboxFieldControl.updateField", "The current value is not within the allowed range."));
            }
        }
        return this.getFieldManager().convertValue(request_p, fieldDef_p, value_p, strID_p);
    }

    protected OwXMLUtil getConfig() {
        return this.config;
    }

    protected OwDependentComboboxDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public void onAjaxGetComboItems(HttpServletRequest req, HttpServletResponse resp) throws OwException, IOException {
        try {
            this.getFieldManager().updateExternalFormTarget(req, false);
        }
        catch (OwException owex) {
            throw owex;
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot update fields from request", (Throwable)e);
            throw new OwServerException("Cannot update fields from request", (Throwable)e);
        }
        List<OwComboItem> items = this.getDataHandler().getData(this.getFieldManager().getFieldProvider());
        this.processDataResponse(req, resp, items);
    }

    protected void processDataResponse(HttpServletRequest req, HttpServletResponse resp, List<OwComboItem> items) throws IOException {
        StringBuilder answer = new StringBuilder("{\"data\":[");
        if (items.isEmpty()) {
            answer.append("[\"\", \"-\"]");
        } else {
            Iterator<OwComboItem> itItems = items.iterator();
            while (itItems.hasNext()) {
                OwComboItem item = itItems.next();
                answer.append("[\"");
                answer.append(OwHTMLHelper.encodeToSecureHTML(item.getValue()));
                answer.append("\",\"");
                answer.append(OwHTMLHelper.encodeToSecureHTML(item.getDisplayName()));
                answer.append("\"]");
                if (!itItems.hasNext()) continue;
                answer.append(",");
            }
        }
        answer.append("]}");
        resp.getWriter().append(answer);
    }

    protected boolean isActiveContext() {
        OwFieldManager fieldManager = this.getFieldManager();
        return fieldManager.isFieldProviderType(1) && this.edit || fieldManager.isFieldProviderType(16) && this.create || fieldManager.isFieldProviderType(2) && this.search || fieldManager.isFieldProviderType(32) && this.checkIn;
    }
}

