/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.history;

import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OwTouchConfiguration {
    private static final String TOOLTIP_ATTRIBUTE_NAME = "tooltip";
    public static final int ALL_EVENT_TYPES = Integer.MAX_VALUE;
    public static final String ALL_EVENT_IDS = "*";
    public static final int NOT_DEFINED = Integer.MIN_VALUE;
    private static final String EVENTTYPE_ATTRIBUTE_NAME = "eventtype";
    private static final String EVENT_ID_ATTRIBUTE_NAME = "eventid";
    private static final String EVENT_NODE_NAME = "Event";
    private static final String ALL_EVENT_TYPE_AS_STRING = "*";
    private boolean m_readIcons;
    private boolean m_isConfigurationInitialized;
    private Map m_eventType2EventIdAndIcon;
    private Locale m_locale;
    private static final Logger LOG = OwLogCore.getLogger(OwTouchConfiguration.class);

    public OwTouchConfiguration(boolean shouldReadIcons_p) {
        this.m_readIcons = shouldReadIcons_p;
        this.m_isConfigurationInitialized = false;
        this.m_eventType2EventIdAndIcon = new HashMap();
    }

    public OwTouchConfiguration(boolean shouldReadIcons_p, Node touchConfigurationNode_p, Locale locale_p) throws OwConfigurationException {
        this(shouldReadIcons_p);
        this.init(touchConfigurationNode_p, locale_p);
    }

    public void init(Node touchConfigurationNode_p, Locale locale_p) throws OwConfigurationException {
        if (locale_p == null) {
            LOG.error((Object)"OwTouchConfiguration.init(): Locale parameter cannot be null");
            throw new IllegalArgumentException("Locale parameter cannot be null!");
        }
        this.m_locale = locale_p;
        if (touchConfigurationNode_p != null) {
            NodeList nodeList = touchConfigurationNode_p.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(EVENT_NODE_NAME)) continue;
                Integer eventTypeAsNumber = this.getEventTypeAttributeValue(node, EVENTTYPE_ATTRIBUTE_NAME);
                String eventId = this.getEventIdAttributeValue(node, EVENT_ID_ATTRIBUTE_NAME);
                String iconText = this.readIconText(node);
                String tooltip = this.getTooltip(node);
                OwEventID2IconMaping mapping = new OwEventID2IconMaping(eventId, iconText, tooltip);
                LinkedList<OwEventID2IconMaping> existingMappingForEventType = (LinkedList<OwEventID2IconMaping>)this.m_eventType2EventIdAndIcon.get(eventTypeAsNumber);
                if (existingMappingForEventType == null) {
                    existingMappingForEventType = new LinkedList<OwEventID2IconMaping>();
                }
                if (existingMappingForEventType.contains(mapping)) {
                    LOG.error((Object)("OwTouchConfiguration.init(): Duplicate mapping for event type: " + eventTypeAsNumber));
                    throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.duplicateentry", "Duplicate entry for event type: %1", "" + eventTypeAsNumber));
                }
                existingMappingForEventType.add(mapping);
                this.m_eventType2EventIdAndIcon.put(eventTypeAsNumber, existingMappingForEventType);
            }
            if (!this.m_eventType2EventIdAndIcon.isEmpty()) {
                this.m_isConfigurationInitialized = true;
            }
        }
    }

    private String getTooltip(Node node_p) {
        Node toolTypeNode;
        String tooltip = null;
        if (this.m_readIcons && (toolTypeNode = node_p.getAttributes().getNamedItem(TOOLTIP_ATTRIBUTE_NAME)) != null) {
            tooltip = toolTypeNode.getNodeValue();
        }
        return tooltip;
    }

    private String readIconText(Node node_p) {
        String iconText = null;
        if (this.m_readIcons) {
            StringBuffer innerText = new StringBuffer();
            NodeList childNodes = node_p.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                String nodeValue;
                Node childNode = childNodes.item(j);
                if (childNode.getNodeType() != 3 || (nodeValue = childNode.getNodeValue()) == null) continue;
                innerText.append(nodeValue.trim());
            }
            iconText = innerText.toString().trim();
        }
        return iconText;
    }

    private Integer getEventTypeAttributeValue(Node node_p, String attributeName_p) throws OwConfigurationException {
        Integer eventTypeAsNumber;
        block8: {
            eventTypeAsNumber = null;
            Node eventTypeNode = node_p.getAttributes().getNamedItem(attributeName_p);
            if (eventTypeNode == null) {
                LOG.error((Object)("OwTouchConfiguration.getEventTypeAttributeValue(): Attribute " + attributeName_p + " is null"));
                throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.attributenotfound", "Attribute '%1' is not found in the specified node.", attributeName_p));
            }
            String eventType = eventTypeNode.getNodeValue();
            if (null == eventType) {
                LOG.error((Object)("OwTouchConfiguration.getEventTypeAttributeValue(): Attribute " + attributeName_p + " has null value"));
                throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.attributehasnovalue", "Attribute '%1' has no value.", attributeName_p));
            }
            try {
                eventTypeAsNumber = Integer.valueOf(eventType);
            }
            catch (NumberFormatException e) {
                if (eventType.equals("*")) {
                    eventTypeAsNumber = Integer.MAX_VALUE;
                }
                Field[] fields = OwEventManager.class.getFields();
                for (int j = 0; j < fields.length; ++j) {
                    if (!fields[j].getType().equals(Integer.TYPE) || fields[j].getName().compareTo(eventType) != 0) continue;
                    try {
                        eventTypeAsNumber = (Integer)fields[j].get(null);
                    }
                    catch (IllegalAccessException ex) {}
                    break;
                }
                if (eventTypeAsNumber != null) break block8;
                LOG.error((Object)("OwTouchConfiguration.getEventTypeAttributeValue(): Invalid event type: " + eventType));
                throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.invalideventtype", "Invalid event type: %1", eventType));
            }
        }
        return eventTypeAsNumber;
    }

    private String getEventIdAttributeValue(Node node_p, String attributeName_p) throws OwConfigurationException {
        Node eventIdNode = node_p.getAttributes().getNamedItem(attributeName_p);
        if (eventIdNode == null) {
            LOG.error((Object)("OwTouchConfiguration.getEventIdAttributeValue(): Attribute " + attributeName_p + " is null"));
            throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.attributenotfound", "Attribute '%1' is not found in the specified node.", attributeName_p));
        }
        String eventId = eventIdNode.getNodeValue();
        String eventIdAsString = null;
        if (eventId == null) {
            LOG.error((Object)("OwTouchConfiguration.getEventIdAttributeValue(): Attribute " + attributeName_p + " has null value"));
            throw new OwConfigurationException(OwString.localize1(this.m_locale, "app.OwConfiguration.touch.attributehasnovalue", "Attribute '%1' has no value.", attributeName_p));
        }
        if ("*".compareTo(eventId) != 0) {
            Field[] fields = OwEventManager.class.getFields();
            for (int j = 0; j < fields.length; ++j) {
                if (!fields[j].getType().equals(String.class) || fields[j].getName().compareTo(eventId) != 0) continue;
                try {
                    eventIdAsString = (String)fields[j].get(null);
                }
                catch (IllegalAccessException ex) {}
                break;
            }
            if (eventIdAsString == null) {
                eventIdAsString = eventId;
            }
        } else {
            eventIdAsString = "*";
        }
        return eventIdAsString;
    }

    public String getIconForEventType(int eventType_p, String eventId_p) {
        String result = null;
        List mappingList = (List)this.m_eventType2EventIdAndIcon.get(eventType_p);
        if (mappingList == null) {
            return null;
        }
        OwEventID2IconMaping allEventsMapping = null;
        OwEventID2IconMaping specificMapping = null;
        for (OwEventID2IconMaping mapping : mappingList) {
            if (mapping.isGenericMapping()) {
                allEventsMapping = mapping;
            }
            if (mapping.getEventId().compareTo(eventId_p) != 0) continue;
            specificMapping = mapping;
            break;
        }
        if (specificMapping == null) {
            specificMapping = allEventsMapping;
        }
        if (specificMapping != null) {
            result = specificMapping.getIcon();
        }
        return result;
    }

    public String[] getEventIdsForEventType(int eventType_p) {
        String[] result = new String[]{};
        Integer key = eventType_p;
        if (this.m_eventType2EventIdAndIcon.containsKey(key)) {
            List mappingList = (List)this.m_eventType2EventIdAndIcon.get(eventType_p);
            List resultList = this.getEventIdsAsList(mappingList);
            result = resultList.toArray(new String[resultList.size()]);
        }
        return result;
    }

    private List getEventIdsAsList(List mappingList_p) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (OwEventID2IconMaping mapping : mappingList_p) {
            resultList.add(mapping.getEventId());
        }
        return resultList;
    }

    public boolean isConfigured(int eventType_p, String strEventID_p) {
        Integer key = eventType_p;
        boolean result = this.isEventIdAvailableForEventType(strEventID_p, key);
        if (!result) {
            key = Integer.MAX_VALUE;
            result = this.isEventIdAvailableForEventType(strEventID_p, key);
        }
        return result;
    }

    private boolean isEventIdAvailableForEventType(String strEventID_p, Integer theEventType_p) {
        List mappingList;
        boolean result = false;
        if (this.m_eventType2EventIdAndIcon.containsKey(theEventType_p) && !(result = this.getEventIdsAsList(mappingList = (List)this.m_eventType2EventIdAndIcon.get(theEventType_p)).contains(strEventID_p))) {
            result = this.getEventIdsAsList(mappingList).contains("*");
        }
        return result;
    }

    public boolean isConfigured(int eventType_p) {
        boolean result = false;
        if (this.m_eventType2EventIdAndIcon.containsKey(eventType_p)) {
            result = true;
        }
        if (!result) {
            result = this.m_eventType2EventIdAndIcon.containsKey(Integer.MAX_VALUE);
        }
        return result;
    }

    public Set getConfiguredEventTypes() {
        return this.m_eventType2EventIdAndIcon.keySet();
    }

    public List getConfiguredMappingForEventType(int eventType_p) {
        List result = new LinkedList();
        Integer key = eventType_p;
        if (this.m_eventType2EventIdAndIcon.containsKey(key)) {
            result = (List)this.m_eventType2EventIdAndIcon.get(key);
        }
        return result;
    }

    public boolean isTouchConfigurationInitialized() {
        return this.m_isConfigurationInitialized;
    }

    public boolean isGenericEventType(Integer eventType_p) {
        return eventType_p != null && eventType_p == Integer.MAX_VALUE;
    }

    public boolean isGenericEventId(String eventId_p) {
        return eventId_p != null && eventId_p.compareTo("*") == 0;
    }

    public class OwEventID2IconMaping {
        private String m_eventId;
        private String m_icon;
        private String m_tooltip;

        public OwEventID2IconMaping(String eventId_p, String icon_p, String tooltip_p) {
            this.m_eventId = eventId_p;
            this.m_icon = icon_p;
            this.m_tooltip = tooltip_p;
            if (this.m_eventId == null) {
                LOG.error((Object)"OwEventID2IconMaping.constructor: Event ID cannot be null");
                throw new IllegalArgumentException("Event ID cannot be null");
            }
        }

        public String getEventId() {
            return this.m_eventId;
        }

        public String getIcon() {
            return this.m_icon;
        }

        public String getTooltip() {
            String result = "";
            if (this.hasTooltip()) {
                result = OwString.localize(OwTouchConfiguration.this.m_locale, this.m_tooltip, this.m_tooltip);
            }
            return result;
        }

        public boolean hasTooltip() {
            return null != this.m_tooltip;
        }

        public int hashCode() {
            return this.m_eventId.hashCode();
        }

        public boolean equals(Object obj_p) {
            boolean result = false;
            if (obj_p instanceof OwEventID2IconMaping) {
                OwEventID2IconMaping toBeCompared = (OwEventID2IconMaping)obj_p;
                if (toBeCompared.m_eventId.compareTo(this.m_eventId) == 0) {
                    if (this.m_icon != null && this.m_icon.compareTo(toBeCompared.m_icon) == 0) {
                        result = true;
                    } else if (this.m_icon == null && toBeCompared.m_icon == null) {
                        result = true;
                    }
                }
            }
            return result;
        }

        public boolean isGenericMapping() {
            return this.m_eventId.compareTo("*") == 0;
        }
    }
}

