/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDocumentImportItem;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwExceptionManager;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;

public class OwDragDropContent
extends HttpServlet {
    private static final Logger LOG = OwLogCore.getLogger(OwDragDropContent.class);
    private static final long serialVersionUID = 5837220102300078270L;

    public void destroy() {
        super.destroy();
    }

    public void doDelete(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
    }

    public void doGet(HttpServletRequest request_p, HttpServletResponse response_p) {
        try {
            this.processRequest(request_p, response_p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doPost(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        try {
            this.processRequest(request_p, response_p);
        }
        catch (Exception e) {
            LOG.error((Object)"OwDragDropContent.doPost Exception", (Throwable)e);
            OwExceptionManager.PrintCatchedException(Locale.ENGLISH, e, response_p.getWriter(), "OwOwWebApplication_EXCEPTION");
        }
    }

    public void doPut(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        try {
            this.processRequest(request_p, response_p);
        }
        catch (Exception e) {
            LOG.error((Object)"OwDragDropContent.doPut Exception", (Throwable)e);
            OwExceptionManager.PrintCatchedException(Locale.ENGLISH, e, response_p.getWriter(), "OwOwWebApplication_EXCEPTION");
        }
    }

    public String getServletInfo() {
        return "Workdesk Drag&Drop-Servlet";
    }

    public void init() throws ServletException {
    }

    private static boolean isHexDigit(byte test_p) {
        return test_p >= 48 && test_p <= 57 || test_p >= 65 && test_p <= 70 || test_p >= 97 && test_p <= 102;
    }

    private static char DecodeHexChar(byte b1_p, byte b2_p) {
        int result = b1_p >= 65 ? (b1_p & 0xDF) - 65 + 10 : b1_p - 48;
        result *= 16;
        return (char)(result += b2_p >= 65 ? (b2_p & 0xDF) - 65 + 10 : b2_p - 48);
    }

    public void processRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException, Exception {
        OwMainAppContext context = (OwMainAppContext)request_p.getSession().getAttribute("ow_Context");
        request_p.setCharacterEncoding("UTF-8");
        if (context == null) {
            String msg = "OwDragDropContent.processRequest: Trying to retrieve the context from the session but the context (OwMainAppContext) is null. Possible cause: maybe the name of the session cookie is not supported (see 'SessionCookieNames' in owbootstrap.xml ) ...";
            LOG.error((Object)msg);
            response_p.sendError(500);
            OwExceptionManager.PrintCatchedException(Locale.ENGLISH, new OwInvalidOperationException(msg), response_p.getWriter(), "OwOwWebApplication_EXCEPTION");
            request_p.getInputStream().close();
            throw new ServletException("msg");
        }
        context.setRequest(this.getServletContext(), request_p, response_p);
        context.releaseDNDImportedDocuments();
        String pathToCommonDNDTempDir = null;
        try {
            pathToCommonDNDTempDir = context.getDNDDocumentImportTempDir();
            if (pathToCommonDNDTempDir == null) {
                String msg = "OwDragDropContent.processRequest: Creating of tempdir failed, the tempdir is null... ";
                LOG.error((Object)msg);
                response_p.setStatus(500);
                response_p.getWriter().println(msg);
                return;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while creating the tempdir.", (Throwable)e);
            response_p.setStatus(500);
            OwExceptionManager.PrintCatchedException(context.getLocale(), e, response_p.getWriter(), "OwOwWebApplication_EXCEPTION");
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(40960);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        List docs = upload.parseRequest(request_p);
        Iterator iter = docs.iterator();
        boolean atLeastOneSuccessful = false;
        while (iter.hasNext()) {
            FileItem doc = (FileItem)iter.next();
            String raw_filename = null;
            try {
                raw_filename = URLDecoder.decode(doc.getName(), "UTF-8");
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while getting the raw filename. Continuing with next file.", (Throwable)e);
                continue;
            }
            String upload_filename = raw_filename.replace('/', '\\');
            int pos = upload_filename.lastIndexOf("\\");
            String rootPath = "";
            if (pos >= 0) {
                rootPath = upload_filename.substring(0, pos);
                rootPath = rootPath.replace('\\', '/');
                upload_filename = upload_filename.substring(pos + 1);
            }
            String sSingleSavePath = pathToCommonDNDTempDir + File.separatorChar + upload_filename;
            LOG.debug((Object)("File: " + upload_filename));
            try {
                int fileID = context.getNextDNDDocumentImportFileID();
                File tempFile = new File(pathToCommonDNDTempDir + File.separatorChar + Integer.toString(fileID));
                doc.write(tempFile);
                OwDocumentImportItem importedDocumentItem = this.createDocumentImportItem(pathToCommonDNDTempDir, rootPath, upload_filename, fileID);
                context.addDNDImportedDocumentToStack(importedDocumentItem);
            }
            catch (Exception e) {
                LOG.error((Object)("OwDragDropContent.processRequest: Exception while writing the file contents to disk (tempfile:" + sSingleSavePath + "). Continuing with next file."), (Throwable)e);
                continue;
            }
            atLeastOneSuccessful = true;
        }
        if (!atLeastOneSuccessful) {
            response_p.setStatus(500);
            response_p.getWriter().println("No file could be uploaded.");
            return;
        }
    }

    private static String bytesToStringUTF(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
        }
        return new String(buffer);
    }

    protected OwDocumentImportItem createDocumentImportItem(String pathToCommonDNDTempDir_p, String rootPath_p, String upload_filename_p, int fileID_p) throws Exception {
        return new OwStandardDocumentImportItem(pathToCommonDNDTempDir_p, fileID_p, upload_filename_p);
    }
}

