/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwWebApplication;
import com.wewebu.ow.server.util.OwStreamUtil;
import com.wewebu.service.rendition.OwRenditionService;
import com.wewebu.service.rendition.OwRenditionServiceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class OwRenditionServlet
extends HttpServlet {
    private static final Logger LOG = OwLogCore.getLogger(OwRenditionServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_PARAM_RENDITION = "rendition";
    public static final String DEFAULT_PARAM_FALLBACK = "fallback";
    private static final String INIT_PARAM_FOLDER_IMAGE = "folderImage";
    private static final String INIT_PARAM_ERROR_IMAGE = "errorImage";
    private static final String INIT_PARAM_NO_CONTENT_IMAGE = "noContentImage";
    private String paramType;
    private String folderImagePath;
    private String noContentImagePath;
    private String errorImagePath;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.paramType = config.getInitParameter(DEFAULT_PARAM_RENDITION);
        if (this.paramType == null) {
            this.paramType = DEFAULT_PARAM_RENDITION;
        }
        this.folderImagePath = this.getConfiguredImage(config, INIT_PARAM_FOLDER_IMAGE);
        if (this.folderImagePath == null) {
            throw new ServletException("No init param folderImage configured");
        }
        this.noContentImagePath = this.getConfiguredImage(config, INIT_PARAM_NO_CONTENT_IMAGE);
        if (this.noContentImagePath == null) {
            throw new ServletException("No init param noContentImage configured");
        }
        this.errorImagePath = this.getConfiguredImage(config, INIT_PARAM_ERROR_IMAGE);
        if (this.errorImagePath == null) {
            throw new ServletException("No init param errorImage configured");
        }
    }

    protected String getConfiguredImage(ServletConfig config, String initParam) {
        String confImg = config.getInitParameter(initParam);
        if (confImg != null && !confImg.startsWith("/")) {
            confImg = "/" + confImg;
        }
        return confImg;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession ses = req.getSession(false);
        if (ses != null) {
            String type = req.getParameter(this.paramType);
            OwAppContext appCtx = OwWebApplication.getContext(ses);
            try {
                if (appCtx != null && appCtx.isLogin()) {
                    boolean processed;
                    block14: {
                        OwObject obj;
                        processed = false;
                        OwRenditionServiceProvider prov = appCtx.getRegisteredInterface(OwRenditionServiceProvider.class);
                        OwRenditionService service = prov.getRendtionService(obj = this.getRequestedObject(req, appCtx));
                        if (service != null) {
                            boolean hasRendition = service.hasRendition(obj, type);
                            if (hasRendition || service.canCreateRendition(obj, type)) {
                                try {
                                    if (!hasRendition) {
                                        service.createRendition(obj, type);
                                    }
                                    if (service.hasRendition(obj, type)) {
                                        processed = this.sendRendition(req, resp, prov, service, obj, type);
                                        break block14;
                                    }
                                    this.handleNoRendition(req, resp, obj, prov, type);
                                }
                                catch (OwException e) {
                                    this.handleNoRendition(req, resp, obj, prov, type);
                                }
                            } else {
                                this.handleNoRendition(req, resp, obj, prov, type);
                            }
                        } else {
                            this.handleNoRendition(req, resp, obj, prov, type);
                        }
                    }
                    if (!LOG.isDebugEnabled()) return;
                    if (processed) {
                        LOG.debug((Object)"OwRenditionServlet.process: Rendition processed successfully");
                        return;
                    }
                    LOG.debug((Object)"OwRenditionServlet.process: No rendition");
                    return;
                }
                resp.setStatus(403);
                LOG.debug((Object)"OwRenditionServlet.process: No authentication found, sending forbidden response");
                return;
            }
            catch (IOException e) {
                LOG.error((Object)"IO error during process of rendition request", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to process rendition request", (Throwable)e);
                this.showStaticImage(resp, this.errorImagePath);
                return;
            }
        }
        resp.setStatus(403);
    }

    protected void handleNoRendition(HttpServletRequest req, HttpServletResponse resp, OwObject obj, OwRenditionServiceProvider prov, String type) throws OwException, IOException {
        String strFallback = req.getParameter(DEFAULT_PARAM_FALLBACK);
        boolean fallback = false;
        if (null != strFallback) {
            fallback = Boolean.parseBoolean(strFallback);
        }
        OwRenditionService fallbackService = prov.getFallbackRendtionService();
        if (fallback && null != fallbackService) {
            boolean hasRendition = fallbackService.hasRendition(obj, type);
            if (hasRendition || fallbackService.canCreateRendition(obj, type)) {
                boolean handled;
                if (!hasRendition) {
                    fallbackService.createRendition(obj, type);
                }
                if (!(handled = this.sendRendition(req, resp, prov, fallbackService, obj, type))) {
                    this.sendDefaultStaticRendition(req, resp, obj);
                }
            } else {
                this.sendDefaultStaticRendition(req, resp, obj);
            }
        } else {
            this.sendDefaultStaticRendition(req, resp, obj);
        }
    }

    private void sendDefaultStaticRendition(HttpServletRequest req, HttpServletResponse resp, OwObject obj) throws IOException {
        if (obj.getType() == 8193 || obj.getType() == 8207) {
            this.showStaticImage(resp, this.folderImagePath);
        } else {
            this.showStaticImage(resp, this.noContentImagePath);
        }
    }

    protected void showStaticImage(HttpServletResponse resp, String path) throws IOException {
        InputStream staticImage = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        if (staticImage != null) {
            OwStreamUtil.upload(staticImage, (OutputStream)resp.getOutputStream(), true, 8192);
        } else {
            LOG.warn((Object)("OwRenditionServlet.showStaticImage: could not find static source under path = " + path));
        }
    }

    protected OwObject getRequestedObject(HttpServletRequest req, OwAppContext context) throws OwException {
        OwRoleManagerContext roleCtx = context.getRegisteredInterface(OwRoleManagerContext.class);
        String dmsid = req.getParameter("dmsid");
        try {
            return roleCtx.getNetwork().getObjectFromDMSID(dmsid, true);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not get Object by DMSID = " + dmsid), (Throwable)e);
            throw new OwServerException("Faild to retrieve Object from DMSID", (Throwable)e);
        }
    }

    protected boolean sendRendition(HttpServletRequest req, HttpServletResponse resp, OwRenditionServiceProvider prov, OwRenditionService service, OwObject obj, String renditionType) throws IOException, OwException {
        List<String> mimetypes = service.getRenditionMimeType(obj, renditionType);
        if (!mimetypes.isEmpty()) {
            InputStream stream = service.getRenditionStream(obj, renditionType);
            if (stream == null) {
                return false;
            }
            resp.setContentType(mimetypes.get(0));
            OwStreamUtil.upload(stream, (OutputStream)resp.getOutputStream(), true, 8192);
            return true;
        }
        return false;
    }
}

