/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.settingsimpl.OwSettingsPropertyBaseImpl;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class OwSettingsPropertyStringConfigurationBox
extends OwSettingsPropertyBaseImpl {
    private static final String WEBKEY_AVAILABLE_ATTRIBUTES = "available_";
    private static final String WEBKEY_SELECTED_ATTRIBUTES = "selected_";
    protected static final String COMBO_SELECT_ITEM_NODE_NAME = "comboselect";
    protected static final String COMBO_SELECT_ITEM_DISPLAY_ATTR_NAME = "displayname";
    private static final int BOX_SIZE = 10;
    private int m_selectedIndex;
    Map m_attributesDisplayNameMap;
    List m_availableAttributes;

    @Override
    public void insertFormField(Writer w_p) throws Exception {
        List selectedAttributes = this.getSelectedPropertiesList();
        List currentlyAvailableAttributes = this.createCurrentlyAvailableAttributes(selectedAttributes);
        Map displayNameMap = this.getAttributeDisplayNameMap();
        w_p.write("<TABLE class='OwTaskGeneralText'>");
        w_p.write("<TR>\n");
        String displayName = this.getDisplayName();
        String availableId = WEBKEY_AVAILABLE_ATTRIBUTES + String.valueOf(this.hashCode());
        String selectedId = WEBKEY_SELECTED_ATTRIBUTES + String.valueOf(this.hashCode());
        w_p.write("<TD class='OwSelectBoxTitle'>");
        w_p.write("<label for='" + availableId + "'>");
        w_p.write(this.getContext().localize1("settingsimpl.OwSettingsPropertyStringConfigurationBox.available.label", "Available &nbsp; %1", displayName));
        w_p.write("</label>");
        w_p.write("</TD>\n");
        w_p.write("<TD>&nbsp;</TD>\n");
        w_p.write("<TD class='OwSelectBoxTitle'>");
        w_p.write("<label for='" + selectedId + "'>");
        w_p.write(this.getContext().localize1("settingsimpl.OwSettingsPropertyStringConfigurationBox.selected.label", "Selected &nbsp; %1", displayName));
        w_p.write("</label>");
        w_p.write("</TD>\n");
        w_p.write("<TD>&nbsp;</TD>\n");
        w_p.write("</TR>\n");
        w_p.write("<TR>\n");
        w_p.write("<TD><SELECT class='OwInputfield_long' size='10' name='" + availableId + "' id='" + availableId + "'>\n");
        for (int pos = 0; pos < currentlyAvailableAttributes.size(); ++pos) {
            String attribute = (String)currentlyAvailableAttributes.get(pos);
            String attributeLabel = (String)displayNameMap.get(attribute);
            w_p.write("<OPTION value='" + attribute + "'>");
            w_p.write(attributeLabel != null ? attributeLabel : attribute);
            w_p.write("</OPTION>\n");
        }
        w_p.write("</SELECT>");
        w_p.write("</TD>\n");
        String submitLeftShiftFunction = this.getFormEventURL("ShiftLeft", null);
        String submitRightShiftFunction = this.getFormEventURL("ShiftRight", null);
        w_p.write("<TD class='shiftButtons' width='60pt'>");
        String shiftLeftTooltip = this.getContext().localize("plug.owtask.ui.OwDisplayColumnsSettingsView.shiftleft", "Shift property left");
        w_p.write("<a href=\"" + submitLeftShiftFunction + "\"><img src='" + this.getContext().getDesignURL() + "/images/plug/pointer_left.png' width='32' height='32' border='0' alt='" + shiftLeftTooltip + "' title='" + shiftLeftTooltip + "'/></a>");
        w_p.write("<br>");
        w_p.write("<br>");
        String shiftRightTooltip = this.getContext().localize("plug.owtask.ui.OwDisplayColumnsSettingsView.shiftright", "Shift property right");
        w_p.write("<a href=\"" + submitRightShiftFunction + "\"><img src='" + this.getContext().getDesignURL() + "/images/plug/pointer_right.png' width='32' height='32' border='0' alt='" + shiftRightTooltip + "' title='" + shiftRightTooltip + "'/></a>");
        w_p.write("</TD>\n");
        w_p.write("<TD><SELECT id='" + selectedId + "' class='OwInputfield_long' size='" + 10 + "' name='" + selectedId + "'>\n");
        for (int pos = 0; pos < selectedAttributes.size(); ++pos) {
            String attribute = (String)selectedAttributes.get(pos);
            String attributeLabel = "";
            if (attribute != null) {
                attributeLabel = (String)displayNameMap.get(attribute);
            }
            w_p.write("<OPTION value='" + attribute + "' ");
            if (this.m_selectedIndex == pos) {
                w_p.write("selected");
            }
            w_p.write(">");
            w_p.write(attributeLabel != null ? attributeLabel : attribute);
            w_p.write("</OPTION>\n");
        }
        w_p.write("</SELECT>");
        w_p.write("</TD>\n");
        String submitMoveUpFunction = this.getFormEventURL("MoveUp", null);
        String submitMoveDownFunction = this.getFormEventURL("MoveDown", null);
        w_p.write("<TD>");
        String moveUpTooltip = this.getContext().localize("plug.owtask.ui.OwDisplayColumnsSettingsView.shiftup", "Shift property up");
        w_p.write("<a href=\"" + submitMoveUpFunction + "\"><img src='" + this.getContext().getDesignURL() + "/images/plug/pointer_up.png' width='32' height='32' border='0' alt='" + moveUpTooltip + "' title='" + moveUpTooltip + "'></a>");
        w_p.write("<BR>");
        w_p.write("<BR>");
        String moveDownTooltip = this.getContext().localize("plug.owtask.ui.OwDisplayColumnsSettingsView.shiftdown", "Shift property down");
        w_p.write("<a href=\"" + submitMoveDownFunction + "\"><img src='" + this.getContext().getDesignURL() + "/images/plug/pointer_down.png' width='32' height='32' border='0' alt='" + moveDownTooltip + "' title='" + moveDownTooltip + "'></a>");
        w_p.write("</TD>\n");
        w_p.write("</TR>\n");
        w_p.write("</TABLE>\n");
    }

    private List createCurrentlyAvailableAttributes(List selectedAttributes_p) throws Exception {
        List availableAttributes = this.getAvailableAttributeList();
        ArrayList<String> currentlyAvailableAttributes = new ArrayList<String>();
        for (String attr : availableAttributes) {
            if (selectedAttributes_p.contains(attr)) continue;
            currentlyAvailableAttributes.add(attr);
        }
        return currentlyAvailableAttributes;
    }

    private Map getAttributeDisplayNameMap() throws Exception {
        if (null == this.m_availableAttributes) {
            this.m_attributesDisplayNameMap = new HashMap();
            this.m_availableAttributes = this.createAvailablePropertiesList(this.m_attributesDisplayNameMap);
        }
        return this.m_attributesDisplayNameMap;
    }

    private List getAvailableAttributeList() throws Exception {
        if (null == this.m_availableAttributes) {
            this.m_attributesDisplayNameMap = new HashMap();
            this.m_availableAttributes = this.createAvailablePropertiesList(this.m_attributesDisplayNameMap);
        }
        return this.m_availableAttributes;
    }

    protected List createAvailablePropertiesList(Map attributesMap_p) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        for (Node n = this.getPropertyDefinitionNode().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals(COMBO_SELECT_ITEM_NODE_NAME)) continue;
            OwStandardXMLUtil nodeWrapper = new OwStandardXMLUtil(n);
            String strDisplayName = null;
            String strValue = nodeWrapper.getSafeTextValue(null);
            if (null == strValue) continue;
            strDisplayName = ((OwMainAppContext)this.getContext()).localizeLabel(strValue);
            if (strDisplayName.equals(strValue)) {
                strDisplayName = nodeWrapper.getSafeStringAttributeValue(COMBO_SELECT_ITEM_DISPLAY_ATTR_NAME, "?");
                strDisplayName = ((OwMainAppContext)this.getContext()).localize(strDisplayName, strDisplayName);
            }
            attributesMap_p.put(strValue, strDisplayName);
            valueList.add(strValue);
        }
        return valueList;
    }

    protected List getSelectedPropertiesList() throws Exception {
        return (List)this.getValue();
    }

    public void onShiftLeft(HttpServletRequest request_p) throws Exception {
        String selectedAttribute = request_p.getParameter(WEBKEY_SELECTED_ATTRIBUTES + String.valueOf(this.hashCode()));
        if (selectedAttribute == null) {
            return;
        }
        List selectedList = this.getSelectedPropertiesList();
        selectedList.remove(selectedAttribute);
        this.m_selectedIndex = -1;
    }

    public void onShiftRight(HttpServletRequest request_p) throws Exception {
        String selectedAttribute = request_p.getParameter(WEBKEY_AVAILABLE_ATTRIBUTES + String.valueOf(this.hashCode()));
        if (selectedAttribute == null) {
            return;
        }
        List selectedList = this.getSelectedPropertiesList();
        selectedList.add(selectedAttribute);
        this.m_selectedIndex = selectedList.size() - 1;
    }

    public void onMoveUp(HttpServletRequest request_p) throws Exception {
        String selectedAttribute = request_p.getParameter(WEBKEY_SELECTED_ATTRIBUTES + String.valueOf(this.hashCode()));
        if (selectedAttribute == null) {
            return;
        }
        List selectedList = this.getSelectedPropertiesList();
        int index = selectedList.indexOf(selectedAttribute);
        if (index == 0) {
            return;
        }
        selectedList.remove(index);
        selectedList.add(index - 1, selectedAttribute);
        this.m_selectedIndex = index - 1;
    }

    public void onMoveDown(HttpServletRequest request_p) throws Exception {
        String selectedAttribute = request_p.getParameter(WEBKEY_SELECTED_ATTRIBUTES + String.valueOf(this.hashCode()));
        if (selectedAttribute == null) {
            return;
        }
        List selectedList = this.getSelectedPropertiesList();
        int index = selectedList.indexOf(selectedAttribute);
        if (index == selectedList.size() - 1) {
            return;
        }
        selectedList.remove(index);
        selectedList.add(index + 1, selectedAttribute);
        this.m_selectedIndex = index + 1;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return true;
    }
}

