/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwWindowPositions;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.settingsimpl.OwSettingsPropertyBaseImpl;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OwSettingsPropertyWindowPositions
extends OwSettingsPropertyBaseImpl {
    protected static final String VIEWER_WIDTH = "OwViewerWidth";
    protected static final String VIEWER_HEIGHT = "OwViewerHeight";
    protected static final String VIEWER_TOPX = "OwViewerTopX";
    protected static final String VIEWER_TOPY = "OwViewerTopY";
    protected static final String MAIN_WIDTH = "OwWindowWidth";
    protected static final String MAIN_HEIGHT = "OwWindowHeight";
    protected static final String MAIN_TOPX = "OwWindowTopX";
    protected static final String MAIN_TOPY = "OwWindowTopY";
    protected static final String DISPLAY_MODE = "OwDisplaySettingsMode";
    protected static final String POSITION_MAIN = "OwPositionMainWindow";

    @Override
    protected Object getDefaultListItemValue() {
        return new OwWindowPositionsImpl();
    }

    @Override
    protected Object getSingleValueFromRequest(HttpServletRequest request_p, String strID_p) throws OwInvalidOperationException {
        return new OwWindowPositionsImpl(request_p, strID_p);
    }

    @Override
    protected void appendSingleValueNode(Node valueRootNode_p, Object value_p) {
        ((OwWindowPositionsImpl)value_p).appendNode(valueRootNode_p);
    }

    @Override
    protected Object createSingleClonedValue(Object oSingleValue_p) {
        return ((OwWindowPositionsImpl)oSingleValue_p).createClone();
    }

    @Override
    protected Object getSingleValue(Node valueNode_p) {
        return new OwWindowPositionsImpl(valueNode_p);
    }

    @Override
    protected void insertFormValue(Writer w_p, Object value_p, String strID_p, int iIndex_p) throws Exception {
        ((OwWindowPositionsImpl)value_p).insertFormValue(w_p, strID_p, this.getContext().getLocale());
    }

    @Override
    public void insertLabel(Writer w_p) throws Exception {
        w_p.write(this.getDisplayName() + ":");
    }

    @Override
    protected void insertLabelValue(Writer w_p, String displayName, String strID_p, int iIndex_p) throws IOException {
        w_p.write("<label for=\"" + strID_p + "\">");
        w_p.write(displayName + ":");
        w_p.write("</label>");
    }

    public class OwWindowPositionsImpl
    extends OwWindowPositions {
        protected boolean relativePos;
        private int m_iViewerWidth;
        private int m_iViewerHeight;
        private int m_iViewerTopX;
        private int m_iViewerTopY;
        private boolean m_fWindow;
        private String m_stDisplaySettings;
        private int m_iWindowWidth;
        private int m_iWindowHeight;
        private int m_iWindowTopX;
        private int m_iWindowTopY;

        public OwWindowPositionsImpl() {
            this.relativePos = false;
        }

        public OwWindowPositionsImpl(HttpServletRequest request_p, String strID_p) throws OwInvalidOperationException {
            this.setFromRequest(request_p, strID_p);
        }

        public OwWindowPositionsImpl(Node valueNode_p) {
            OwStandardXMLUtil nodeWrapper = null;
            try {
                nodeWrapper = new OwStandardXMLUtil(valueNode_p);
            }
            catch (Exception e) {
                return;
            }
            this.relativePos = nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.VIEWER_WIDTH, "").endsWith("%");
            this.m_iViewerWidth = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.VIEWER_WIDTH, null), 0);
            this.m_iViewerHeight = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.VIEWER_HEIGHT, null), 0);
            this.m_iViewerTopX = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.VIEWER_TOPX, null), 0);
            this.m_iViewerTopY = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.VIEWER_TOPY, null), 0);
            this.m_iWindowWidth = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.MAIN_WIDTH, null), 0);
            this.m_iWindowHeight = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.MAIN_HEIGHT, null), 0);
            this.m_iWindowTopX = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.MAIN_TOPX, null), 0);
            this.m_iWindowTopY = this.getSafeIntegerValue(nodeWrapper.getSafeTextValue(OwSettingsPropertyWindowPositions.MAIN_TOPY, null), 0);
            this.m_fWindow = nodeWrapper.getSafeIntegerValue(OwSettingsPropertyWindowPositions.POSITION_MAIN, 0) == 1;
            this.m_stDisplaySettings = nodeWrapper.getSafeStringAttributeValue(OwSettingsPropertyWindowPositions.DISPLAY_MODE, "");
        }

        @Override
        public void setFromRequest(HttpServletRequest request_p, String strBaseID_p) throws OwInvalidOperationException {
            try {
                this.relativePos = request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.VIEWER_WIDTH).endsWith("%");
                this.m_iViewerWidth = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.VIEWER_WIDTH));
                this.m_iViewerHeight = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.VIEWER_HEIGHT));
                this.m_iViewerTopX = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.VIEWER_TOPX));
                this.m_iViewerTopY = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.VIEWER_TOPY));
                this.m_iWindowWidth = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.MAIN_WIDTH));
                this.m_iWindowHeight = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.MAIN_HEIGHT));
                this.m_iWindowTopX = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.MAIN_TOPX));
                this.m_iWindowTopY = this.getIntegerValue(request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.MAIN_TOPY));
                this.m_stDisplaySettings = request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.DISPLAY_MODE);
                String sWindow = request_p.getParameter(strBaseID_p + OwSettingsPropertyWindowPositions.POSITION_MAIN);
                if (null != sWindow) {
                    this.m_fWindow = Boolean.valueOf(sWindow);
                }
            }
            catch (Exception e) {
                String msg = OwString.localize(OwSettingsPropertyWindowPositions.this.getContext().getLocale(), "settingsimpl.OwSettingsPropertyWindowPositions.validvalues", "Please insert valid values");
                throw new OwInvalidOperationException(msg, (Throwable)e);
            }
        }

        protected void insertFormValue(Writer w_p, String strID_p, Locale locale_p) throws Exception {
            w_p.write("<div class=\"owInlineControls\" style=\"float:left;\">");
            w_p.write("<table>");
            w_p.write("<tr><td>");
            w_p.write("<script>");
            w_p.write(" var strID='" + strID_p + "';");
            w_p.write("</script>");
            w_p.write("<div style=\"clear:both;\" ><div class=\"OwPropertyName\">");
            w_p.write(OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.viewerpos", "Viewer Position"));
            w_p.write("</div></div></td></tr><tr><td><div style=\"clear:both;\">");
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iViewerWidth) + "%" : String.valueOf(this.m_iViewerWidth), strID_p, OwSettingsPropertyWindowPositions.VIEWER_WIDTH, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.width", "Width"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iViewerHeight) + "%" : String.valueOf(this.m_iViewerHeight), strID_p, OwSettingsPropertyWindowPositions.VIEWER_HEIGHT, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.height", "Height"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iViewerTopX) + "%" : String.valueOf(this.m_iViewerTopX), strID_p, OwSettingsPropertyWindowPositions.VIEWER_TOPX, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.topx", "X"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iViewerTopY) + "%" : String.valueOf(this.m_iViewerTopY), strID_p, OwSettingsPropertyWindowPositions.VIEWER_TOPY, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.topy", "Y"), locale_p);
            w_p.write("</div>");
            w_p.write("</td></tr><tr><td>");
            w_p.write("<div class=\"owInlineControls\" style=\"clear:both;\"> ");
            w_p.write("<div class=\"OwPropertyName\" style=\"float:left;\">");
            String booleanMemberDisplayName = OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.mainwindowpos", "Position main window as well");
            OwSettingsPropertyWindowPositions.this.insertLabelValue(w_p, booleanMemberDisplayName, strID_p + OwSettingsPropertyWindowPositions.POSITION_MAIN, 0);
            w_p.write("&nbsp;</div><div style=\"float:left;\">");
            this.writeBooleanMember(w_p, this.m_fWindow, strID_p, OwSettingsPropertyWindowPositions.POSITION_MAIN, locale_p);
            w_p.write("</div></div>");
            w_p.write("</td></tr><tr><td>");
            w_p.write("<div style=\"clear:left;\">");
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iWindowWidth) + "%" : String.valueOf(this.m_iWindowWidth), strID_p, OwSettingsPropertyWindowPositions.MAIN_WIDTH, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.width", "Width"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iWindowHeight) + "%" : String.valueOf(this.m_iWindowHeight), strID_p, OwSettingsPropertyWindowPositions.MAIN_HEIGHT, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.height", "Height"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iWindowTopX) + "%" : String.valueOf(this.m_iWindowTopX), strID_p, OwSettingsPropertyWindowPositions.MAIN_TOPX, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.topx", "X"), locale_p);
            this.writeStringMember(w_p, this.relativePos ? String.valueOf(this.m_iWindowTopY) + "%" : String.valueOf(this.m_iWindowTopY), strID_p, OwSettingsPropertyWindowPositions.MAIN_TOPY, OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyWindowPositions.topy", "Y"), locale_p);
            w_p.write("</div></td></tr></table></div>");
        }

        private void writeStringMember(Writer w_p, String sValue_p, String sBaseID_p, String sName_p, String sDisplayName_p, Locale locale_p) throws IOException {
            w_p.write("<div class=\"OwPropertyName\">");
            OwSettingsPropertyWindowPositions.this.insertLabelValue(w_p, sDisplayName_p, sBaseID_p + sName_p, 0);
            w_p.write("&nbsp;</div><input class=\"OwInputControl\" size=\"3\" name=\"");
            w_p.write(sBaseID_p);
            w_p.write(sName_p);
            w_p.write("\" id=\"");
            w_p.write(sBaseID_p);
            w_p.write(sName_p);
            w_p.write("\" type=\"text\" value=\"");
            w_p.write(sValue_p);
            w_p.write("\">");
        }

        protected void writeBooleanMember(Writer w_p, boolean fValue_p, String strID_p, String sName_p, Locale locale_p) throws Exception {
            String[] values = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
            String[] displayValues = new String[]{OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyBoolean.yes", "Yes"), OwString.localize(locale_p, "settingsimpl.OwSettingsPropertyBoolean.no", "No")};
            OwDefaultComboModel comboModel = new OwDefaultComboModel(false, false, Boolean.toString(fValue_p), values, displayValues);
            OwComboboxRenderer renderer = ((OwMainAppContext)OwSettingsPropertyWindowPositions.this.getContext()).createComboboxRenderer(comboModel, strID_p + sName_p, null, null, null);
            renderer.renderCombo(w_p);
        }

        public OwWindowPositionsImpl createClone() {
            return this;
        }

        private int getSafeIntegerValue(String valueToParse_p, int defaultValue_p) {
            if (valueToParse_p != null) {
                try {
                    return this.getIntegerValue(valueToParse_p);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue_p;
        }

        private int getIntegerValue(String valueToParse_p) throws NumberFormatException {
            if (valueToParse_p.endsWith("%")) {
                return Integer.parseInt(valueToParse_p.substring(0, valueToParse_p.length() - 1));
            }
            return Integer.parseInt(valueToParse_p);
        }

        public void appendNode(Node valueRootNode_p) {
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iViewerWidth, OwSettingsPropertyWindowPositions.VIEWER_WIDTH);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iViewerHeight, OwSettingsPropertyWindowPositions.VIEWER_HEIGHT);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iViewerTopX, OwSettingsPropertyWindowPositions.VIEWER_TOPX);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iViewerTopY, OwSettingsPropertyWindowPositions.VIEWER_TOPY);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iWindowWidth, OwSettingsPropertyWindowPositions.MAIN_WIDTH);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iWindowHeight, OwSettingsPropertyWindowPositions.MAIN_HEIGHT);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iWindowTopX, OwSettingsPropertyWindowPositions.MAIN_TOPX);
            this.appendMemberRelativeHandling(valueRootNode_p, this.m_iWindowTopY, OwSettingsPropertyWindowPositions.MAIN_TOPY);
            this.appendMember(valueRootNode_p, this.m_fWindow ? 1 : 0, OwSettingsPropertyWindowPositions.POSITION_MAIN);
        }

        private void appendMember(Node valueRootNode_p, int value_p, String sName_p) {
            this.appendMember(valueRootNode_p, Integer.toString(value_p), sName_p);
        }

        private void appendMemberRelativeHandling(Node valueRootNode_p, int value_p, String sName_p) {
            if (this.relativePos) {
                this.appendMember(valueRootNode_p, Integer.toString(value_p) + "%", sName_p);
            } else {
                this.appendMember(valueRootNode_p, Integer.toString(value_p), sName_p);
            }
        }

        private void appendMember(Node valueRootNode_p, String value_p, String sName_p) {
            Element n = valueRootNode_p.getOwnerDocument().createElement(sName_p);
            Text v = valueRootNode_p.getOwnerDocument().createTextNode(value_p);
            n.appendChild(v);
            valueRootNode_p.appendChild(n);
        }

        @Override
        public int getViewerWidth() {
            return this.m_iViewerWidth;
        }

        @Override
        public int getViewerHeight() {
            return this.m_iViewerHeight;
        }

        @Override
        public int getViewerTopX() {
            return this.m_iViewerTopX;
        }

        @Override
        public int getViewerTopY() {
            return this.m_iViewerTopY;
        }

        @Override
        public int getWindowWidth() {
            return this.m_iWindowWidth;
        }

        @Override
        public int getWindowHeight() {
            return this.m_iWindowHeight;
        }

        @Override
        public int getWindowTopX() {
            return this.m_iWindowTopX;
        }

        @Override
        public int getWindowTopY() {
            return this.m_iWindowTopY;
        }

        @Override
        public boolean getPositionMainWindow() {
            return this.m_fWindow;
        }

        @Override
        public int getUnits() {
            return this.relativePos ? 1 : 0;
        }
    }
}

