/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.ui.OwAppContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class OwEventTarget {
    private OwAppContext m_Context = null;
    private String m_strTargetID = null;

    protected abstract void init() throws Exception;

    public void attach(OwAppContext context_p, String strName_p) throws Exception {
        this.m_Context = context_p;
        this.m_strTargetID = context_p.registerTarget(this, strName_p);
        this.init();
    }

    public void enableRequestListener() throws OwException {
        this.m_Context.registerRequestTarget(this);
    }

    public void disableRequestListener() throws OwException {
        this.m_Context.unregisterRequestTarget(this);
    }

    public OwAppContext getContext() {
        return this.m_Context;
    }

    public void detach() {
        this.getContext().removeTarget(this);
    }

    public String getID() {
        return this.m_strTargetID;
    }

    public String getEventURL(String strEventName_p, String strAdditionalParameters_p) {
        return this.m_Context.getEventURL(this, strEventName_p, strAdditionalParameters_p);
    }

    public String getAjaxEventURL(String strEventName_p, String strAdditionalParameters_p) {
        return this.m_Context.getAjaxEventURL(this, strEventName_p, strAdditionalParameters_p);
    }

    public String getFormEventURL(String strEventName_p, String strAdditionalParameters_p) {
        return this.m_Context.getFormEventURL(this, strEventName_p, strAdditionalParameters_p, this.getFormName());
    }

    public String getFormEventFunction(String strEventName_p, String strAdditionalParameters_p) {
        return this.m_Context.getFormEventFunction(this, strEventName_p, strAdditionalParameters_p, this.getFormName());
    }

    public String getFormName() {
        return null;
    }

    public void setExternalFormTarget(OwEventTarget eventtarget_p) throws Exception {
        throw new OwInvalidOperationException("OwEventTarget.setExternalFormTarget: Override setFormTarget in your eventtarget.");
    }

    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return true;
    }

    public void onFormEvent(HttpServletRequest request_p) throws Exception {
        if (null != this.getFormTarget()) {
            this.getFormTarget().updateExternalFormTarget(request_p, false);
        }
    }

    public OwEventTarget getFormTarget() {
        return null;
    }

    public boolean onRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        return true;
    }

    public void onExternalRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
    }
}

