/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.ua.OwOSFamily;
import com.wewebu.ow.server.util.OwString;
import java.util.Locale;

public class OwKeyboardDescription {
    private static OwKeyboardDescription instance = null;

    public static synchronized OwKeyboardDescription getInstance() {
        if (instance == null) {
            instance = new OwKeyboardDescription();
        }
        return instance;
    }

    private OwKeyboardDescription() {
    }

    public String getDescription(int keyCode, int ctrlCode, Locale locale, OwOSFamily family) {
        StringBuilder strDescription = new StringBuilder();
        if (ctrlCode != 0) {
            strDescription.append(this.getCtrlDescription(locale, ctrlCode));
            strDescription.append(" + ");
        }
        switch (keyCode) {
            case 45: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_INS", "INS"));
                break;
            }
            case 46: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_DEL", "DEL"));
                break;
            }
            case 36: {
                if (OwOSFamily.OS_X == family) {
                    strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_FN_LEFT", "FN+LEFT"));
                    break;
                }
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_POS1", "POS1"));
                break;
            }
            case 35: {
                if (OwOSFamily.OS_X == family) {
                    strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_FN_RIGHT", "FN+RIGHT"));
                    break;
                }
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_END", "END"));
                break;
            }
            case 27: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_ESC", "ESC"));
                break;
            }
            case 13: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_RETURN", "RETURN"));
                break;
            }
            case 38: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_UP", "UP"));
                break;
            }
            case 40: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_DN", "DOWN"));
                break;
            }
            case 37: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_LEFT", "LEFT"));
                break;
            }
            case 39: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_RIGHT", "RIGHT"));
                break;
            }
            case 33: {
                if (OwOSFamily.OS_X == family) {
                    strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_FN_UP", "FN+UP"));
                    break;
                }
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_PAGE_UP", "PAGE-UP"));
                break;
            }
            case 34: {
                if (OwOSFamily.OS_X == family) {
                    strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_FN_DN", "FN-DN"));
                    break;
                }
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_PAGE_DN", "PAGE-DOWN"));
                break;
            }
            case 32: {
                strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_KEY_SPACE", "' '"));
                break;
            }
            default: {
                if (keyCode >= 112 && keyCode <= 123) {
                    strDescription.append("F");
                    strDescription.append((char)(keyCode - 112 + 49));
                    break;
                }
                if (keyCode < 32 || keyCode == 127 || keyCode == 255) break;
                strDescription.append((char)keyCode);
            }
        }
        return strDescription.toString();
    }

    public String getCtrlDescription(Locale locale, int iCtrlCode) {
        StringBuilder strDescription = new StringBuilder();
        if ((iCtrlCode & 0x100) != 0) {
            strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_CTRLKEY_SHIFT", "SHIFT"));
        }
        if ((iCtrlCode & 0x200) != 0) {
            strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_CTRLKEY_CTRL", "CTRL"));
        }
        if ((iCtrlCode & 0x400) != 0) {
            strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_CTRLKEY_ALT", "ALT"));
        }
        if ((iCtrlCode & 0x800) != 0) {
            strDescription.append(OwString.localize(locale, "app.OwAppContext.KEYBOARD_CTRLKEY_META", "CMD"));
        }
        return strDescription.toString();
    }
}

