/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.OwEventDescription;
import com.wewebu.ow.server.ui.OwKeyboardDescription;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import com.wewebu.ow.server.util.OwString;
import java.util.Locale;

public class OwMouseEventDescription
implements OwEventDescription {
    public static final int MOUSE_NO_CLICK = 0;
    public static final int MOUSE_LEFT_CLICK = 1;
    public static final int MOUSE_RIGHT_CLICK = 2;
    public static final int MOUSE_CLICK = 3;
    private static final OwString[] CLICK_LABELS = new OwString[]{new OwString("OwMouseEventDescription.no.click", "NO CLICK"), new OwString("OwMouseEventDescription.left.click", "LEFT-CLICK"), new OwString("OwMouseEventDescription.right.click", "RIGHT-CLICK"), new OwString("OwMouseEventDescription.click", "CLICK")};
    private int modKeyCode;
    private int modCtrlKey;
    private int clickActionCode;
    private OwString description;

    public OwMouseEventDescription(int modKeyCode, int modCtrlKey, int clickActionCode, OwString description) {
        this.modKeyCode = modKeyCode;
        this.modCtrlKey = modCtrlKey;
        this.clickActionCode = clickActionCode >= 0 && clickActionCode <= 3 ? clickActionCode : 0;
        this.description = description;
    }

    @Override
    public String getEventString(Locale locale, OwOSFamily userAgentFamily) {
        OwKeyboardDescription keyboardDescription = OwKeyboardDescription.getInstance();
        return keyboardDescription.getDescription(this.modKeyCode, this.modCtrlKey, locale, userAgentFamily) + CLICK_LABELS[this.clickActionCode].getString(locale);
    }

    @Override
    public String getDescription(Locale locale, OwOSFamily userAgentFamily) {
        return this.description.getString(locale);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OwMouseEventDescription) {
            OwMouseEventDescription descriptionObj = (OwMouseEventDescription)obj;
            return this.modCtrlKey == descriptionObj.modCtrlKey && this.modKeyCode == descriptionObj.modKeyCode;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.modCtrlKey;
    }
}

