/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.ui.OwMouseAction;
import com.wewebu.ow.server.ui.OwMouseEventDescription;
import com.wewebu.ow.server.ui.OwMouseSetting;
import com.wewebu.ow.server.ui.OwOSFamilyKeyCodeSetting;
import com.wewebu.ow.server.ui.OwOSFamilyMouseAction;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import com.wewebu.ow.server.util.OwString;
import java.util.HashMap;
import java.util.Map;

public class OwOSFamilyMouseSetting
implements OwMouseSetting {
    private String id;
    private Map<OwOSFamily, OwOSFamilyMouseActionCode> osFamilyKeyCodes = new HashMap<OwOSFamily, OwOSFamilyMouseActionCode>();

    public OwOSFamilyMouseSetting(String id, OwOSFamilyMouseActionCode ... mouseCodes) {
        this.id = id;
        for (int i = 0; i < mouseCodes.length; ++i) {
            this.osFamilyKeyCodes.put(mouseCodes[i].osFamily, mouseCodes[i]);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public OwMouseAction createAction(OwString description) {
        return new OwOSFamilyMouseAction(this, description);
    }

    public OwMouseEventDescription createEvent(OwOSFamily osFamily, OwString description) {
        OwOSFamilyMouseActionCode mouseActionCode = this.osFamilyKeyCodes.get((Object)osFamily);
        if (mouseActionCode == null) {
            mouseActionCode = this.osFamilyKeyCodes.get((Object)OwOSFamily.UNKNOWN);
        }
        if (mouseActionCode != null) {
            return new OwMouseEventDescription(mouseActionCode.keyCode.iKeyCode, mouseActionCode.keyCode.iCtrlKey, mouseActionCode.clickActionCode, description);
        }
        return null;
    }

    public static class OwOSFamilyMouseActionCode {
        public final OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode keyCode;
        public final OwOSFamily osFamily;
        public final int clickActionCode;

        public OwOSFamilyMouseActionCode(OwOSFamily osFamily, int keyCode, int ctrlKey, int clickActionCode) {
            this.osFamily = osFamily;
            this.keyCode = new OwOSFamilyKeyCodeSetting.OwOSFamilyKeyCode(osFamily, keyCode, ctrlKey);
            this.clickActionCode = clickActionCode;
        }
    }
}

