/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class OwTreeView
extends OwView {
    private static final Logger LOG = OwLogCore.getLogger(OwTreeView.class);
    public static final String PATH_DELIMITER = "/";
    protected OwTreeViewEventListner m_eventlistner;
    protected String m_strDesignURL;
    protected OwTreeViewNode m_root;
    protected OwTreeViewNode m_selectedNode;
    protected OwTreeViewNode m_focusNode;
    protected String m_strPath = "/";
    protected OwSort childrenSort = null;
    protected static final String NODE_ID_KEY = "node";
    private OwTreeViewFindKeyEventNodes m_finder = null;
    public static final int DISPLAY_MODE_TREE_NODES = 1;
    public static final int DISPLAY_MODE_REGISTER_NODES = 2;
    private int m_displaymode = 1;
    protected Map m_nodeMap;

    protected boolean useFormEventUrls() {
        return this.isFormTargetExternal();
    }

    public void refreshCurrentNode() throws Exception {
        if (null != this.m_selectedNode) {
            this.m_selectedNode.refresh();
        }
    }

    public OwTreeViewNode getCurrentNode() {
        return this.m_selectedNode;
    }

    public void navigateUp() throws Exception {
        OwTreeViewNode parent = this.m_selectedNode.getParent();
        if (parent != null) {
            this.openNode(parent);
        }
    }

    public void navigate(String strPath_p) throws Exception {
        if (this.m_root == null || this.m_root.m_obj == null) {
            throw new OwInvalidOperationException("OwTreeView.navigate: Initialize tree first with the two parameter form of navigate.");
        }
        this.navigate(this.m_root.m_obj, strPath_p);
    }

    public void navigateToId(String nodeId_p) throws Exception {
        if (nodeId_p != null && this.m_nodeMap.containsKey(nodeId_p)) {
            OwTreeViewNode node = (OwTreeViewNode)this.m_nodeMap.get(nodeId_p);
            this.navigate(node.getPath());
        }
    }

    public boolean canNavigate() {
        return this.m_root != null && this.m_root.m_obj != null;
    }

    public void navigate(Object obj_p, String strPath_p) throws Exception {
        if (obj_p == null) {
            this.m_root = null;
            this.m_selectedNode = null;
            this.m_strPath = PATH_DELIMITER;
            return;
        }
        if (strPath_p == null) {
            strPath_p = PATH_DELIMITER;
        }
        if (this.m_root == null || this.m_root.m_obj != obj_p) {
            this.m_nodeMap = new HashMap();
            this.m_root = this.createTreeViewNode(this, obj_p);
            if (this.m_eventlistner != null) {
                this.m_eventlistner.onTreeViewNavigateFolder(this.m_root);
            }
            this.m_root.toggleExpand();
        }
        if (!this.m_strPath.equals(strPath_p)) {
            OwTreeViewNode n = this.m_root.navigate(new StringTokenizer(strPath_p, PATH_DELIMITER));
            if (n != null) {
                this.openNode(n);
            } else {
                this.m_selectedNode = this.m_root;
            }
        } else {
            this.openNode(this.m_root);
        }
    }

    public boolean isEmpty() {
        return this.m_root == null;
    }

    public void setEventListner(OwTreeViewEventListner listner_p) {
        this.m_eventlistner = listner_p;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        if (this.m_root != null) {
            this.renderTree(w_p, this.m_root);
        }
    }

    protected abstract List createChildObjects(Object var1) throws Exception;

    protected String getCloseIconURL(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return this.m_strDesignURL + "/images/OwTreeView/folder_closed.png'";
    }

    protected String getOpenIconURL(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return this.m_strDesignURL + "/images/OwTreeView/folder_open.png'";
    }

    protected String getDisplayName(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return this.getName(obj_p, node_p);
    }

    protected String getDisplayHTML(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return OwHTMLHelper.encodeToSecureHTML(this.getDisplayName(obj_p, node_p));
    }

    public boolean isEnabled(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return true;
    }

    protected abstract String getName(Object var1, OwTreeViewNode var2) throws Exception;

    protected boolean hasPlusMinusIcon(Object obj_p, OwTreeViewNode node_p) throws Exception {
        return node_p.m_fPlusMinusIcon;
    }

    protected OwTreeViewNode createTreeViewNode(OwTreeView treeView_p, Object obj_p) {
        return new OwTreeViewNode(treeView_p, obj_p);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_strDesignURL = this.getContext().getDesignURL();
    }

    public void setDisplayMode(int iMode_p) {
        this.m_displaymode = iMode_p;
    }

    protected int getDisplayMode() {
        return this.m_displaymode;
    }

    private void renderTree(Writer w_p, OwTreeViewNode node_p) throws Exception {
        this.m_finder = new OwTreeViewFindKeyEventNodes();
        switch (this.getDisplayMode()) {
            case 1: {
                this.renderTreeNodesMode(w_p, node_p, 1);
                break;
            }
            case 2: {
                this.renderRegisterNodesMode(w_p, node_p, 1);
                break;
            }
            default: {
                throw new OwInvalidOperationException("OwTreeView.renderTree: Invalid displaymode in OwTreeView, displayMode = " + String.valueOf(this.getDisplayMode()));
            }
        }
        this.m_finder.registerKeyEvents();
        this.m_finder = null;
    }

    private void renderRegisterNodesMode(Writer w_p, OwTreeViewNode node_p, int depth_p) throws Exception {
        Iterator it = node_p.m_childs.iterator();
        w_p.write("<div class='" + this.getRegisterItemStyle() + "'>\n");
        while (it.hasNext()) {
            OwTreeViewNode childNode = (OwTreeViewNode)it.next();
            this.renderRegister(w_p, childNode, depth_p);
        }
        w_p.write("</div>\n");
    }

    private void renderTreeNodesMode(Writer w_p, OwTreeViewNode node_p, int depth_p) throws Exception {
        this.m_finder.checkNode(node_p);
        this.renderNode(w_p, node_p, depth_p);
        if (node_p.m_fCollapsed && depth_p > 1) {
            return;
        }
        for (OwTreeViewNode childNode : node_p.m_childs) {
            this.renderTreeNodesMode(w_p, childNode, depth_p + 1);
        }
    }

    public void renderRegister(Writer writer_p, OwTreeViewNode node_p, int depth_p) throws Exception {
        boolean fSelected = this.isSelected(node_p);
        String folderLabelLink = node_p.getLabelEventURL();
        if (fSelected) {
            writer_p.write("<span class='" + this.getSelectedRegisterItemStyle() + "'>");
        } else {
            writer_p.write("<span class='" + this.getRegisterItemStyle() + "'>");
        }
        if (fSelected) {
            writer_p.write("<a href=\"" + folderLabelLink + "\" class='" + this.getSelectedRegisterItemStyle() + "'>");
        } else {
            writer_p.write("<a href=\"" + folderLabelLink + "\" class='" + this.getRegisterItemStyle() + "'>");
        }
        String displayName = this.addNonBreakingSpaces(node_p.getDisplayName());
        writer_p.write(displayName);
        writer_p.write("</a></span><span width='0' style='font-size:0px;'>\n</span>");
    }

    private String addNonBreakingSpaces(String displayName_p) {
        if (displayName_p.indexOf(" ") < 0) {
            return displayName_p;
        }
        StringTokenizer token = new StringTokenizer(displayName_p);
        StringBuffer sbuffer = new StringBuffer(token.nextToken());
        while (token.hasMoreTokens()) {
            sbuffer.append("&nbsp;");
            sbuffer.append(token.nextToken());
        }
        return sbuffer.toString();
    }

    protected String getSelectedTreeItemStyle() {
        return "OwTreeViewTextSelected";
    }

    protected String getTreeItemStyle() {
        return "OwTreeViewText";
    }

    protected String getSelectedRegisterItemStyle() {
        return "OwRegisterViewTextSelected";
    }

    protected String getRegisterItemStyle() {
        return "OwRegisterViewText";
    }

    public boolean isSelected(OwTreeViewNode node_p) {
        boolean result = false;
        if (this.m_selectedNode != null) {
            result = this.m_selectedNode.equals(node_p);
        }
        return result;
    }

    public boolean isFocused(OwTreeViewNode node_p) {
        return this.m_focusNode == node_p;
    }

    public void renderNode(Writer writer_p, OwTreeViewNode node_p, int depth_p) throws Exception {
        OwTreeViewNode node = node_p;
        boolean fSelected = this.isSelected(node_p);
        boolean fRoot = depth_p == 1;
        try {
            StringWriter nodeBuffer = new StringWriter(30000);
            nodeBuffer.write("\n<table id='OwTreeViewNode_");
            nodeBuffer.write(String.valueOf(node.hashCode()));
            nodeBuffer.write("'><tr>\n");
            for (int i = 2; i < depth_p; ++i) {
                OwTreeViewNode LevelParent = node.getParentFromDepth(depth_p - i);
                if (null != LevelParent && !LevelParent.m_fLastSibling) {
                    nodeBuffer.write("\n<td><img class='OwTreeViewImg' src='" + this.m_strDesignURL + "/images/OwTreeView/vline.gif' alt=''></td>");
                    continue;
                }
                nodeBuffer.write("\n<td><img class='OwTreeViewImg' src='" + this.m_strDesignURL + "/images/OwTreeView/nix.gif' alt=''></td>");
            }
            if (!fRoot) {
                nodeBuffer.write("\n<td>");
                if (node.hasPlusMinusIcon()) {
                    String nodeName = node.getName();
                    if (nodeName == null || nodeName.length() == 0) {
                        throw new OwInvalidOperationException("Invalid or zerolength node name !");
                    }
                    if (!node.isCollapsed()) {
                        this.renderMinusIconLink(nodeBuffer, node);
                    } else {
                        this.renderPlusIconLink(nodeBuffer, node);
                    }
                } else if (!node.isLastSibling()) {
                    nodeBuffer.write("<img class='OwTreeViewImg' src='" + this.m_strDesignURL + "/images/OwTreeView/edge_cross.gif' alt=''/>");
                } else {
                    nodeBuffer.write("<img class='OwTreeViewImg' src='" + this.m_strDesignURL + "/images/OwTreeView/edge.gif' alt=''/>");
                }
                nodeBuffer.write("</td>");
            }
            nodeBuffer.write("\n<td>");
            this.renderFolderIconLink(nodeBuffer, node_p);
            nodeBuffer.write("</td>");
            if (fSelected) {
                nodeBuffer.write("\n<td class=\"" + this.getSelectedTreeItemStyle() + "\">");
            } else {
                nodeBuffer.write("\n<td class=\"" + this.getTreeItemStyle() + "\">");
            }
            this.renderNodeLink(nodeBuffer, node_p);
            nodeBuffer.write("</td>");
            nodeBuffer.write("\n</tr></table>\n");
            writer_p.write(nodeBuffer.getBuffer().toString());
        }
        catch (Exception e) {
            LOG.error((Object)"Could not render tree node !", (Throwable)e);
        }
    }

    protected void renderMinusIconLink(StringWriter nodeBuffer_p, OwTreeViewNode node_p) throws Exception {
        nodeBuffer_p.write("<a id=\"OwTreeView_Minus_");
        nodeBuffer_p.write(node_p.getName());
        nodeBuffer_p.write("\" href=\"");
        nodeBuffer_p.write(node_p.getPlusMinusIconEventURL());
        nodeBuffer_p.write("\">");
        String nodeName = node_p.getDisplayName();
        String tooltip = this.getContext().localize1("app.OwTreeView.collapseitem", "Collapse %1", nodeName);
        if (!node_p.isLastSibling()) {
            nodeBuffer_p.write("<img class=\"OwTreeViewImg\" src=\"");
            nodeBuffer_p.write(this.m_strDesignURL);
            nodeBuffer_p.write("/images/OwTreeView/box_open_cross.gif\"");
            this.writeTooltip(nodeBuffer_p, tooltip);
            nodeBuffer_p.write("/>");
        } else {
            nodeBuffer_p.write("<img class=\"OwTreeViewImg\" src=\"");
            nodeBuffer_p.write(this.m_strDesignURL);
            nodeBuffer_p.write("/images/OwTreeView/box_open.gif\"");
            this.writeTooltip(nodeBuffer_p, tooltip);
            nodeBuffer_p.write("/>");
        }
        nodeBuffer_p.write("</a>");
    }

    protected void writeTooltip(StringWriter nodeBuffer_p, String tooltip_p) {
        nodeBuffer_p.write(" alt=\"");
        nodeBuffer_p.write(tooltip_p);
        nodeBuffer_p.write("\" title=\"");
        nodeBuffer_p.write(tooltip_p);
        nodeBuffer_p.write("\" ");
    }

    protected void renderPlusIconLink(StringWriter nodeBuffer_p, OwTreeViewNode node_p) throws Exception {
        nodeBuffer_p.write("<a id=\"OwTreeView_Plus_");
        nodeBuffer_p.write(node_p.getName());
        nodeBuffer_p.write("\" href=\"");
        nodeBuffer_p.write(node_p.getPlusMinusIconEventURL());
        nodeBuffer_p.write("\">");
        String nodeName = node_p.getDisplayName();
        String tooltip = this.getContext().localize1("app.OwTreeView.expanditem", "Expand %1", nodeName);
        if (!node_p.isLastSibling()) {
            nodeBuffer_p.write("<img class=\"OwTreeViewImg\" src=\"");
            nodeBuffer_p.write(this.m_strDesignURL);
            nodeBuffer_p.write("/images/OwTreeView/box_closed_cross.gif\"");
            this.writeTooltip(nodeBuffer_p, tooltip);
            nodeBuffer_p.write("/>");
        } else {
            nodeBuffer_p.write("<img class=\"OwTreeViewImg\" src=\"");
            nodeBuffer_p.write(this.m_strDesignURL);
            nodeBuffer_p.write("/images/OwTreeView/box_closed.gif\"");
            this.writeTooltip(nodeBuffer_p, tooltip);
            nodeBuffer_p.write("/>");
        }
        nodeBuffer_p.write("</a>");
    }

    protected void renderFolderIconLink(StringWriter nodeBuffer_p, OwTreeViewNode node_p) throws Exception {
        if (node_p.isEnabled()) {
            nodeBuffer_p.write("<a href=\"");
            nodeBuffer_p.write(node_p.getLabelEventURL());
            nodeBuffer_p.write("\">");
        }
        nodeBuffer_p.write("<img class=\"OwTreeViewFolderImg\" src=\"");
        nodeBuffer_p.write(this.isSelected(node_p) ? node_p.getOpenIconURL() : node_p.getCloseIconURL());
        nodeBuffer_p.write("\"");
        String tooltip = "";
        if (node_p.isEnabled()) {
            tooltip = this.isSelected(node_p) ? this.getContext().localize1("app.OwTreeView.itemstatusexpanded", "The item %1 is opened", node_p.getDisplayName()) : this.getContext().localize1("app.OwTreeView.itemstatuscollapsed", "The item %1 is closed", node_p.getDisplayName());
        }
        this.writeTooltip(nodeBuffer_p, tooltip);
        nodeBuffer_p.write(" />");
        if (node_p.isEnabled()) {
            nodeBuffer_p.write("</a>");
        }
    }

    protected void renderNodeLink(StringWriter nodeBuffer_p, OwTreeViewNode node_p) throws Exception {
        if (node_p.isEnabled()) {
            nodeBuffer_p.write("<a href=\"");
            nodeBuffer_p.write(node_p.getLabelEventURL());
            nodeBuffer_p.write("\" class=\"");
            nodeBuffer_p.write(this.isSelected(node_p) ? this.getSelectedTreeItemStyle() : this.getTreeItemStyle());
            nodeBuffer_p.write("\">");
        }
        nodeBuffer_p.write("&nbsp;");
        nodeBuffer_p.write(node_p.getDisplayHTML());
        if (node_p.isEnabled()) {
            nodeBuffer_p.write("</a>");
        }
    }

    protected OwTreeViewNode getNodeFromID(String strID_p) {
        return (OwTreeViewNode)this.m_nodeMap.get(strID_p);
    }

    public void addNode(OwTreeViewNode node_p) {
        this.m_nodeMap.put(node_p.getID(), node_p);
    }

    public void onClickPlusMinus(HttpServletRequest request_p) throws Exception {
        OwTreeViewNode selectedNode;
        String strId = request_p.getParameter(NODE_ID_KEY);
        this.m_focusNode = selectedNode = this.getNodeFromID(strId);
        selectedNode.toggleExpand();
        if (!selectedNode.m_fCollapsed) {
            if (this.m_eventlistner != null) {
                this.m_eventlistner.onTreeViewNavigateFolder(selectedNode);
            }
            this.openNode(selectedNode);
        }
    }

    public void onClickLabel(HttpServletRequest request_p) throws Exception {
        OwTreeViewNode n;
        String strId = request_p.getParameter(NODE_ID_KEY);
        this.m_focusNode = n = this.getNodeFromID(strId);
        this.openNode(n);
    }

    public void openNode(OwTreeViewNode node_p) throws Exception {
        if (!node_p.isEnabled()) {
            return;
        }
        OwTreeViewNode previousNode = this.m_selectedNode;
        this.m_selectedNode = node_p;
        if (this.m_eventlistner != null) {
            try {
                this.m_eventlistner.onTreeViewOpenFolder(node_p);
            }
            catch (Exception e) {
                this.m_selectedNode = previousNode;
                LOG.error((Object)"OwTreeView.openNode(): Error trying to opening the selected node.", (Throwable)e);
                throw e;
            }
        }
    }

    public String getClientSideId() {
        return "OwTreeView_" + this.hashCode();
    }

    public void navigateToChild(Object theObject_p) throws Exception {
        OwTreeViewNode correspondingNode = this.getNodeForObject(theObject_p);
        if (correspondingNode == null) {
            this.expandParents(theObject_p);
            correspondingNode = this.getNodeForObject(theObject_p);
        }
        if (correspondingNode != null) {
            if (this.m_selectedNode != null) {
                this.m_selectedNode.refresh();
            }
            this.m_focusNode = correspondingNode;
            for (OwTreeViewNode parent = correspondingNode.getParent(); parent != null && parent.isCollapsed(); parent = parent.getParent()) {
                parent.expand();
            }
            correspondingNode.expand();
            String path = correspondingNode.getPath();
            if (path != null) {
                this.navigate(path);
            }
        } else {
            this.clearSelection();
        }
    }

    protected abstract void expandParents(Object var1) throws Exception;

    protected OwTreeViewNode getNodeForObject(Object theObject_p) {
        Iterator nodesIterator = this.m_nodeMap.values().iterator();
        OwTreeViewNode correspondingNode = null;
        while (nodesIterator.hasNext()) {
            OwTreeViewNode node = (OwTreeViewNode)nodesIterator.next();
            if (!node.getObject().equals(theObject_p)) continue;
            correspondingNode = node;
            break;
        }
        return correspondingNode;
    }

    public void clearSelection() {
        this.m_selectedNode = null;
    }

    public void setChildrenSort(OwSort childrenSort_p) {
        this.childrenSort = childrenSort_p;
    }

    public OwSort getChildrenSort() {
        return this.childrenSort;
    }

    public void refreshNodeForObject(Object param_p) throws Exception {
        OwTreeViewNode node = this.getNodeForObject(param_p);
        if (null != node) {
            node.refresh();
        }
    }

    private class OwTreeViewFindKeyEventNodes {
        public OwTreeViewNode m_nodeBeforeSelected = null;
        public OwTreeViewNode m_nodeAfterSelected = null;
        public OwTreeViewNode m_oldnode = null;
        public boolean m_fPassedSelectedNode = false;

        private OwTreeViewFindKeyEventNodes() {
        }

        public void checkNode(OwTreeViewNode node_p) throws Exception {
            if (this.m_fPassedSelectedNode && this.m_nodeAfterSelected == null) {
                this.m_nodeAfterSelected = node_p;
            }
            if (OwTreeView.this.isSelected(node_p)) {
                this.m_fPassedSelectedNode = true;
                this.m_nodeBeforeSelected = this.m_oldnode;
                OwTreeView.this.getContext().registerKeyEvent(39, 1024, node_p.getPlusMinusIconEventURL(), node_p.getDisplayName());
                OwTreeView.this.getContext().registerKeyEvent(37, 1024, node_p.getPlusMinusIconEventURL(), node_p.getDisplayName());
            }
            this.m_oldnode = node_p;
        }

        public void registerKeyEvents() throws Exception {
            if (this.m_nodeAfterSelected != null) {
                OwTreeView.this.getContext().registerKeyEvent(40, 1024, this.m_nodeAfterSelected.getLabelEventURL(), this.m_nodeAfterSelected.getDisplayName());
            }
            if (this.m_nodeBeforeSelected != null) {
                OwTreeView.this.getContext().registerKeyEvent(38, 1024, this.m_nodeBeforeSelected.getLabelEventURL(), this.m_nodeBeforeSelected.getDisplayName());
            }
        }
    }

    public static interface OwTreeViewEventListner
    extends EventListener {
        public void onTreeViewOpenFolder(OwTreeViewNode var1) throws Exception;

        public void onTreeViewNavigateFolder(OwTreeViewNode var1) throws Exception;
    }

    public class OwTreeViewNode {
        protected OwTreeView m_view;
        protected boolean m_fLastSibling = true;
        protected boolean m_fFirstSibling = true;
        protected String m_path;
        protected String m_displaypath;
        protected boolean m_fChildsCreated = false;
        protected boolean m_fPlusMinusIcon = true;
        protected String m_strOpenFolderURL;
        protected String m_strCloseFolderURL;
        protected OwTreeViewNode m_parent;
        protected boolean m_fCollapsed = true;
        protected List m_childs = new ArrayList();
        protected Object m_obj;

        public OwTreeViewNode(OwTreeView treeView_p, Object obj_p) {
            this.m_view = treeView_p;
            this.m_obj = obj_p;
            this.m_view.addNode(this);
            this.m_path = OwTreeView.PATH_DELIMITER;
            this.m_displaypath = OwTreeView.PATH_DELIMITER;
        }

        public Object getObject() {
            return this.m_obj;
        }

        public String getLabelEventURL() {
            if (OwTreeView.this.useFormEventUrls()) {
                return this.m_view.getFormEventURL("ClickLabel", "node=" + this.getID());
            }
            return this.m_view.getEventURL("ClickLabel", "node=" + this.getID());
        }

        public String getPlusMinusIconEventURL() {
            if (OwTreeView.this.useFormEventUrls()) {
                return this.m_view.getFormEventURL("ClickPlusMinus", "node=" + this.getID());
            }
            return this.m_view.getEventURL("ClickPlusMinus", "node=" + this.getID());
        }

        public OwTreeViewNode getParentFromDepth(int iLevel_p) {
            if (iLevel_p < 1) {
                return this;
            }
            if (null == this.m_parent) {
                return null;
            }
            return this.m_parent.getParentFromDepth(iLevel_p - 1);
        }

        public OwTreeViewNode getParent() {
            return this.m_parent;
        }

        public Object getObjectParent() {
            OwTreeViewNode theParent = this.getParent();
            if (theParent != null) {
                return theParent.m_obj;
            }
            return null;
        }

        public String getID() {
            return String.valueOf(this.hashCode());
        }

        public String getCloseIconURL() throws Exception {
            if (this.m_strCloseFolderURL == null) {
                this.m_strCloseFolderURL = this.m_view.getCloseIconURL(this.m_obj, this);
            }
            return this.m_strCloseFolderURL;
        }

        public String getOpenIconURL() throws Exception {
            if (this.m_strOpenFolderURL == null) {
                this.m_strOpenFolderURL = this.m_view.getOpenIconURL(this.m_obj, this);
            }
            return this.m_strOpenFolderURL;
        }

        public String getDisplayName() throws Exception {
            return this.m_view.getDisplayName(this.m_obj, this);
        }

        public String getDisplayHTML() throws Exception {
            return this.m_view.getDisplayHTML(this.m_obj, this);
        }

        public boolean isEnabled() throws Exception {
            return this.m_view.isEnabled(this.m_obj, this);
        }

        public String getName() throws Exception {
            return this.m_view.getName(this.m_obj, this);
        }

        public boolean hasPlusMinusIcon() throws Exception {
            return this.m_view.hasPlusMinusIcon(this.m_obj, this);
        }

        public void toggleExpand() throws Exception {
            if (this.m_fCollapsed && !this.m_fChildsCreated) {
                this.createChilds();
                this.m_fChildsCreated = true;
            }
            this.m_fCollapsed = !this.m_fCollapsed;
        }

        public void expand() throws Exception {
            this.m_fCollapsed = false;
            this.createChilds();
            this.m_fChildsCreated = true;
        }

        protected void createChilds() throws Exception {
            this.m_childs.clear();
            List childObjects = this.m_view.createChildObjects(this.m_obj);
            if (childObjects != null) {
                for (int i = 0; i < childObjects.size(); ++i) {
                    OwTreeViewNode newChild = this.m_view.createTreeViewNode(this.m_view, childObjects.get(i));
                    newChild.m_parent = this;
                    newChild.m_path = this.m_path + newChild.getName() + OwTreeView.PATH_DELIMITER;
                    newChild.m_displaypath = this.m_displaypath + newChild.getDisplayName() + OwTreeView.PATH_DELIMITER;
                    newChild.m_fLastSibling = i >= childObjects.size() - 1;
                    newChild.m_fFirstSibling = i == 0;
                    this.m_childs.add(newChild);
                }
            }
            this.m_fPlusMinusIcon = this.m_childs.size() != 0;
        }

        protected void refresh() throws Exception {
            if (this.m_fChildsCreated) {
                this.createChilds();
            }
        }

        protected OwTreeViewNode navigate(StringTokenizer pathtokens_p) throws Exception {
            if (!pathtokens_p.hasMoreTokens()) {
                return this;
            }
            if (this.m_fCollapsed) {
                this.toggleExpand();
            }
            String strToken = pathtokens_p.nextToken();
            for (int i = 0; i < this.m_childs.size(); ++i) {
                OwTreeViewNode node = (OwTreeViewNode)this.m_childs.get(i);
                String strName = node.getName();
                if (!strName.equals(strToken)) continue;
                return node.navigate(pathtokens_p);
            }
            return null;
        }

        public boolean equals(Object otherObject_p) {
            boolean result = false;
            if (otherObject_p instanceof OwTreeViewNode) {
                OwTreeViewNode theNode = (OwTreeViewNode)otherObject_p;
                if (this.m_obj != null) {
                    result = this.m_obj.equals(theNode.m_obj);
                    if (result && this.m_parent != null) {
                        result = this.m_parent.equals(theNode.m_parent);
                    }
                    if (result && this.m_path != null && theNode.m_path != null) {
                        result = this.m_path.equals(theNode.m_path);
                    }
                } else {
                    result = super.equals(otherObject_p);
                }
            }
            return result;
        }

        public int hashCode() {
            int result = super.hashCode();
            if (this.m_obj != null) {
                result = this.m_obj.hashCode();
            }
            return result;
        }

        public String getDisplayPath() {
            return this.m_displaypath;
        }

        public String getPath() {
            return this.m_path;
        }

        public boolean isCollapsed() {
            return this.m_fCollapsed;
        }

        public boolean isLastSibling() {
            return this.m_fLastSibling;
        }

        public boolean isFirstSibling() {
            return this.m_fFirstSibling;
        }
    }
}

