/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwDataSourceException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class OwDataSourceUtil {
    public static DataSource retrieveDataSource(String dataSourceName) throws OwDataSourceException {
        try {
            InitialContext ic = new InitialContext();
            try {
                Context envCtx = (Context)ic.lookup("java:comp/env");
                return (DataSource)envCtx.lookup(dataSourceName);
            }
            catch (NameNotFoundException e) {
                return (DataSource)ic.lookup(dataSourceName);
            }
        }
        catch (NamingException ex) {
            String msg = "OwDataSourceUtil.retrieveDataSource: Could not retrieve DataSource by name/id=" + dataSourceName;
            throw new OwDataSourceException(msg, (Throwable)ex);
        }
    }

    public static JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    public static JdbcTemplate createJdbcTemplateFromId(String jndiName) throws OwDataSourceException {
        DataSource dataSrc = OwDataSourceUtil.retrieveDataSource(jndiName);
        return OwDataSourceUtil.createJdbcTemplate(dataSrc);
    }
}

