/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.servlet.ServletException;

public class OwExceptionManager {
    public static final String OWEXCEPTION_ELEMENT_ID = "owexceptiondetails";

    public static String getExceptionDisplayText(Throwable e_p) {
        return e_p.getLocalizedMessage();
    }

    public static void PrintCatchedException(Locale locale_p, Throwable e_p, PrintWriter w_p, String strStyleClassName_p) {
        OwExceptionManager.PrintCatchedException(locale_p, e_p, w_p, strStyleClassName_p, OWEXCEPTION_ELEMENT_ID);
    }

    public static void PrintCatchedException(Locale locale_p, Throwable e_p, PrintWriter w_p, String strStyleClassName_p, String elementId_p) {
        if (elementId_p == null) {
            elementId_p = OWEXCEPTION_ELEMENT_ID;
        }
        if (e_p != null && w_p != null) {
            String messagePrefix;
            String strMessage = "";
            String strModulName = "";
            Throwable rootCause = null;
            if (e_p instanceof OwException) {
                strModulName = ((OwException)e_p).getModulName();
                strMessage = ((OwException)e_p).getMessage(locale_p);
            } else if (e_p instanceof InvocationTargetException) {
                InvocationTargetException ite;
                Throwable targetException = ite;
                for (ite = (InvocationTargetException)e_p; ite != null && ite.getMessage() == null && (targetException = ite.getTargetException()) instanceof InvocationTargetException; ite = (InvocationTargetException)ite.getTargetException()) {
                }
                if (targetException != null) {
                    if (targetException instanceof OwException) {
                        strModulName = ((OwException)targetException).getModulName();
                        strMessage = ((OwException)targetException).getMessage(locale_p);
                    } else {
                        strMessage = targetException.getLocalizedMessage();
                        if (strMessage == null || strMessage.length() == 0) {
                            strMessage = targetException.getMessage();
                        }
                    }
                } else {
                    strMessage = e_p.getLocalizedMessage();
                    if (strMessage == null || strMessage.length() == 0) {
                        strMessage = e_p.getMessage();
                    }
                }
            } else if (e_p instanceof ServletException) {
                strModulName = "JSP/Servlet Rendering Exception";
                strMessage = e_p.getLocalizedMessage();
                if (strMessage == null || strMessage.length() == 0) {
                    strMessage = e_p.getMessage();
                }
                rootCause = ((ServletException)e_p).getRootCause();
            } else {
                strMessage = e_p.getLocalizedMessage();
                if (strMessage == null || strMessage.length() == 0) {
                    strMessage = e_p.getMessage();
                }
            }
            if (strMessage == null) {
                strMessage = OwString.localize(locale_p, "util.OwExceptionManager.unknownerror", "An unknown error occurred.");
            }
            if ((messagePrefix = new OwString("app.OwUILoginModul.error", "Error:").getString(locale_p)) != null) {
                strMessage = messagePrefix + " " + strMessage;
            }
            String toolTipMessage = OwString.localize(locale_p, "util.OwExceptionManager.TooltipForErrorLink", "Click here in order to display a detailed error message.");
            boolean oldStyle = true;
            if (oldStyle) {
                strModulName = OwString.localize1(locale_p, "util.OwExceptionManager.sourcemodul", "Error Source: %1", strModulName);
                w_p.write("\n<a title='" + toolTipMessage + "' href=\"javascript:toggleElementDisplay('" + elementId_p + "');\" class='" + strStyleClassName_p + "'>");
                try {
                    OwHTMLHelper.writeSecureHTML(w_p, strMessage);
                }
                catch (IOException e) {
                    w_p.write(strMessage);
                }
                w_p.write("</a>");
                w_p.write("\n<pre id='" + elementId_p + "' style='display: none;' class='" + strStyleClassName_p + "'>");
                w_p.write(strModulName + "<br>\n");
                e_p.printStackTrace(w_p);
                while (rootCause != null) {
                    w_p.write("<br><br><b>Root Cause:</b><br><br>\n");
                    rootCause.printStackTrace(w_p);
                    if (!(rootCause instanceof ServletException)) break;
                    rootCause = ((ServletException)rootCause).getRootCause();
                }
                w_p.write("\n</pre>");
            } else {
                strModulName = OwString.localize1(locale_p, "util.OwExceptionManager.sourcemodul", "Error Source: %1", strModulName);
                w_p.write("\n<a title='" + toolTipMessage + "' href=\"javascript:toggleElementDisplay('" + elementId_p + "');\" class='" + strStyleClassName_p + "'>");
                try {
                    OwHTMLHelper.writeSecureHTML(w_p, strMessage);
                }
                catch (IOException e) {
                    w_p.write(strMessage);
                }
                w_p.write("</a>");
                w_p.write("\n<pre id='" + elementId_p + "' style='display: none;' class='" + strStyleClassName_p + "'>");
                w_p.write("\n<a title='" + toolTipMessage + "' href=\"javascript:toggleElementDisplay('" + elementId_p + "_full');\"> " + strModulName + " (click here to display the full error StackTrace)</a>");
                w_p.write("\n<pre id='" + elementId_p + "_full' style='display: none;' class='" + strStyleClassName_p + "'>");
                e_p.printStackTrace(w_p);
                while (rootCause != null) {
                    w_p.write("<br><br><b>Root Cause:</b><br><br>\n");
                    rootCause.printStackTrace(w_p);
                    if (!(rootCause instanceof ServletException)) break;
                    rootCause = ((ServletException)rootCause).getRootCause();
                }
                w_p.write("\n</pre>");
                w_p.write("\n<br><br>");
                int i = 0;
                w_p.write(" Error caused by:");
                while (e_p != null) {
                    String message = e_p.getLocalizedMessage();
                    if (message == null && (message = e_p.getMessage()) == null) {
                        message = e_p.toString();
                    }
                    w_p.write("\n<a title='" + toolTipMessage + "' href=\"javascript:toggleElementDisplay('" + elementId_p + "" + i + "');\" class='" + strStyleClassName_p + "'> -> " + message + "</a>");
                    w_p.write("\n<pre id='" + elementId_p + "" + i + "' style='display: none;' class='" + strStyleClassName_p + "'>");
                    e_p.printStackTrace(w_p);
                    w_p.write("\n</pre>");
                    ++i;
                    e_p = e_p.getCause();
                }
                w_p.write("\n</pre>");
            }
        }
    }

    public static String getLocalizedMessage(Throwable e_p, Locale locale_p) {
        String messagePrefix;
        String message = null;
        Throwable msgException = e_p;
        if (e_p instanceof InvocationTargetException) {
            InvocationTargetException ite;
            Throwable targetException = ite = (InvocationTargetException)e_p;
            while (ite != null && ite.getMessage() == null && (targetException = ite.getTargetException()) instanceof InvocationTargetException) {
                ite = (InvocationTargetException)ite.getTargetException();
            }
            if (targetException != null) {
                msgException = targetException;
            }
        }
        if (msgException != null) {
            if (msgException instanceof OwException) {
                message = ((OwException)msgException).getMessage(locale_p);
            } else {
                message = msgException.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = msgException.getMessage();
                }
            }
        }
        if (message == null) {
            message = OwString.localize(locale_p, "util.OwExceptionManager.unknownerror", "An unknown error occurred.");
        }
        if ((messagePrefix = new OwString("app.OwUILoginModul.error", "Error:").getString(locale_p)) != null) {
            message = messagePrefix + " " + message;
        }
        return OwHTMLHelper.encodeJavascriptString(message, true);
    }

    public static String getRelevantStackTrace(Throwable e_p) {
        StringWriter result = new StringWriter();
        Throwable theThrowable = e_p;
        Throwable theRootCause = null;
        if (theThrowable instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)theThrowable;
            while (ite.getTargetException() != null && ite.getTargetException() instanceof InvocationTargetException) {
                ite = (InvocationTargetException)ite.getTargetException();
            }
            theThrowable = ite;
        } else if (theThrowable instanceof ServletException) {
            theRootCause = ((ServletException)theThrowable).getRootCause();
        }
        if (theThrowable != null) {
            theThrowable.printStackTrace(new PrintWriter(result));
        }
        if (theRootCause != null) {
            result.write("<br>root cause: <br>");
            theRootCause.printStackTrace(new PrintWriter(result));
        }
        return OwHTMLHelper.encodeJavascriptString(result.toString());
    }
}

