/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OwHTMLHelper {
    private static final Map<Character, String> JS_UNICODE_ESCAPES = new HashMap<Character, String>();
    private static final Map<Character, String> JS_BS_ESCAPES = new HashMap<Character, String>();

    private static String toUnicode(char c_p) {
        char[] hexCode = new char[4];
        Arrays.fill(hexCode, '0');
        String hexValue = Integer.toHexString(c_p);
        int hexValueLen = hexValue.length();
        hexValue.getChars(0, hexValueLen, hexCode, 4 - hexValueLen);
        return new String(hexCode);
    }

    public static String encodeToSecureHTML(String sText_p) throws IOException {
        StringWriter stringWriter = new StringWriter();
        OwHTMLHelper.writeSecureHTML(stringWriter, sText_p, false);
        String secureHTML = stringWriter.toString();
        stringWriter.flush();
        stringWriter.close();
        return secureHTML;
    }

    public static void writeSecureHTML(Writer w_p, String sText_p) throws IOException {
        OwHTMLHelper.writeSecureHTML(w_p, sText_p, false);
    }

    public static void writeSecureHTML(Writer w_p, String sText_p, boolean encodeEnter_p) throws IOException {
        if (sText_p != null && w_p != null) {
            block7: for (int i = 0; i < sText_p.length(); ++i) {
                char c = sText_p.charAt(i);
                if (c == '\n' && encodeEnter_p) {
                    w_p.write("<br>");
                    continue;
                }
                switch (c) {
                    case '&': {
                        if (i + 1 < sText_p.length() && sText_p.charAt(i + 1) == '#') {
                            w_p.write(c);
                            continue block7;
                        }
                        w_p.write("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        w_p.write("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        w_p.write("&#39;");
                        continue block7;
                    }
                    case '<': {
                        w_p.write("&#60;");
                        continue block7;
                    }
                    case '>': {
                        w_p.write("&#62;");
                        continue block7;
                    }
                    default: {
                        w_p.write(c);
                    }
                }
            }
        }
    }

    public static String encodeJavascriptString(String in_p) {
        return OwHTMLHelper.encodeJavascriptString(in_p, false);
    }

    public static String encodeJavascriptVariableName(String input_p) {
        String partialResult = OwHTMLHelper.encodeJavascriptString(input_p);
        return partialResult.replace('-', '_');
    }

    public static String encodeJavascriptString(String in_p, boolean useUnicodeEscapes_p) {
        if (null == in_p) {
            return null;
        }
        Map<Character, String> escapes = useUnicodeEscapes_p ? JS_UNICODE_ESCAPES : JS_BS_ESCAPES;
        String scriptEndTag = "</script>";
        StringBuffer sb = new StringBuffer();
        int scriptEndTagMatch = 0;
        for (int i = 0; i < in_p.length(); ++i) {
            char c = in_p.charAt(i);
            char lowerC = Character.toLowerCase(c);
            if (lowerC == "</script>".charAt(scriptEndTagMatch)) {
                if (++scriptEndTagMatch == "</script>".length()) {
                    sb.append("\\u" + OwHTMLHelper.toUnicode(c));
                    scriptEndTagMatch = 0;
                    continue;
                }
                sb.append(c);
                continue;
            }
            scriptEndTagMatch = 0;
            String escape = escapes.get(Character.valueOf(c));
            if (escape != null) {
                sb.append(escape);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        JS_BS_ESCAPES.put(Character.valueOf('\\'), "\\\\");
        JS_BS_ESCAPES.put(Character.valueOf('\b'), "\\b");
        JS_BS_ESCAPES.put(Character.valueOf('\f'), "\\f");
        JS_BS_ESCAPES.put(Character.valueOf('\n'), "\\n");
        JS_BS_ESCAPES.put(Character.valueOf('\r'), "\\r");
        JS_BS_ESCAPES.put(Character.valueOf('\r'), "\\r");
        JS_BS_ESCAPES.put(Character.valueOf('\t'), "\\t");
        JS_BS_ESCAPES.put(Character.valueOf('\"'), "\\\"");
        JS_BS_ESCAPES.put(Character.valueOf('\''), "\\'");
        JS_BS_ESCAPES.put(Character.valueOf('%'), "\\u" + OwHTMLHelper.toUnicode('%'));
        Set<Character> characters = JS_BS_ESCAPES.keySet();
        for (Character c : characters) {
            JS_UNICODE_ESCAPES.put(c, "\\u" + OwHTMLHelper.toUnicode(c.charValue()));
        }
    }
}

