/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAuthenticationConfiguration;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class OwNetworkConfiguration {
    public static final String EL_OBJECT_CLASS = "ObjectClass";
    public static final String EL_CREATION_INITIAL_VALUES = "CreationInitialValues";
    public static final String EL_PREFERREDPROPERTYTYPE = "PreferredPropertyType";
    public static final String EL_PROPERTY = "Property";
    public static final String EL_OWAPPLICATIONOBJECTBASEDIR = "OwApplicationObjectBaseDir";
    public static final String EL_VIRTUALFOLDERSCONTAINER = "VirtualFoldersContainer";
    public static final String EL_AUTHENTICATION = "Authentication";
    private static final Logger LOG = OwLogCore.getLogger(OwNetworkConfiguration.class);
    private OwXMLUtil config;
    private Map<String, OwStandardXMLUtil> m_CreateionInitialValuesConfigMap;

    public OwNetworkConfiguration(OwXMLUtil config) {
        this.config = config;
    }

    private Map<String, OwStandardXMLUtil> getCreationInitialValuesConfigMap() {
        if (this.m_CreateionInitialValuesConfigMap == null) {
            this.m_CreateionInitialValuesConfigMap = new HashMap<String, OwStandardXMLUtil>();
            List civSubnodes = this.getConfigNode().getSafeNodeList(EL_CREATION_INITIAL_VALUES);
            for (Element objectClassConfigElem : civSubnodes) {
                String className = OwXMLDOMUtil.getSafeStringAttributeValue(objectClassConfigElem, "name", null);
                if (!objectClassConfigElem.getTagName().equals(EL_OBJECT_CLASS) || className == null) continue;
                try {
                    this.m_CreateionInitialValuesConfigMap.put(className, new OwStandardXMLUtil(objectClassConfigElem));
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot create OwStandardXMLUtil for CreateionInitialValuesConfigMap.", (Throwable)e);
                }
            }
        }
        return this.m_CreateionInitialValuesConfigMap;
    }

    public OwXMLUtil getCreationInitialValuesConfig(String objectClassName_p) {
        Map<String, OwStandardXMLUtil> civcm = this.getCreationInitialValuesConfigMap();
        if (civcm != null) {
            return civcm.get(objectClassName_p);
        }
        return null;
    }

    public OwXMLUtil getConfigNode() {
        return this.config;
    }

    public String getApplicationObjectBaseDir(String defaultLocation_p) {
        return this.config.getSafeTextValue(EL_OWAPPLICATIONOBJECTBASEDIR, defaultLocation_p);
    }

    public String getVirtualFoldersContainer(String defaultContainer_p) {
        return this.config.getSafeTextValue(EL_VIRTUALFOLDERSCONTAINER, defaultContainer_p);
    }

    public OwAuthenticationConfiguration getAuthenticationConfiguration() {
        OwXMLUtil util = null;
        try {
            util = this.getConfigNode().getSubUtil(EL_AUTHENTICATION);
        }
        catch (Exception e) {
            String msg = "Could not find/retrieve \"Authentication\" configuration.";
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)msg, (Throwable)e);
            }
            LOG.warn((Object)msg);
        }
        if (util != null) {
            return new OwAuthenticationConfiguration(util);
        }
        return null;
    }
}

