/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwSecretKey;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;

public class OwSecretEncryption {
    private static final Logger LOG = OwLogCore.getLogger(OwSecretEncryption.class);
    private static volatile OwSecretKey m_key = new OwSecretKey();

    public static String bytesToString(byte[] bytes_p) {
        char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes_p.length; ++i) {
            byte lownibble = (byte)(bytes_p[i] & 0xF);
            byte highnibble = (byte)((bytes_p[i] & 0xF0) >> 4);
            result.append(hexdigits[highnibble]);
            result.append(hexdigits[lownibble]);
        }
        return result.toString();
    }

    public static byte[] stringToBytes(String text_p) throws OwInvalidOperationException {
        if (text_p.length() % 2 != 0) {
            return new byte[0];
        }
        byte[] result = new byte[text_p.length() / 2];
        for (int i = 0; i < text_p.length(); i += 2) {
            try {
                int irep = Integer.parseInt(text_p.substring(i, i + 2), 16);
                if (irep > 127) {
                    irep -= 256;
                }
                result[i / 2] = Integer.valueOf(irep).byteValue();
                continue;
            }
            catch (Exception e) {
                String msg = "Encrypt failed, cannot convert the string to byte[], maybe contains invalid characters...";
                LOG.debug((Object)msg, (Throwable)e);
                throw new OwInvalidOperationException(msg, (Throwable)e);
            }
        }
        return result;
    }

    public static byte[] encrypt(String text_p) throws OwInvalidOperationException {
        return OwSecretEncryption.encrypt(text_p.getBytes());
    }

    public static byte[] encrypt(byte[] bytes_p) throws OwInvalidOperationException {
        try {
            Cipher c = m_key.getCipher();
            c.init(1, m_key.getKey());
            byte[] enc = c.doFinal(bytes_p);
            return enc;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.error((Object)"Encrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Encrypt failed", (Throwable)e);
        }
    }

    public static String decryptToString(byte[] encrypted_p, String format_p) throws OwInvalidOperationException, UnsupportedEncodingException {
        byte[] dec = OwSecretEncryption.decrypt(encrypted_p);
        return new String(dec, format_p);
    }

    public static String decryptToString(byte[] encrypted_p) throws OwInvalidOperationException {
        try {
            return OwSecretEncryption.decryptToString(encrypted_p, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Decrypt failed";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] encrypted_p) throws OwInvalidOperationException {
        try {
            Cipher c = m_key.getCipher();
            c.init(2, m_key.getKey());
            byte[] dec = c.doFinal(encrypted_p);
            return dec;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
        catch (IllegalStateException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.error((Object)"Decrypt failed", (Throwable)e);
            throw new OwInvalidOperationException("Decrypt failed", (Throwable)e);
        }
    }
}

