/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.exceptions.OwDataSourceException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardDBAttributeBagWriteable;
import com.wewebu.ow.server.util.OwTableSpec;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;

public class OwStandardDBAttributeBagWriteableFactory {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardDBAttributeBagWriteableFactory.class);
    private static final String SITE_USER_NAME = "OW_SITE_USER";
    public static final String ATTRIBUTE_INDEX = "ID";
    public static final String ATTRIBUTE_USER = "UserName";
    public static final String ATTRIBUTE_BAGNAME = "BagName";
    public static final String ATTRIBUTE_ATTR_NAME = "AttributeName";
    public static final String ATTRIBUTE_ATTR_VALUE = "AttributeValue";
    public static final String SEQUENCE_NAME = "OW_ATTRIBUTE_BAG_SEQ";
    public static final int LENGTH_LIMIT_ATTRIBUTE_NAME = 128;
    public static final int LENGTH_LIMIT_BAG_NAME = 128;
    public static final int LENGTH_LIMIT_ATTRIBUTE_VALUE = 1024;
    private static final String MAP_KEY_DELIMITER = ":";
    private JdbcTemplate m_jdbcTemplate;
    private String m_user;
    private String m_table;
    OwTableSpec attributeBagTable;
    private String catalogSeparator;
    private Map<String, OwAttribute> m_attributes;
    private List<OwAttribute> m_deletedAttributes;
    private int bagName;
    private int attName;
    private int attValue;
    private OwPreparedStatementCreator creator;

    public OwStandardDBAttributeBagWriteableFactory(JdbcTemplate jdbcTemplate_p, String strUser_p, String strTable_p) throws OwDataSourceException {
        this.m_jdbcTemplate = jdbcTemplate_p;
        if (this.m_jdbcTemplate == null) {
            String msg = "OwStandardDBAttributeBagWriteableFactory is not been initialized with a DB, it cannot be used,  m_jdbcTemplate == null.";
            throw new OwDataSourceException(msg);
        }
        this.m_table = strTable_p;
        this.m_user = strUser_p == null ? SITE_USER_NAME : strUser_p;
        this.m_attributes = new HashMap<String, OwAttribute>();
        this.m_deletedAttributes = new LinkedList<OwAttribute>();
        this.bagName = 128;
        this.attName = 128;
        this.attValue = 1024;
    }

    public OwStandardDBAttributeBagWriteableFactory(JdbcTemplate jdbc, String userID, OwTableSpec attributeBagTable) throws OwDataSourceException {
        this(jdbc, userID, attributeBagTable.getTableName());
        this.attributeBagTable = attributeBagTable;
        Connection connection = null;
        try {
            connection = this.m_jdbcTemplate.getDataSource().getConnection();
            this.catalogSeparator = connection.getMetaData().getCatalogSeparator();
            if (this.catalogSeparator.isEmpty()) {
                this.catalogSeparator = ".";
            }
        }
        catch (SQLException e) {
            throw new OwDataSourceException("DBAttributeBag initialisation error, cannot read the DB metadata.", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Could not close connection.", (Throwable)e);
                }
                connection = null;
            }
        }
    }

    public void init() throws Exception {
        StringBuilder statement = new StringBuilder("select ").append(ATTRIBUTE_USER).append(",").append(ATTRIBUTE_BAGNAME).append(",");
        statement.append(ATTRIBUTE_ATTR_NAME).append(",").append(ATTRIBUTE_ATTR_VALUE).append(" from ").append(this.getTableName()).append(" where ");
        statement.append(ATTRIBUTE_USER).append(" = ?");
        Object[] params = new Object[]{this.m_user};
        this.m_jdbcTemplate.query(statement.toString(), params, new RowCallbackHandler(){

            public void processRow(ResultSet rs_p) throws SQLException {
                String attrName = rs_p.getString(OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_NAME);
                String attrValue = rs_p.getString(OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_VALUE);
                String bagName = rs_p.getString(OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_BAGNAME);
                OwStandardDBAttributeBagWriteableFactory.this.m_attributes.put(bagName + OwStandardDBAttributeBagWriteableFactory.MAP_KEY_DELIMITER + attrName, new OwAttribute(0, bagName, attrName, attrValue));
            }
        });
        this.initColumnLimit();
        this.creator = this.createStatementCreator();
    }

    protected void initColumnLimit() throws SQLException {
        Connection con = null;
        try {
            con = this.m_jdbcTemplate.getDataSource().getConnection();
            DatabaseMetaData meta = con.getMetaData();
            ResultSet resultSet = null;
            resultSet = null == this.attributeBagTable ? meta.getColumns(null, null, this.getTableName(), null) : meta.getColumns(this.attributeBagTable.getCatalogName(), this.attributeBagTable.getSchemaName(), this.attributeBagTable.getTableName(), null);
            while (resultSet.next()) {
                String name = resultSet.getString("COLUMN_NAME");
                if (ATTRIBUTE_BAGNAME.equalsIgnoreCase(name)) {
                    this.bagName = resultSet.getInt("COLUMN_SIZE") - 1;
                    continue;
                }
                if (ATTRIBUTE_ATTR_NAME.equalsIgnoreCase(name)) {
                    this.attName = resultSet.getInt("COLUMN_SIZE") - 1;
                    continue;
                }
                if (!ATTRIBUTE_ATTR_VALUE.equalsIgnoreCase(name)) continue;
                this.attValue = resultSet.getInt("COLUMN_SIZE") - 1;
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("DBAttributeBag initialisation error, cannot read the DB table (" + this.getTableName() + ") information..."), (Throwable)e);
            throw e;
        }
        finally {
            if (con != null) {
                con.close();
                con = null;
            }
        }
    }

    protected String getTableName() {
        if (null != this.attributeBagTable) {
            return this.attributeBagTable.fullyQualifiedName(this.catalogSeparator);
        }
        return this.m_table;
    }

    public void setAttribute(String strName_p, Object value_p, String sBagName_p) throws Exception {
        if (strName_p == null) {
            LOG.error((Object)"OwStandardDBAttributeBagWriteableFactory.setAttribute() invoked with setName_p==null. Attribute needs a name");
            throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.setAttribute() invoked with setName_p==null. Attribute needs a name");
        }
        if (sBagName_p == null) {
            LOG.error((Object)"OwStandardDBAttributeBagWriteableFactory.setAttribute() invoked with sBagName_p==null. Attribute needs a bag name");
            throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.setAttribute() invoked with sBagName_p==null. Attribute needs a bag name");
        }
        if (strName_p.length() > this.attName) {
            LOG.error((Object)"OwStandardDBAttributeBagWriteableFactory.setAttribute() setName_p is too long. Attribute name has a fixed maximum length.");
            throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.setAttribute() setName_p is too long. Attribute name has a fixed maximum length.");
        }
        if (sBagName_p.length() > this.bagName) {
            LOG.error((Object)"OwStandardDBAttributeBagWriteableFactory.setAttribute() sBagName_p is too long. Attribute bag name has a fixed maximum length.");
            throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.setAttribute() sBagName_p is too long. Attribute bag name has a fixed maximum length.");
        }
        if (value_p != null && value_p.toString().length() > this.attValue) {
            LOG.error((Object)"OwStandardDBAttributeBagWriteableFactory.setAttribute() value_p is too long. Attribute value has a fixed maximum length.");
            throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.setAttribute() value_p is too long. Attribute value has a fixed maximum length.");
        }
        OwAttribute attr = this.m_attributes.get(sBagName_p + MAP_KEY_DELIMITER + strName_p);
        if (null != attr) {
            attr.setValue(value_p);
        } else {
            this.m_attributes.put(sBagName_p + MAP_KEY_DELIMITER + strName_p, new OwAttribute(1, sBagName_p, strName_p, value_p));
        }
    }

    private String getAttributeNameFromKey(String sKey_p) {
        int iDel = sKey_p.indexOf(MAP_KEY_DELIMITER);
        return sKey_p.substring(iDel + 1);
    }

    public void save(String strBagName_p) throws Exception {
        for (OwAttribute attr : this.m_attributes.values()) {
            if (!attr.getBagname().equals(strBagName_p)) continue;
            if (0 != attr.getState()) {
                try {
                    this.creator.setAttribute(attr);
                    this.m_jdbcTemplate.update((PreparedStatementCreator)this.creator);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Error executing. sql: " + this.creator.getSQL()), (Throwable)ex);
                    String[] params = this.creator.getParams();
                    for (int i = 0; i < params.length; ++i) {
                        LOG.error((Object)("param[" + i + "]: " + params[i].toString()));
                    }
                }
            }
            attr.saved();
        }
        this.m_attributes.values().removeAll(this.m_deletedAttributes);
        this.m_deletedAttributes.clear();
    }

    public Object getAttribute(int iIndex_p, String strBagName_p) throws Exception {
        throw new OwInvalidOperationException("OwStandardDBAttributeBagWriteableFactory.getAttribute(int iIndex_p, String strBagName_p): not implemented.");
    }

    public Object getAttribute(String strName_p, String strBagName_p) throws Exception {
        OwAttribute ret = this.m_attributes.get(strBagName_p + MAP_KEY_DELIMITER + strName_p);
        if (ret == null || ret.isDeleted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwStandardDBAttributeBagWriteableFactory.getAttribute: Object not found Exception, strName_p = " + strName_p + ", strBagName_p = " + strBagName_p));
            }
            throw new OwObjectNotFoundException("OwStandardDBAttributeBagWriteableFactory.getAttribute: strName_p = " + strName_p + ", strBagName_p = " + strBagName_p);
        }
        return ret.getValue();
    }

    public Object getSafeAttribute(String strName_p, Object default_p, String strBagName_p) {
        OwAttribute ret = this.m_attributes.get(strBagName_p + MAP_KEY_DELIMITER + strName_p);
        if (ret == null || ret.isDeleted()) {
            return default_p;
        }
        return ret.getValue();
    }

    public boolean hasAttribute(String strName_p, String strBagName_p) {
        OwAttribute ret = this.m_attributes.get(strBagName_p + MAP_KEY_DELIMITER + strName_p);
        return ret != null && !ret.isDeleted();
    }

    public int attributecount(String strBagName_p) {
        Iterator<OwAttribute> it = this.m_attributes.values().iterator();
        int iCount = 0;
        while (it.hasNext()) {
            OwAttribute value = it.next();
            if (!value.getBagname().equals(strBagName_p) || value.isDeleted()) continue;
            ++iCount;
        }
        return iCount;
    }

    public Collection getAttributeNames(String strBagName_p) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Map.Entry<String, OwAttribute> entry : this.m_attributes.entrySet()) {
            String strName = this.getAttributeNameFromKey(entry.getKey());
            if (!entry.getValue().getBagname().equals(strBagName_p) || entry.getValue().isDeleted()) continue;
            ret.add(strName);
        }
        return ret;
    }

    public OwAttributeBagWriteable getBag(String sBagName_p) throws Exception {
        if (sBagName_p.indexOf(MAP_KEY_DELIMITER) != -1) {
            String msg = "OwStandardDBAttributeBagWriteableFactory.getBag: Bagname not allowed, name = " + sBagName_p + ", remove [" + MAP_KEY_DELIMITER + "].";
            LOG.error((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        return new OwStandardDBAttributeBagWriteable(this, sBagName_p);
    }

    public void clear(String strBagName_p) {
        Iterator<Map.Entry<String, OwAttribute>> it = this.m_attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwAttribute> entry = it.next();
            if (!entry.getValue().getBagname().equals(strBagName_p)) continue;
            if (entry.getValue().isNew()) {
                it.remove();
                continue;
            }
            entry.getValue().delete();
        }
    }

    public void remove(String strName_p, String strBagName_p) {
        OwAttribute value = this.m_attributes.get(strBagName_p + MAP_KEY_DELIMITER + strName_p);
        if (value != null) {
            if (value.isNew()) {
                this.m_attributes.remove(strBagName_p + MAP_KEY_DELIMITER + strName_p);
            } else {
                value.delete();
            }
        }
    }

    protected OwPreparedStatementCreator createStatementCreator() {
        return new OwPreparedStatementCreator();
    }

    private class OwPreparedStatementCreator
    implements PreparedStatementCreator {
        private OwAttribute attr;
        private HashMap<Integer, String> sqlStmtCache = new HashMap();

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            String sql = this.sqlStmtCache.get(this.attr.getState());
            if (sql == null) {
                sql = this.getSQL();
                this.sqlStmtCache.put(this.attr.getState(), sql);
            }
            PreparedStatement stmt = con.prepareStatement(sql);
            String[] params = this.getParams();
            for (int i = 0; i < params.length; ++i) {
                stmt.setString(i + 1, params[i]);
            }
            return stmt;
        }

        public void setAttribute(OwAttribute attr) {
            this.attr = attr;
        }

        public String getSQL() {
            String sql = null;
            if (this.attr != null) {
                switch (this.attr.getState()) {
                    case 1: {
                        sql = "insert into " + OwStandardDBAttributeBagWriteableFactory.this.getTableName() + " (" + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_USER + "," + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_BAGNAME + "," + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_NAME + "," + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_VALUE + ") values (?,?,?,?)";
                        break;
                    }
                    case 2: {
                        sql = "update " + OwStandardDBAttributeBagWriteableFactory.this.getTableName() + " set " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_VALUE + " = ? where " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_NAME + " = ? and " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_BAGNAME + " = ? and " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_USER + " = ?";
                        break;
                    }
                    case 3: {
                        sql = "delete from " + OwStandardDBAttributeBagWriteableFactory.this.getTableName() + " where " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_ATTR_NAME + " = ? and " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_BAGNAME + " = ? and " + OwStandardDBAttributeBagWriteableFactory.ATTRIBUTE_USER + " = ?";
                    }
                }
            }
            return sql;
        }

        public String[] getParams() {
            String[] params = null;
            if (this.attr != null) {
                switch (this.attr.getState()) {
                    case 1: {
                        params = new String[]{OwStandardDBAttributeBagWriteableFactory.this.m_user, this.attr.getBagname(), this.attr.getName(), this.attr.getValue() != null ? this.attr.getValue().toString() : null};
                        break;
                    }
                    case 2: {
                        params = new String[]{this.attr.getValue() != null ? this.attr.getValue().toString() : null, this.attr.getName(), this.attr.getBagname(), OwStandardDBAttributeBagWriteableFactory.this.m_user};
                        break;
                    }
                    case 3: {
                        params = new String[]{this.attr.getName(), this.attr.getBagname(), OwStandardDBAttributeBagWriteableFactory.this.m_user};
                    }
                }
            }
            return params;
        }
    }

    private class OwAttribute {
        public static final int STATE_NORMAL = 0;
        public static final int STATE_NEW = 1;
        public static final int STATE_MODIFIED = 2;
        public static final int STATE_DELETED = 3;
        private String m_bagname;
        private String m_name;
        private Object m_value;
        private int m_iState;

        public OwAttribute(int state_p, String bagname_p, String name_p, Object value_p) {
            this.m_bagname = bagname_p;
            this.m_name = name_p;
            this.m_iState = state_p;
            this.m_value = value_p;
        }

        public int getState() {
            return this.m_iState;
        }

        public boolean isNew() {
            return this.m_iState == 1;
        }

        public boolean isModified() {
            return this.m_iState == 2;
        }

        public boolean isDeleted() {
            return this.m_iState == 3;
        }

        public void delete() {
            this.m_iState = 3;
        }

        public void setValue(Object value_p) {
            if (this.m_value == null ? value_p == null : this.m_value.equals(value_p)) {
                return;
            }
            this.m_value = value_p;
            if (this.m_iState != 1) {
                this.m_iState = 2;
            }
        }

        public Object getValue() {
            return this.m_value;
        }

        public String getName() {
            return this.m_name;
        }

        public String getBagname() {
            return this.m_bagname;
        }

        public void saved() {
            if (this.m_iState == 3) {
                OwStandardDBAttributeBagWriteableFactory.this.m_deletedAttributes.add(this);
            } else {
                this.m_iState = 0;
            }
        }
    }
}

