/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.log.OwLogCore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.perf4j.log4j.Log4JStopWatch;

public class OwStreamUtil {
    private static final Logger LOG = OwLogCore.getLogger(OwStreamUtil.class);
    public static final int BUFFER_SIZE = 65536;
    public static final int MIN_READ = 6553;

    public static void upload(InputStream in_p, OutputStream out_p, boolean fClose_p) throws Exception {
        Log4JStopWatch stopWatchUpload = new Log4JStopWatch("OwStreamUtil.upload");
        try {
            byte[] bBuffer = new byte[65536];
            int iRead = 0;
            do {
                int iNextRead;
                if ((iNextRead = in_p.available()) > 65536) {
                    iNextRead = 65536;
                }
                if (iNextRead == 0) {
                    iNextRead = 6553;
                }
                if (-1 == (iRead = in_p.read(bBuffer, 0, iNextRead))) continue;
                out_p.write(bBuffer, 0, iRead);
            } while (-1 != iRead);
            out_p.flush();
        }
        catch (Exception e) {
            String msg = "OwStreamUtil.upload: Error uploading the InputStream to the OutputStream.";
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            stopWatchUpload.stop();
            if (fClose_p) {
                OwStreamUtil.closeStreams(in_p, out_p);
            }
        }
    }

    public static void upload(InputStream in_p, OutputStream out_p, boolean fClose_p, int bufSize_p) throws IOException {
        Log4JStopWatch stopWatchUpload = new Log4JStopWatch("OwStreamUtil.upload");
        try {
            byte[] bBuffer = new byte[bufSize_p];
            int iRead = 0;
            while ((iRead = in_p.read(bBuffer, 0, bufSize_p)) != -1) {
                out_p.write(bBuffer, 0, iRead);
            }
            out_p.flush();
        }
        catch (IOException e) {
            String msg = "OwStreamUtil.upload: Error uploading the InputStream to the OutputStream.";
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            stopWatchUpload.stop();
            if (fClose_p) {
                OwStreamUtil.closeStreams(in_p, out_p);
            }
        }
    }

    private static void closeStreams(InputStream in_p, OutputStream out_p) throws IOException {
        if (in_p != null) {
            try {
                in_p.close();
                in_p = null;
            }
            catch (IOException e) {
                String msg = "OwStreamUtil.finally: Error closing the input stream.";
                LOG.warn((Object)msg, (Throwable)e);
                throw e;
            }
        }
        if (out_p != null) {
            try {
                out_p.close();
                out_p = null;
            }
            catch (IOException e) {
                String msg = "OwStreamUtil.finally: Error closing the output stream.";
                LOG.warn((Object)msg, (Throwable)e);
                throw e;
            }
        }
    }
}

