/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.util.OwDebugModeException;
import com.wewebu.ow.server.util.OwStringProperties;
import java.util.Locale;
import java.util.Map;

public class OwString {
    private static OwStringProperties m_properties = OwStringProperties.getInstance();
    protected String m_strKeyName;
    protected String m_strDefaultDisplayName;
    public static final String LABEL_PREFIX = "owlabel.";

    public String getKey() {
        return this.m_strKeyName;
    }

    public String getDefaultDisplayName() {
        return this.m_strDefaultDisplayName;
    }

    public OwString(String strKeyyName_p, String strDefaultDisplayName_p) {
        this.m_strKeyName = strKeyyName_p;
        this.m_strDefaultDisplayName = strDefaultDisplayName_p;
    }

    public OwString(String strLabelOrKey_p, String strDefaultDisplayName_p, boolean fTreatAsLabel_p) {
        this.m_strKeyName = fTreatAsLabel_p ? LABEL_PREFIX + strLabelOrKey_p : strLabelOrKey_p;
        this.m_strDefaultDisplayName = strDefaultDisplayName_p;
    }

    public String toString() {
        return this.m_strKeyName;
    }

    public OwString(String strLabel_p) {
        this.m_strKeyName = LABEL_PREFIX + strLabel_p;
        this.m_strDefaultDisplayName = strLabel_p;
    }

    public String getString(Locale locale_p) {
        return OwString.localize(locale_p, this.m_strKeyName, this.m_strDefaultDisplayName);
    }

    public static void replaceAll(StringBuffer strIn_p, String strPattern_p, String strReplacement_p) {
        int iIndex = 0;
        while (-1 != (iIndex = strIn_p.indexOf(strPattern_p, iIndex))) {
            strIn_p.replace(iIndex, iIndex + strPattern_p.length(), strReplacement_p);
            iIndex += strReplacement_p.length();
        }
    }

    public static void replaceAll(StringBuilder strIn_p, String pattern_p, String replacement_p) {
        int idx = 0;
        while ((idx = strIn_p.indexOf(pattern_p, idx)) != -1) {
            strIn_p.replace(idx, idx + pattern_p.length(), replacement_p);
            idx += replacement_p.length();
        }
    }

    public static String replaceAll(String strIn_p, String strPattern_p, String strReplacement_p) {
        int iIndex = strIn_p.indexOf(strPattern_p);
        if (iIndex == -1) {
            return strIn_p;
        }
        StringBuffer strRet = new StringBuffer();
        int iOldIndex = 0;
        while (-1 != iIndex) {
            strRet.append(strIn_p.substring(iOldIndex, iIndex));
            strRet.append(strReplacement_p);
            iOldIndex = iIndex += strPattern_p.length();
            iIndex = strIn_p.indexOf(strPattern_p, iIndex);
        }
        if (iOldIndex <= strIn_p.length()) {
            strRet.append(strIn_p.substring(iOldIndex, strIn_p.length()));
        }
        return strRet.toString();
    }

    public static String localizeLabel(Locale local_p, String strLabel_p) {
        return OwString.localize(local_p, LABEL_PREFIX + strLabel_p, strLabel_p);
    }

    public static boolean hasLabel(Locale local_p, String strLabel_p) {
        try {
            return m_properties.getProperties(local_p).containsKey(LABEL_PREFIX + strLabel_p);
        }
        catch (OwDebugModeException edebug) {
            return false;
        }
    }

    public static String localize(Locale local_p, String strKey_p, String strText_p) {
        try {
            return m_properties.getProperties(local_p).get(strKey_p).toString();
        }
        catch (NullPointerException e) {
            return strText_p;
        }
        catch (OwDebugModeException edebug) {
            return "[" + strKey_p + "]";
        }
    }

    public static String localizeLabel(Locale local_p, String strLabel_p, String strDefault_p) {
        try {
            return m_properties.getProperties(local_p).get(LABEL_PREFIX + strLabel_p).toString();
        }
        catch (NullPointerException e) {
            return strDefault_p;
        }
        catch (OwDebugModeException edebug) {
            return "[owlabel." + strLabel_p + "]";
        }
    }

    public static String localize1(Locale local_p, String strKey_p, String strText_p, String strAttribute1_p) {
        StringBuilder text = new StringBuilder(OwString.localize(local_p, strKey_p, strText_p));
        OwString.replace(text, strAttribute1_p);
        return text.toString();
    }

    public static String localize2(Locale local_p, String strKey_p, String strText_p, String strAttribute1_p, String strAttribute2_p) {
        StringBuilder text = new StringBuilder(OwString.localize(local_p, strKey_p, strText_p));
        OwString.replace(text, strAttribute1_p, strAttribute2_p);
        return text.toString();
    }

    public static String localize3(Locale local_p, String strKey_p, String strText_p, String strAttribute1_p, String strAttribute2_p, String strAttribute3_p) {
        StringBuilder text = new StringBuilder(OwString.localize(local_p, strKey_p, strText_p));
        OwString.replace(text, strAttribute1_p, strAttribute2_p, strAttribute3_p);
        return text.toString();
    }

    private static void replace(StringBuilder text, String ... replacements) {
        for (int i = 0; i < replacements.length; ++i) {
            OwString.replaceAll(text, "%" + (1 + i), replacements[i]);
        }
    }

    public static synchronized void putAll(Locale locale_p, Map properties_p) throws Exception {
        m_properties.putAll(locale_p, properties_p);
    }

    public static synchronized void putLabel(Locale locale_p, String key_p, String label_p) throws Exception {
        m_properties.putLabel(locale_p, key_p, label_p);
    }
}

