/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import com.wewebu.ow.server.util.OwXMLUtil;

public class OwTableSpec {
    public static String STANDARD_DB_ATTRIBUTE_BAG_TABLE_NAME = "OW_ATTRIBUTE_BAG";
    private String catalogName;
    private String schemaName;
    private String tableName;

    public OwTableSpec() {
        this.catalogName = null;
        this.schemaName = null;
        this.tableName = STANDARD_DB_ATTRIBUTE_BAG_TABLE_NAME;
    }

    public OwTableSpec(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public static OwTableSpec fromXML(OwXMLUtil attributeBagTableXML) {
        String schema;
        String tableName = attributeBagTableXML.getSafeTextValue(STANDARD_DB_ATTRIBUTE_BAG_TABLE_NAME);
        String catalog = attributeBagTableXML.getSafeStringAttributeValue("catalog", null);
        if (null != catalog && catalog.trim().isEmpty()) {
            catalog = null;
        }
        if (null != (schema = attributeBagTableXML.getSafeStringAttributeValue("schema", null)) && schema.trim().isEmpty()) {
            schema = null;
        }
        return new OwTableSpec(catalog, schema, tableName);
    }

    public String fullyQualifiedName(String catalogSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableName);
        if (null != this.schemaName) {
            sb.insert(0, catalogSeparator);
            sb.insert(0, this.schemaName);
        }
        if (null != this.catalogName) {
            sb.insert(0, catalogSeparator);
            sb.insert(0, this.catalogName);
        }
        return sb.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

