/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OwXMLDOMUtil {
    private Node m_Node;

    public OwXMLDOMUtil(String strRootNodeName_p) throws Exception {
        Document doc = OwXMLDOMUtil.getNewDocument();
        this.m_Node = doc.createElementNS("", strRootNodeName_p);
    }

    public Node addNode(String strSubNodeName_p) {
        Document doc = this.m_Node.getOwnerDocument();
        Element newNode = doc.createElementNS("", strSubNodeName_p);
        this.m_Node.appendChild(newNode);
        return newNode;
    }

    public void addTextNode(String strNodeName_p, String strText_p) {
        Document doc = this.m_Node.getOwnerDocument();
        this.addNode(strNodeName_p).appendChild(doc.createTextNode(strText_p));
    }

    public InputStream getInputStream() throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(this.m_Node);
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outStr);
        transformer.transform(source, result);
        outStr.flush();
        return new ByteArrayInputStream(outStr.toByteArray());
    }

    private static void htmlColour(String strXML, Writer w_p) throws IOException {
        boolean startComment = false;
        block7: for (int i = 0; i < strXML.length(); ++i) {
            int c = 97;
            int next = 98;
            int prev = 99;
            int nextt = 100;
            int nexttt = 101;
            int prevv = 102;
            c = strXML.charAt(i);
            if (i + 3 < strXML.length()) {
                next = strXML.charAt(i + 1);
                nextt = strXML.charAt(i + 2);
                nexttt = strXML.charAt(i + 3);
            }
            if (i > 2) {
                prev = strXML.charAt(i - 1);
                prevv = strXML.charAt(i - 2);
            }
            switch (c) {
                case 60: {
                    if (next == 33 && nextt == 45 && nexttt == 45) {
                        startComment = true;
                        w_p.write("<font color='#008000'><b>&#60;</b></font><font color='#008000'></b>");
                        continue block7;
                    }
                    if (startComment) {
                        w_p.write("&#60;");
                        continue block7;
                    }
                    w_p.write("</b></font><font color='#0000ff'><b>&#60;</b></font>");
                    continue block7;
                }
                case 62: {
                    if (prev == 45 && prevv == 45) {
                        startComment = false;
                        w_p.write("</font><font color='#008000'><b>&#62;</b></font>");
                        continue block7;
                    }
                    if (startComment) {
                        w_p.write("&#62;");
                        continue block7;
                    }
                    w_p.write("<font color='#0000ff'><b>&#62;</b></font><b><font color='#ff0000'>");
                    continue block7;
                }
                case 9: {
                    w_p.write("&nbsp;&nbsp;&nbsp;");
                    continue block7;
                }
                case 32: {
                    w_p.write("&nbsp;");
                    continue block7;
                }
                case 10: {
                    w_p.write("<br>");
                    continue block7;
                }
                default: {
                    w_p.write(c);
                }
            }
        }
    }

    public static void writeHtmlDump(Writer w_p, Node node_p) throws Exception {
        String strXML = "";
        try {
            strXML = OwXMLDOMUtil.toString(node_p);
        }
        catch (Exception e) {
            strXML = e.getLocalizedMessage();
        }
        OwXMLDOMUtil.htmlColour(strXML, w_p);
    }

    public static Element getChildElement(Element parent_p, String childElementName_p) {
        for (Node node = parent_p.getFirstChild(); node != null; node = node.getNextSibling()) {
            String sNodeName = node.getNodeName();
            if (node.getNodeType() != 1 || sNodeName == null || !sNodeName.equals(childElementName_p)) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getElementText(Element element_p) {
        Node oChildNode;
        if (element_p != null && (oChildNode = element_p.getFirstChild()) != null && oChildNode.getNodeType() == 3) {
            return oChildNode.getNodeValue();
        }
        return null;
    }

    public static String getChildElementText(Element parent_p, String childElementName_p) {
        Element child = (Element)OwXMLDOMUtil.getChildNode(parent_p, childElementName_p);
        if (child != null) {
            return OwXMLDOMUtil.getElementText(child);
        }
        return null;
    }

    public static Node getChildNode(Node node_p, String childToFind_p) {
        for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            String sNodeName = n.getNodeName();
            if (sNodeName == null || !sNodeName.equals(childToFind_p)) continue;
            return n;
        }
        return null;
    }

    public static String encodeSpecialCharactersForXML(String xmlString_p) {
        if (xmlString_p == null) {
            return null;
        }
        int iSize = xmlString_p.length();
        StringBuffer sb = new StringBuffer(iSize);
        block7: for (int i = 0; i < iSize; ++i) {
            char chr = xmlString_p.charAt(i);
            switch (chr) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    public static String makeXMLString(String sText_p) {
        StringBuffer ret = new StringBuffer();
        block6: for (int i = 0; i < sText_p.length(); ++i) {
            char c = sText_p.charAt(i);
            switch (c) {
                case '&': {
                    ret.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    ret.append("&quot;");
                    continue block6;
                }
                case '<': {
                    ret.append("&#60;");
                    continue block6;
                }
                case '>': {
                    ret.append("&#62;");
                    continue block6;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    public static boolean toFile(File file_p, Node node_p) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(node_p);
            StreamResult result = new StreamResult(file_p);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String toString(Node node_p) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(node_p);
        StringWriter outStr = new StringWriter();
        StreamResult result = new StreamResult(outStr);
        transformer.transform(source, result);
        return outStr.toString();
    }

    public static List getSafeNodeList(Node node_p) {
        ArrayList<Node> list = new ArrayList<Node>();
        try {
            for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                list.add(n);
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    public static InputStream getInputStream(Node node_p) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(node_p);
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outStr);
        transformer.transform(source, result);
        outStr.flush();
        return new ByteArrayInputStream(outStr.toByteArray());
    }

    public static boolean getSafeBooleanAttributeValue(Node node_p, String strAttributeName_p, boolean fDefault_p) {
        try {
            String sRet = node_p.getAttributes().getNamedItem(strAttributeName_p).getNodeValue();
            if (sRet.length() > 0) {
                return sRet.equalsIgnoreCase("true");
            }
            return fDefault_p;
        }
        catch (Exception e) {
            return fDefault_p;
        }
    }

    public static boolean getSafeBooleanValue(Node node_p, boolean fDefault_p) {
        try {
            Node firstChild = node_p.getFirstChild();
            String firstValue = firstChild.getNodeValue();
            if (firstValue.equalsIgnoreCase("true")) {
                return true;
            }
            return firstValue.equalsIgnoreCase("false") ? false : fDefault_p;
        }
        catch (Exception e) {
            return fDefault_p;
        }
    }

    public static String getSafeStringAttributeValue(Node node_p, String strAttributeName_p, String strDefault_p) {
        try {
            String sRet = node_p.getAttributes().getNamedItem(strAttributeName_p).getNodeValue();
            if (sRet.length() > 0) {
                return sRet;
            }
            return strDefault_p;
        }
        catch (Exception e) {
            return strDefault_p;
        }
    }

    public static int getSafeIntegerAttributeValue(Node node_p, String strAttributeName_p, int iDefault_p) {
        try {
            String sRet = node_p.getAttributes().getNamedItem(strAttributeName_p).getNodeValue();
            if (sRet.length() > 0) {
                return Integer.parseInt(sRet);
            }
            return iDefault_p;
        }
        catch (Exception e) {
            return iDefault_p;
        }
    }

    public static Set getSafeStringSet(Node node_p) {
        HashSet<String> list = new HashSet<String>();
        try {
            for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                list.add(n.getFirstChild().getNodeValue());
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    public static List getSafeStringList(Node node_p) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                list.add(n.getFirstChild().getNodeValue());
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    public static List getSafeCDATAList(Node node_p) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 4) continue;
                list.add(n.getNodeValue());
            }
        }
        catch (Exception e) {
            return list;
        }
        return list;
    }

    public static Document getDocumentFromInputStream(InputStream inputStream_p) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(inputStream_p);
    }

    public static Document getNewDocument() throws ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.newDocument();
    }

    public static Document getDocumentFromString(String xml_p) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml_p));
        return db.parse(is);
    }

    public static void setNodeAttribute(Document document_p, Node node_p, String attrName_p, String attrValue_p) {
        NamedNodeMap al = node_p.getAttributes();
        if (al != null) {
            Attr attrNode = document_p.createAttribute(attrName_p);
            attrNode.setNodeValue(attrValue_p);
            al.setNamedItem(attrNode);
        }
    }

    public static void initialize(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            child.getNodeValue();
            NamedNodeMap attributes = child.getAttributes();
            if (attributes != null) {
                int length = attributes.getLength();
                for (int j = 0; j < length; ++j) {
                    Node attribute = attributes.item(j);
                    attribute.getNodeValue();
                }
            }
            OwXMLDOMUtil.initialize(child);
        }
    }

    public static void initialize(Document document) {
        Element element = document.getDocumentElement();
        OwXMLDOMUtil.initialize(element);
    }

    public String toString() {
        if (null != this.m_Node) {
            try {
                return OwXMLDOMUtil.toString(this.m_Node);
            }
            catch (TransformerException e) {
                return e.getMessage();
            }
        }
        return "<null>";
    }

    public static void writeHtmlDumpFiltered(Writer htmlWriter_p, Node m_Node, Map<String, String> values) throws Exception {
        String strXML = "";
        try {
            strXML = OwXMLDOMUtil.toString(m_Node);
        }
        catch (Exception e) {
            strXML = e.getLocalizedMessage();
        }
        for (Map.Entry<String, String> e : values.entrySet()) {
            strXML = strXML.replaceAll("(?s)<" + e.getKey() + "[^>]*>.*?</" + e.getKey() + ">", "<" + e.getKey() + ">" + e.getValue() + "<" + e.getKey() + ">");
        }
        OwXMLDOMUtil.htmlColour(strXML, htmlWriter_p);
    }
}

