/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.ldap;

import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.SortControl;
import org.apache.log4j.Logger;

public class OwLdapConnection {
    private static final Logger LOG = OwLogCore.getLogger(OwLdapConnection.class);
    private static final int LDAP_TIME_LIMIT = 120000;
    private static final int LDAP_COUNT_LIMIT = 100;
    private Properties ldapProperties;
    private Boolean anonymousLoginAllowed;
    private int recursionLevel;
    private Integer ldapCountLimit;

    public OwLdapConnection(Properties ldapProperties_p, int recursionLevel_p) {
        this.recursionLevel = recursionLevel_p;
        this.ldapProperties = new Properties();
        this.ldapProperties.putAll((Map<?, ?>)ldapProperties_p);
        this.anonymousLoginAllowed = Boolean.FALSE;
        this.anonymousLoginAllowed = Boolean.valueOf((String)this.ldapProperties.get("anonymousLogin"));
        if (this.anonymousLoginAllowed.booleanValue()) {
            this.ldapProperties.put("java.naming.security.authentication", "none");
        }
        this.ldapCountLimit = this.getProperty("LdapCountLimit", 100);
    }

    public InitialLdapContext createInitialDirContext() throws OwConfigurationException {
        try {
            InitialLdapContext initialLdapContext = new InitialLdapContext(this.ldapProperties, null);
            return initialLdapContext;
        }
        catch (NamingException e) {
            String msg = "LDAP Authentication failed.";
            if (this.anonymousLoginAllowed.booleanValue()) {
                msg = msg + " Maybe java.naming.security.authentication=none is not allowed (bootstrap.xml: anonymousLogin=true).";
            }
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
    }

    public String getProperty(String propertyName_p, String defaultValue_p) {
        if (this.ldapProperties.containsKey(propertyName_p)) {
            return (String)this.ldapProperties.get(propertyName_p);
        }
        LOG.debug((Object)("OwLdapConnection.getProperty: Missing LDAP configuration for property " + propertyName_p + ", using default =[" + defaultValue_p + "]"));
        return defaultValue_p;
    }

    private Integer getProperty(String propertyName_p, int defaultValue_p) {
        String value = null;
        if (!this.ldapProperties.containsKey(propertyName_p)) {
            LOG.debug((Object)("OwLdapConnection.getProperty: Missing LDAP configuration for property " + propertyName_p + ", using default =[" + defaultValue_p + "]"));
            return defaultValue_p;
        }
        value = (String)this.ldapProperties.get(propertyName_p);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("The value for propety " + propertyName_p + " must be an integer."), (Throwable)e);
            return defaultValue_p;
        }
    }

    public int getRecursionLevel() {
        return this.recursionLevel;
    }

    public Properties getProperties() {
        Properties propertiesCopy = new Properties();
        propertiesCopy.putAll((Map<?, ?>)this.ldapProperties);
        return propertiesCopy;
    }

    public String getUserDistinguishedName() throws OwAuthenticationException {
        String dn = (String)this.ldapProperties.get("com.wewebu.ow.user.dn");
        if (dn == null) {
            LOG.debug((Object)"OwLdapConnection.getUserDistinguishedName: Unauthenticated LDAP connection. Missing user distinguished name.");
            throw new OwAuthenticationException("OwLdapConnection.getUserDistinguishedName: Unauthenticated LDAP connection.");
        }
        return dn;
    }

    public String getUserAttributeValue(String attributeName_p, boolean trimmCommonName_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String distinguishedName = this.getUserDistinguishedName();
        return this.getAttributeValue(distinguishedName, attributeName_p, trimmCommonName_p);
    }

    public Object getUserAttributeValue(String attributeName_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        String distinguishedName = this.getUserDistinguishedName();
        return this.getAttributeValue(distinguishedName, attributeName_p);
    }

    public String getAttributeValue(String distinguishedName_p, String attributeName_p, boolean trimmCommonName_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        Object attributeValue = this.getAttributeValue(distinguishedName_p, attributeName_p);
        String avString = null;
        if (attributeValue != null) {
            avString = attributeValue.toString();
        }
        if (trimmCommonName_p && avString != null && avString.indexOf(attributeName_p + ":") == 0) {
            avString = avString.substring((attributeName_p + ":").length());
            avString = avString.trim();
        }
        return avString;
    }

    public Object getAttributeValue(String distinguishedName_p, String attributeName_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        Attributes attrs;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createInitialDirContext();
            if (ctx == null) {
                throw new OwAuthenticationException("OwLdapConnector.getUserLongName: The user is not authenticated!");
            }
            attrs = ctx.getAttributes(distinguishedName_p);
        }
        catch (NamingException e) {
            throw new OwAuthenticationException("Get UserLongName: The user is not authenticated!");
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
        Object attributeValue = null;
        try {
            Attribute attr = attrs.get(attributeName_p);
            if (attr != null) {
                attributeValue = attr.get();
            } else {
                LOG.info((Object)("OwLdapConnection.getAttributeValue: LDAP attribute " + attributeName_p + " not found."));
            }
        }
        catch (NamingException e) {
            String msg = "Exception reading the attribute, Unknown attribute: \"" + attributeName_p + "\" to fetch the name from LDAP...";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        return attributeValue;
    }

    public Collection<String> searchAttributeValues(String searchBase_p, String[][] matchAttrs_p, String attribute_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        List<String> attributeValues = null;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createInitialDirContext();
            List<String> list = attributeValues = this.searchAttributeValues(ctx, searchBase_p, matchAttrs_p, attribute_p);
            return list;
        }
        catch (NamingException e) {
            StringBuffer matchString = new StringBuffer();
            for (int i = 0; i < matchAttrs_p.length; ++i) {
                if (matchAttrs_p[i] != null) {
                    if (matchAttrs_p[i].length > 0) {
                        matchString.append(matchAttrs_p[i][0]).append("=");
                    } else {
                        matchString.append("=");
                    }
                    if (matchAttrs_p[i].length <= 1 || matchAttrs_p[i][1] == null) continue;
                    matchString.append(matchAttrs_p[i][1]);
                    continue;
                }
                matchString.append(" null ");
            }
            String msg = "Exception reading attribute values from LDAP, LdapSearchBase=" + searchBase_p + " and matching attributes " + matchString.toString();
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
    }

    public NamingEnumeration<SearchResult> search(String searchBase_p, String[][] attributeValues_p, String[] returnIds_p) throws OwConfigurationException, OwInvalidOperationException {
        InitialLdapContext ctx = null;
        try {
            ctx = this.createInitialDirContext();
            NamingEnumeration<SearchResult> namingEnumeration = this.search(ctx, searchBase_p, attributeValues_p, returnIds_p);
            return namingEnumeration;
        }
        catch (NamingException e) {
            String msg = "Exception reading attribute values from LDAP, LdapSearchBase=" + searchBase_p + ".";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
                ctx = null;
            }
        }
    }

    private NamingEnumeration<SearchResult> search(DirContext context_p, String searchBase_p, String[][] attributeValues_p, String[] returnIds_p) throws NamingException {
        StringBuffer filter = new StringBuffer();
        if (0 != attributeValues_p.length) {
            for (int i = 0; i < attributeValues_p.length; ++i) {
                filter.append("(");
                filter.append(attributeValues_p[i][0]);
                filter.append("=");
                filter.append(attributeValues_p[i][1]);
                filter.append(") ");
            }
            if (1 < attributeValues_p.length) {
                filter.insert(0, "(& ");
                filter.append(")");
            }
        }
        SearchControls ctrls = new SearchControls();
        ctrls.setSearchScope(2);
        ctrls.setReturningAttributes(returnIds_p);
        NamingEnumeration<SearchResult> answer = context_p.search(searchBase_p, filter.toString(), ctrls);
        return answer;
    }

    private List<String> searchAttributeValues(DirContext context_p, String searchBase_p, String[][] attributeValues_p, String attribute_p) throws NamingException {
        ArrayList<String> attributeValueList = new ArrayList<String>();
        NamingEnumeration<SearchResult> answer = this.search(context_p, searchBase_p, attributeValues_p, new String[]{attribute_p});
        String answerAttribute = attribute_p + ":";
        int answerAttributeLen = answerAttribute.length();
        while (answer.hasMoreElements()) {
            SearchResult sr = (SearchResult)answer.nextElement();
            Attributes dnAttrs = sr.getAttributes();
            if (dnAttrs == null) continue;
            NamingEnumeration<? extends Attribute> attrEnum = dnAttrs.getAll();
            while (attrEnum.hasMore()) {
                BasicAttribute ba = (BasicAttribute)attrEnum.next();
                String baString = ba.toString();
                baString = baString.substring(answerAttributeLen);
                attributeValueList.add(baString.trim());
            }
        }
        return attributeValueList;
    }

    public OwObjectCollection searchValuesByFilter(String searchBase, String filter, String returningAttibute, String sortKey) throws OwException {
        OwStandardObjectCollection result = new OwStandardObjectCollection();
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setTimeLimit(120000);
        ctls.setCountLimit(this.ldapCountLimit.intValue());
        String[] returningAttibutes = new String[]{returningAttibute};
        ctls.setReturningAttributes(returningAttibutes);
        InitialLdapContext ctx = this.createInitialDirContext();
        try {
            if (null != sortKey) {
                ctx.setRequestControls(new Control[]{new SortControl(sortKey, false)});
            }
            NamingEnumeration<SearchResult> answer = ctx.search(searchBase, filter, ctls);
            while (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                if ("distinguishedName".equals(returningAttibute)) {
                    result.add(sr.getNameInNamespace());
                    continue;
                }
                Attributes dnAttrs = sr.getAttributes();
                if (dnAttrs == null) continue;
                Attribute att = dnAttrs.get(returningAttibute);
                result.add(att.get());
            }
        }
        catch (NamingException e) {
            throw new OwInvalidOperationException("Could not search by filter.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OwInvalidOperationException("Could not sort ersults.", (Throwable)e);
        }
        if (result.size() >= this.ldapCountLimit) {
            result.setComplete(false);
        }
        LOG.info((Object)("Results: " + result.size()));
        return result;
    }
}

