/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.paramcodec;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.paramcodec.OwCookieStoreCodec;
import com.wewebu.ow.server.util.paramcodec.OwParameterMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwAttributeBagCodec
extends OwCookieStoreCodec {
    private static final Logger LOG = OwLogCore.getLogger(OwAttributeBagCodec.class);
    public static final String DEFAULT_CODEC_BAGS_PREFIX = "codec_bag_";
    public static final String DEFAULT_COOKIE_BAGS_PREFIX = "cc_";
    public static final String DEFAULT_CONFIG_BAG_USER_NAME = "OW_GLOBAL";
    private static final String CODEC_MASTER_SUFFIX = "master";
    private static final String CODEC_COOKIE_TABLE_SUFFIX = "ctable";
    private static final String MASTER_NAME_INDEX_PROPERTY = "name_index";
    public static final String CONFIGURATION_ATTRIBUTEBAGS_ELEMENT = "AttributeBags";
    public static final String CONFIGURATION_CODEC_PREFIX_ATTRIBUTE = "codecprefix";
    public static final String CONFIGURATION_COOKIE_PREFIX_ATTRIBUTE = "cookieprefix";
    public static final String CONFIGURATION_USER_ATTRIBUTE = "user";
    private String m_codecBagsPrefix = "codec_bag_";
    private String m_cookieBagsPrefix = "cc_";

    public static String[] loadAttributeBagsConfiguation(OwXMLUtil codecConfiguration_p) throws Exception {
        String codecBagsPrefix = DEFAULT_CODEC_BAGS_PREFIX;
        String cookieBagsPrefix = DEFAULT_COOKIE_BAGS_PREFIX;
        String user = DEFAULT_CONFIG_BAG_USER_NAME;
        OwXMLUtil attributeBagsUtil = codecConfiguration_p.getSubUtil(CONFIGURATION_ATTRIBUTEBAGS_ELEMENT);
        if (attributeBagsUtil == null) {
            LOG.debug((Object)"OwAttributeBagCodec.loadAttributeBagsConfiguation(): configuration the attribute bags configuration! Proceeding with defaults!");
        } else {
            codecBagsPrefix = attributeBagsUtil.getSafeStringAttributeValue(CONFIGURATION_CODEC_PREFIX_ATTRIBUTE, "");
            if (codecBagsPrefix == null || codecBagsPrefix.length() == 0) {
                LOG.debug((Object)"OwAttributeBagCodec.loadAttributeBagsConfiguation(): configuration is missing codec bags prefix! Proceeding with default codec_bag_");
                codecBagsPrefix = DEFAULT_CODEC_BAGS_PREFIX;
            }
            if ((cookieBagsPrefix = attributeBagsUtil.getSafeStringAttributeValue(CONFIGURATION_COOKIE_PREFIX_ATTRIBUTE, "")) == null || cookieBagsPrefix.length() == 0) {
                LOG.debug((Object)"OwAttributeBagCodec.loadAttributeBagsConfiguation(): configuration is missing cookie bags prefix! Proceeding with default cc_");
                cookieBagsPrefix = DEFAULT_COOKIE_BAGS_PREFIX;
            }
            if ((user = attributeBagsUtil.getSafeStringAttributeValue(CONFIGURATION_USER_ATTRIBUTE, "")) == null || user.length() == 0) {
                LOG.debug((Object)"OwAttributeBagCodec.loadAttributeBagsConfiguation(): configuration is missing bags user name ! Proceeding with default OW_GLOBAL");
                user = DEFAULT_CONFIG_BAG_USER_NAME;
            }
        }
        return new String[]{codecBagsPrefix, cookieBagsPrefix, user};
    }

    public OwAttributeBagCodec(String cookieParameterName_p, long namesExpirationTime_p, String codecBagsPrefix_p, String cookieBagsPrefix_p) {
        super(cookieParameterName_p, namesExpirationTime_p);
        this.m_codecBagsPrefix = codecBagsPrefix_p;
        this.m_cookieBagsPrefix = cookieBagsPrefix_p;
    }

    protected String masterBagName() {
        return this.m_codecBagsPrefix + CODEC_MASTER_SUFFIX;
    }

    protected String cookieTableBagName() {
        return this.m_codecBagsPrefix + CODEC_COOKIE_TABLE_SUFFIX;
    }

    protected String cookieBagName(String cookieName_p) {
        return this.m_cookieBagsPrefix + cookieName_p;
    }

    protected abstract OwAttributeBagWriteable getBag(String var1, boolean var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OwAttributeBagWriteable getMasterBag() throws Exception {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getBag(this.masterBagName(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OwAttributeBagWriteable getCookieTableBag() throws Exception {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getBag(this.cookieTableBagName(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OwAttributeBagWriteable getCookieBag(String cookieName_p, boolean create_p) throws Exception {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getBag(this.cookieBagName(cookieName_p), create_p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addCookieValue(OwCookieStoreCodec.OwTimedCookieValue timedCookieValue_p) throws OwException {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            try {
                OwAttributeBagWriteable cookieTable = this.getCookieTableBag();
                OwCookieStoreCodec.OwTimedCookie timedCookie = timedCookieValue_p.getTimedCookie();
                long exTime = timedCookie.getExpirationTime();
                cookieTable.setAttribute(timedCookie.getCookieName(), "" + exTime);
                OwAttributeBagWriteable cookieBag = this.getCookieBag(timedCookie.getCookieName(), true);
                Map parameterMap = timedCookieValue_p.getParametersMap();
                Set entries = parameterMap.entrySet();
                for (Map.Entry entry : entries) {
                    String paramName = (String)entry.getKey();
                    String[] paramValues = (String[])entry.getValue();
                    if (paramName == null || paramName.length() <= 0 || paramValues == null || paramValues.length <= 0) continue;
                    if (paramValues.length > 1) {
                        String message = "The OwAttributeBagCodec does not support multi value paramerters! Multiple values were found for parameter " + paramName;
                        LOG.error((Object)("OwAttributeBagCodec.addCookieValue() : " + message));
                        throw new OwInvalidOperationException(message);
                    }
                    cookieBag.setAttribute(paramName, paramValues[0]);
                }
                cookieTable.save();
                cookieBag.save();
            }
            catch (OwInvalidOperationException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                String message = "Could not add cookie value !";
                LOG.error((Object)("OwAttributeBagCodec.addCookieValue() : " + message));
                throw new OwInvalidOperationException(message, (Throwable)e);
            }
            return;
        }
    }

    @Override
    protected List createTimedCookieCollectList() throws OwException {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            try {
                ArrayList<OwCookieStoreCodec.OwTimedCookie> collectList = new ArrayList<OwCookieStoreCodec.OwTimedCookie>();
                OwAttributeBagWriteable cookieTable = this.getCookieTableBag();
                Collection cookieNames = cookieTable.getAttributeNames();
                for (String cookieName : cookieNames) {
                    Object expirationTimeStr = cookieTable.getAttribute(cookieName);
                    if (expirationTimeStr == null) {
                        expirationTimeStr = "0";
                    }
                    long exTime = Long.parseLong(expirationTimeStr.toString());
                    OwCookieStoreCodec.OwTimedCookie timedCookie = new OwCookieStoreCodec.OwTimedCookie(cookieName, exTime);
                    collectList.add(timedCookie);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return collectList;
            }
            catch (Exception e) {
                String message = "Could not create cookie collect list !";
                LOG.error((Object)("OwAttributeBagCodec.createTimedCookieCollectList() : " + message), (Throwable)e);
                throw new OwInvalidOperationException(message, (Throwable)e);
            }
        }
    }

    @Override
    protected OwCookieStoreCodec.OwTimedCookieValue getCookieValue(String cookieName_p) throws OwException {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            try {
                OwAttributeBagWriteable cookieTable = this.getCookieTableBag();
                try {
                    Object expirationTimeStr = cookieTable.getAttribute(cookieName_p);
                    if (expirationTimeStr == null) {
                        expirationTimeStr = "0";
                    }
                    long exTime = Long.parseLong(expirationTimeStr.toString());
                    OwCookieStoreCodec.OwTimedCookie timedCookie = new OwCookieStoreCodec.OwTimedCookie(cookieName_p, exTime);
                    OwAttributeBagWriteable cookieBag = this.getCookieBag(cookieName_p, false);
                    Collection attNames = cookieBag.getAttributeNames();
                    OwParameterMap paramMap = new OwParameterMap();
                    for (String att : attNames) {
                        Object value = cookieBag.getAttribute(att);
                        if (value == null) continue;
                        paramMap.setParameter(att, value.toString());
                    }
                    Map valuesMap = paramMap.toRequestParametersMap();
                    OwCookieStoreCodec.OwTimedCookieValue timedCookieValue = new OwCookieStoreCodec.OwTimedCookieValue(valuesMap, timedCookie);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return timedCookieValue;
                }
                catch (OwObjectNotFoundException e) {
                    LOG.debug((Object)("OwAttributeBagCodec.getCookieValue():The requested cookie bag was not found : " + cookieName_p), (Throwable)e);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            catch (Exception e) {
                String message = "Could not retrieve cookie value !";
                LOG.error((Object)("OwAttributeBagCodec.getCookieValue() : " + message), (Throwable)e);
                throw new OwInvalidOperationException(message, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(OwCookieStoreCodec.OwTimedCookie timedCookie_p) throws OwException {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            try {
                OwAttributeBagWriteable cookieBag;
                OwAttributeBagWriteable cookieTable = this.getCookieTableBag();
                if (cookieTable.hasAttribute(timedCookie_p.getCookieName())) {
                    cookieTable.remove(timedCookie_p.getCookieName());
                    cookieTable.save();
                }
                if ((cookieBag = this.getCookieBag(timedCookie_p.getCookieName(), false)) != null) {
                    cookieBag.clear();
                    cookieBag.save();
                }
            }
            catch (Exception e) {
                String message = "Could not remove cookie value !";
                LOG.error((Object)("OwAttributeBagCodec.remove() :  " + message + "is this a collect+remove conflict ?"), (Throwable)e);
            }
            return;
        }
    }

    @Override
    public long getNextUnqiueNameIndex() throws OwException {
        Class<OwAttributeBagCodec> clazz = OwAttributeBagCodec.class;
        synchronized (OwAttributeBagCodec.class) {
            try {
                OwAttributeBagWriteable masterBag = this.getMasterBag();
                long index = this.getInitialValueForIndex();
                Object indexAttValue = null;
                if (masterBag.hasAttribute(MASTER_NAME_INDEX_PROPERTY)) {
                    indexAttValue = masterBag.getAttribute(MASTER_NAME_INDEX_PROPERTY);
                }
                if (indexAttValue != null) {
                    String strIndex = indexAttValue.toString();
                    index = Long.parseLong(strIndex);
                }
                String newIndex = "" + (index + 1L);
                masterBag.setAttribute(MASTER_NAME_INDEX_PROPERTY, newIndex);
                masterBag.save();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return index;
            }
            catch (Exception e) {
                String message = "Could not create unique index !";
                LOG.error((Object)("OwAttributeBagCodec.getNextUnqiueNameIndex() : " + message), (Throwable)e);
                throw new OwInvalidOperationException(message, (Throwable)e);
            }
        }
    }

    protected long getInitialValueForIndex() {
        return System.currentTimeMillis();
    }
}

