/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.paramcodec;

import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.paramcodec.OwAlphabetCoder;
import com.wewebu.ow.server.util.paramcodec.OwParameterMap;
import com.wewebu.ow.server.util.paramcodec.OwParameterMapCodec;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OwCookieStoreCodec
implements OwParameterMapCodec {
    public static final String CONFIGURATION_BOOTSTRAP_ELEMENT_NAME = "URLParameterCodec";
    public static final String CONFIGURATION_DAYS_ATTRIBUTE = "days";
    public static final String CONFIGURATION_HOURS_ATTRIBUTE = "hours";
    public static final String CONFIGURATION_MINUTES_ATTRIBUTE = "minutes";
    public static final String CONFIGURATION_NAME_ATTRIBUTE = "name";
    public static final String CONFIGURATION_SECONDS_ATTRIBUTE = "seconds";
    public static final String CONFIGURATION_URL_LIFE_TIME_ELEMENT = "URLLifeTime";
    public static final String CONFIGURATION_URL_PARAMETER_ELEMENT = "URLParameter";
    public static final long DEFAULT_CONFIG_URL_LIFE_TIME = 157680000000L;
    public static final String DEFAULT_URL_PARAMETER_NAME = "trcp";
    private static final Logger LOG = OwLogCore.getLogger(OwCookieStoreCodec.class);
    private OwAlphabetCoder m_alphabetCoder;
    private long m_namesUrlLifeTime;
    private String m_urlParameterName;

    public OwCookieStoreCodec() {
        this(DEFAULT_URL_PARAMETER_NAME, 157680000000L);
    }

    public OwCookieStoreCodec(long namesUrlLifeTime_p) {
        this(DEFAULT_URL_PARAMETER_NAME, namesUrlLifeTime_p);
    }

    public OwCookieStoreCodec(String urlParamenterName_p, long namesUrlLifeTime_p) {
        this(new OwAlphabetCoder(), urlParamenterName_p, namesUrlLifeTime_p);
    }

    public OwCookieStoreCodec(OwAlphabetCoder alphabetCder_p, String urlParamenterName_p, long namesUrlLifeTime_p) {
        this.m_alphabetCoder = alphabetCder_p;
        this.m_urlParameterName = urlParamenterName_p;
        this.m_namesUrlLifeTime = namesUrlLifeTime_p;
    }

    protected abstract void addCookieValue(OwTimedCookieValue var1) throws OwException;

    @Override
    public boolean canDecode(OwParameterMap parameterMap_p) throws OwException {
        return parameterMap_p.getParameter(this.m_urlParameterName) != null;
    }

    protected void collectExpiredNames() throws OwException {
        List collectNames = this.createTimedCookieCollectList();
        for (OwTimedCookie timedCookie : collectNames) {
            if (!timedCookie.isExipiredAt(System.currentTimeMillis())) continue;
            this.remove(timedCookie);
        }
    }

    protected abstract List createTimedCookieCollectList() throws OwException;

    @Override
    public OwParameterMap decode(OwParameterMap parameterMap_p, boolean preserveEncoding_p) throws OwException {
        String cookieName = parameterMap_p.getParameter(this.m_urlParameterName);
        if (cookieName == null) {
            String message = "No URL parameter found ! Can not decode parameter map!";
            throw new OwInvalidOperationException(message);
        }
        OwTimedCookieValue cookieValue = this.getCookieValue(cookieName);
        if (cookieValue == null || cookieValue.isExipiredAt(System.currentTimeMillis())) {
            if (cookieValue != null) {
                this.remove(cookieValue.getTimedCookie());
            }
            String message = "The requested cookie is expired : " + cookieName;
            LOG.debug((Object)("OwCookieStoreCodec.decode() : " + message));
            throw new OwUserOperationException("The requested cookie is expired : " + cookieName);
        }
        Map cookieMap = cookieValue.getParametersMap();
        OwParameterMap decodedMap = new OwParameterMap(cookieMap);
        if (preserveEncoding_p) {
            decodedMap.addAll(parameterMap_p.toRequestParametersMap());
        }
        return decodedMap;
    }

    protected String createCookie(long uniqueNameIndex_p) throws OwInvalidOperationException, OwException {
        return this.m_alphabetCoder.encode(uniqueNameIndex_p);
    }

    @Override
    public OwParameterMap encode(OwParameterMap parameterMap_p) throws OwException {
        this.collectExpiredNames();
        Map reqParameterMap = parameterMap_p.toRequestParametersMap();
        String newCookieName = this.createCookie(this.getNextUnqiueNameIndex());
        OwTimedCookie timedCookie = new OwTimedCookie(newCookieName, System.currentTimeMillis() + this.m_namesUrlLifeTime);
        OwTimedCookieValue value = new OwTimedCookieValue(reqParameterMap, timedCookie);
        this.addCookieValue(value);
        OwParameterMap encodedMap = new OwParameterMap();
        encodedMap.setParameter(this.m_urlParameterName, newCookieName);
        return encodedMap;
    }

    protected abstract OwTimedCookieValue getCookieValue(String var1) throws OwException;

    protected abstract void remove(OwTimedCookie var1) throws OwException;

    public static long loadUrlLifeTimeConfig(OwXMLUtil codecConfiguration_p) throws Exception {
        long urlLifeTime = 157680000000L;
        OwXMLUtil urlLifeTimeUtil = codecConfiguration_p.getSubUtil(CONFIGURATION_URL_LIFE_TIME_ELEMENT);
        if (urlLifeTimeUtil == null) {
            LOG.debug((Object)"OwCookieStoreCodec.loadExpirationTimeConfig(): configuration is missing for URLLifeTime! Proceeding with default life time:157680000000 ms");
        } else {
            long seconds;
            long minutes;
            long hours;
            long days = urlLifeTimeUtil.getSafeIntegerAttributeValue(CONFIGURATION_DAYS_ATTRIBUTE, 0);
            urlLifeTime = days * 86400000L + (hours = (long)urlLifeTimeUtil.getSafeIntegerAttributeValue(CONFIGURATION_HOURS_ATTRIBUTE, 0)) * 3600000L + (minutes = (long)urlLifeTimeUtil.getSafeIntegerAttributeValue(CONFIGURATION_MINUTES_ATTRIBUTE, 0)) * 60000L + (seconds = (long)urlLifeTimeUtil.getSafeIntegerAttributeValue(CONFIGURATION_SECONDS_ATTRIBUTE, 0)) * 1000L;
            if (urlLifeTime == 0L) {
                urlLifeTime = 157680000000L;
                LOG.debug((Object)("OwCookieStoreCodec.loadExpirationTimeConfig(): invalid expiration time! Proceeding with default " + urlLifeTime + " ms"));
            }
            if (urlLifeTime < 0L) {
                LOG.warn((Object)("OwCookieStoreCodec.loadExpirationTimeConfig(): invalid expiration time! Negative value for URLLifeTime: " + urlLifeTime + " ms"));
            }
        }
        return urlLifeTime;
    }

    public static String loadUrlParameterConfig(OwXMLUtil codecConfiguration_p) throws Exception {
        String urlParameter = DEFAULT_URL_PARAMETER_NAME;
        OwXMLUtil urlParameterUtil = codecConfiguration_p.getSubUtil(CONFIGURATION_URL_PARAMETER_ELEMENT);
        if (urlParameterUtil == null) {
            LOG.debug((Object)"OwCookieStoreCodec.loadUrlParameterConfig(): configuration is missing for the URL parameter name ! Proceeding with default trcp");
        } else {
            urlParameter = urlParameterUtil.getSafeStringAttributeValue(CONFIGURATION_NAME_ATTRIBUTE, "");
            if (urlParameter == null || urlParameter.length() == 0) {
                LOG.debug((Object)"OwCookieStoreCodec.loadUrlParameterConfig(): configuration is missing for the URL parameter name ! Proceeding with default trcp");
                urlParameter = DEFAULT_URL_PARAMETER_NAME;
            }
        }
        return urlParameter;
    }

    protected static class OwTimedCookieValue {
        private Map m_parametersMap;
        private OwTimedCookie m_timedCookie;

        public OwTimedCookieValue(Map parametersMap_p, OwTimedCookie timedCookie_p) {
            this.m_parametersMap = parametersMap_p;
            this.m_timedCookie = timedCookie_p;
        }

        public String getCookieName() {
            return this.m_timedCookie.getCookieName();
        }

        public Map getParametersMap() {
            return this.m_parametersMap;
        }

        public OwTimedCookie getTimedCookie() {
            return this.m_timedCookie;
        }

        public boolean isExipiredAt(long time_p) {
            return this.m_timedCookie.isExipiredAt(time_p);
        }
    }

    protected static class OwTimedCookie {
        private String m_cookieName;
        private long m_expirationTime;

        public OwTimedCookie(String cookieName_p, long expirationTime_p) {
            this.m_cookieName = cookieName_p;
            this.m_expirationTime = expirationTime_p;
        }

        public String getCookieName() {
            return this.m_cookieName;
        }

        public long getExpirationTime() {
            return this.m_expirationTime;
        }

        public boolean isExipiredAt(long time_p) {
            return this.m_expirationTime < time_p;
        }
    }
}

