/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.util.paramcodec;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.paramcodec.OwAttributeBagCodec;
import org.apache.log4j.Logger;

public class OwNetworkAttributeBagCodec
extends OwAttributeBagCodec {
    private static final Logger LOG = OwLogCore.getLogger(OwNetworkAttributeBagCodec.class);
    public static final String DEFAULT_CODEC_BAGS_PSEUDO_USER = "att_bag_codec";
    private OwNetwork m_network;
    private String m_codecBagsUser = "att_bag_codec";

    public static OwNetworkAttributeBagCodec createConfiguredCodec(OwMainAppContext context_p) throws OwInvalidOperationException {
        try {
            OwNetwork<?> network_p = context_p.getNetwork();
            OwConfiguration configuration = context_p.getConfiguration();
            OwXMLUtil bootstrapConfiguration = configuration.getBootstrapConfiguration();
            OwXMLUtil codecConfiguration = bootstrapConfiguration.getSubUtil("URLParameterCodec");
            long urlLifeTime = 157680000000L;
            String codecBagsPrefix = "codec_bag_";
            String cookieBagsPrefix = "cc_";
            String user = "OW_GLOBAL";
            String cookieParameter = "trcp";
            if (codecConfiguration == null) {
                LOG.debug((Object)"OwNetworkAttributeBagCodec.createConfiguredCodec(): configuration is missing ! Proceeding with the following default values:");
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): default URL life time  \t        :" + urlLifeTime + " ms"));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): default codec bags prefix        :" + codecBagsPrefix));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): default cookie bags prefix       :" + cookieBagsPrefix));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): default bags user name           :" + user));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): default URL parameter name    :" + cookieParameter));
            } else {
                urlLifeTime = OwNetworkAttributeBagCodec.loadUrlLifeTimeConfig(codecConfiguration);
                cookieParameter = OwNetworkAttributeBagCodec.loadUrlParameterConfig(codecConfiguration);
                String[] attributeBagsConfig = OwNetworkAttributeBagCodec.loadAttributeBagsConfiguation(codecConfiguration);
                codecBagsPrefix = attributeBagsConfig[0];
                cookieBagsPrefix = attributeBagsConfig[1];
                user = attributeBagsConfig[2];
            }
            if (codecConfiguration != null) {
                LOG.debug((Object)"OwNetworkAttributeBagCodec.createConfiguredCodec(): Creating codec with the following loaded configuration :");
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): URL life time          :" + urlLifeTime + " ms"));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): codec bags prefix        :" + codecBagsPrefix));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): cookie bags prefix       :" + cookieBagsPrefix));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): bags user name           :" + user));
                LOG.debug((Object)("OwNetworkAttributeBagCodec.createConfiguredCodec(): URL parameter name    :" + cookieParameter));
            }
            return new OwNetworkAttributeBagCodec(network_p, cookieParameter, urlLifeTime, codecBagsPrefix, cookieBagsPrefix, user);
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not load the configured OwNetworkAttributeBagCodec!", (Throwable)e);
        }
    }

    public OwNetworkAttributeBagCodec(OwNetwork netowrk_p, String cookieParameterName_p, long namesExpirationTime_p, String codecBagsPrefix_p, String cookieBagsPrefix_p, String codecBagsUser_p) {
        super(cookieParameterName_p, namesExpirationTime_p, codecBagsPrefix_p, cookieBagsPrefix_p);
        this.m_network = netowrk_p;
        this.m_codecBagsUser = codecBagsUser_p;
    }

    @Override
    protected OwAttributeBagWriteable getBag(String bagName_p, boolean create_p) throws Exception {
        OwAttributeBagWriteable attributeBagWriteable = (OwAttributeBagWriteable)this.m_network.getApplicationObject(7, bagName_p, this.m_codecBagsUser, true, create_p);
        return attributeBagWriteable;
    }
}

